/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.dialects.MysqlExceptionRecognizer;
import com.intellij.database.remote.jdba.jdbc.dialects.MysqlIntermediateFacade;
import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.helpers.GBaseJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.database.remote.jdbc.helpers.MariaJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.MemJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.MysqlJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.RemoteLogHelper;
import com.intellij.database.remote.jdbc.impl.BitString;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ThrowableConsumer;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MysqlBaseJdbcHelper
extends JdbcHelperImpl {
    public static final String AURORA = "MYSQL AURORA";
    public static final String MYSQL = "MYSQL";
    public static final String MARIADB = "MARIADB";
    public static final String MEMSQL = "MEMSQL";
    private static final List<JdbcHelperImpl.PropertyReplacement> REPLACEMENTS = Collections.singletonList(new JdbcHelperImpl.PropertyReplacement("zeroDateTimeBehavior", Collections.singletonList(Couple.of((Object)"convertToNull", (Object)"CONVERT_TO_NULL"))){

        @Override
        @NotNull
        JdbcHelperImpl.PropertyReplacement.Direction getDirection(@NotNull Driver driver) {
            int version;
            if (driver == null) {
                2.$$$reportNull$$$0(0);
            }
            JdbcHelperImpl.PropertyReplacement.Direction direction = (version = driver.getMajorVersion()) >= 8 ? JdbcHelperImpl.PropertyReplacement.Direction.FORWARD : JdbcHelperImpl.PropertyReplacement.Direction.BACKWARD;
            if (direction == null) {
                2.$$$reportNull$$$0(1);
            }
            return direction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "driver";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/MysqlBaseJdbcHelper$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/MysqlBaseJdbcHelper$2";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDirection";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getDirection";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    });

    public MysqlBaseJdbcHelper(@NotNull String dbmsName, @Nullable String version, @Nullable Connection connection) {
        if (dbmsName == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(0);
        }
        super(dbmsName, version, connection);
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull JdbcConnectionProvider ds) {
        if (ds == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(1);
        }
        return new MysqlIntermediateFacade(ds, MysqlExceptionRecognizer.INSTANCE, this);
    }

    @Override
    public void setStatementParameter(@NotNull RemotePreparedStatement statement, @Nullable Object value, @NotNull ColumnInfo columnInfo, boolean needsEscaping, int idx) throws Exception {
        if (statement == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(2);
        }
        if (columnInfo == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(3);
        }
        String typeName = columnInfo.getTypeName();
        if (value instanceof String && "bit".equalsIgnoreCase(typeName)) {
            MysqlBaseJdbcHelper.setBits(statement, (String)value, idx);
        } else {
            super.setStatementParameter(statement, value, columnInfo, needsEscaping, idx);
        }
    }

    private static void setBits(@NotNull RemotePreparedStatement statement, @NotNull String value, int idx) throws Exception {
        if (statement == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(4);
        }
        if (value == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(5);
        }
        int length = value.length();
        int size = length / 8 + (length % 8 > 0 ? 1 : 0);
        byte[] bytes = new byte[size];
        for (int i = 0; i < size; ++i) {
            int start = Math.max(length - (i + 1) * 8, 0);
            int end = length - i * 8;
            String substring = value.substring(start, end);
            bytes[size - i - 1] = (byte)Short.parseShort(substring, 2);
        }
        statement.setBytes(idx, bytes);
    }

    @Override
    @NotNull
    protected String getCharsToEscape() {
        return "%_\\#";
    }

    @Override
    public int fixJdbcType(@Nullable String typeName, @Nullable String clazz, int type) {
        if (type == 91 && "YEAR".equals(typeName) && Short.class.getCanonicalName().equals(clazz)) {
            return 5;
        }
        return super.fixJdbcType(typeName, clazz, type);
    }

    @Override
    @Nullable
    protected Object tryGetObject(@NotNull RemoteResultSet.DataRetrievingOptions options, @NotNull ResultSet resultSet, @NotNull ResultSetMetaData metaData, int index) throws SQLException {
        int precision;
        String typeName;
        if (options == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(6);
        }
        if (resultSet == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(7);
        }
        if (metaData == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(8);
        }
        if ("bit".equalsIgnoreCase(typeName = metaData.getColumnTypeName(index)) && !options.raw && (precision = metaData.getPrecision(index)) > 1) {
            byte[] bytes = resultSet.getBytes(index);
            return BitString.of(bytes);
        }
        return super.tryGetObject(options, resultSet, metaData, index);
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(9);
        }
        if (e.typeName == null) {
            return;
        }
        String us = " unsigned";
        if (StringUtilRt.endsWithIgnoreCase((CharSequence)e.typeName, (CharSequence)us)) {
            int end = e.typeName.length() - us.length();
            e.typeSuffix = e.typeName.substring(end + 1);
            e.typeName = e.typeName.substring(0, end);
        }
    }

    @Override
    @Nullable
    public final JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer) throws Exception {
        String auroraVersion;
        String[] stringArray;
        if (!JdbcNativeUtil.detectString(product, MYSQL) && !JdbcNativeUtil.detectString(product, MARIADB)) {
            return null;
        }
        if (delegate == null) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = productVer;
            stringArray2[1] = productVer;
            stringArray = stringArray2;
            stringArray2[2] = null;
        } else {
            stringArray = JdbcNativeUtil.getStrings(delegate, "select version(), @@version_comment, database()");
        }
        String[] v = stringArray;
        String ver = v.length < 1 ? null : v[0];
        String verComment = v.length < 2 ? null : v[1];
        String db = v.length < 3 ? null : v[2];
        JdbcNativeUtil.logInfo("@@version_comment: " + verComment + "\nversion(): " + ver + "\ndatabase(): " + db);
        if (verComment == null && "gitbase".equals(db) && GBaseJdbcHelper.extractVersion(ver) != null) {
            return GBaseJdbcHelper.create(delegate, ver);
        }
        if (JdbcNativeUtil.detectString(verComment, MEMSQL)) {
            return MemJdbcHelper.create(delegate, delegate == null ? ver : JdbcNativeUtil.getString(delegate, "select @@memsql_version"));
        }
        if (JdbcNativeUtil.detectString(ver, MARIADB) || JdbcNativeUtil.detectString(verComment, MARIADB)) {
            return MariaJdbcHelper.create(delegate, ver);
        }
        String string = auroraVersion = delegate == null ? null : JdbcNativeUtil.getString(delegate, "show variables like 'aurora\\_version'", 2);
        if (auroraVersion != null) {
            return new MysqlJdbcHelper(AURORA, MysqlJdbcHelper.extractVersion(auroraVersion), delegate);
        }
        return MysqlJdbcHelper.create(delegate, ver);
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(10);
        }
        return MysqlBaseJdbcHelper.classNameContains(driver, "mysql");
    }

    @Override
    protected void enableSsl(@NotNull Driver driver, @NotNull Properties properties, @NotNull JdbcSettings.SslMode sslMode) {
        if (driver == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(11);
        }
        if (properties == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(12);
        }
        if (sslMode == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(13);
        }
        MysqlBaseJdbcHelper.setIfEmpty(properties, "useSSL", "true");
        MysqlBaseJdbcHelper.setIfEmpty(properties, "requireSSL", "true");
        if (sslMode != JdbcSettings.SslMode.REQUIRE) {
            MysqlBaseJdbcHelper.setIfEmpty(properties, "verifyServerCertificate", "true");
        }
        MysqlBaseJdbcHelper.setIfEmpty(properties, "sslMode", MysqlBaseJdbcHelper.getSslMode(sslMode));
    }

    @Override
    @Nullable
    public JdbcSettings.SslMode[] supportedSslModes() {
        return JdbcSettings.SslMode.values();
    }

    @NotNull
    private static String getSslMode(@NotNull JdbcSettings.SslMode sslMode) {
        if (sslMode == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(14);
        }
        switch (sslMode) {
            case VERIFY_FULL: {
                return "VERIFY_IDENTITY";
            }
            case REQUIRE: {
                return "REQUIRED";
            }
        }
        return "VERIFY_CA";
    }

    @Override
    public boolean canChangePassword(@NotNull Driver driver, String url, @NotNull Properties properties) {
        if (driver == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(15);
        }
        if (properties == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(16);
        }
        return true;
    }

    @Override
    @Nullable
    public final Connection connect(@NotNull Driver driver, String url, @NotNull Properties properties, @NotNull Map<String, Serializable> extra) throws SQLException {
        if (driver == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(17);
        }
        if (properties == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(18);
        }
        if (extra == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(19);
        }
        return super.connect(driver, url, MysqlBaseJdbcHelper.replaceInvalidProperties(driver, properties, REPLACEMENTS), extra);
    }

    @Override
    protected void setDriverLogLevel(Driver driver, Properties properties, Level level, String logPath) {
        MysqlBaseJdbcHelper.setIfEmpty(properties, "logger", "Jdk14Logger");
        if (level != null) {
            RemoteLogHelper.setLogLevel("MySQL", level);
            if (Level.FINEST.intValue() >= level.intValue()) {
                MysqlBaseJdbcHelper.setIfEmpty(properties, "traceProtocol", "true");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeExpiredPassword(@NotNull Driver driver, String url, @NotNull Properties properties, @NotNull Map<String, Serializable> extra, final @NotNull String newPassword) throws SQLException {
        if (driver == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(20);
        }
        if (properties == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(21);
        }
        if (extra == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(22);
        }
        if (newPassword == null) {
            MysqlBaseJdbcHelper.$$$reportNull$$$0(23);
        }
        MysqlBaseJdbcHelper.setIfEmpty(properties, "disconnectOnExpiredPasswords", "false");
        MysqlBaseJdbcHelper.setIfEmpty(properties, "jdbcCompliantTruncation", "false");
        MysqlBaseJdbcHelper.setIfEmpty(properties, "useLocalSessionState", "true");
        Connection c = this.connect(driver, url, properties, extra);
        if (c == null) {
            throw new AssertionError((Object)"Null connection");
        }
        try {
            JdbcNativeUtil.prepared(c, "alter user user() identified by ?", new ThrowableConsumer<PreparedStatement, SQLException>(){

                public void consume(PreparedStatement statement) throws SQLException {
                    statement.setString(1, newPassword);
                    statement.execute();
                }
            });
        }
        finally {
            MysqlBaseJdbcHelper.closeSafe(c);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbmsName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 12: 
            case 16: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sslMode";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extra";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPassword";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/MysqlBaseJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createFacade";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setStatementParameter";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setBits";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "tryGetObject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "detect";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "enableSsl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getSslMode";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "canChangePassword";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "connect";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "changeExpiredPassword";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

