/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import org.jetbrains.annotations.NotNull;

abstract class JdbcUtil {
    JdbcUtil() {
    }

    static String getColumnName(@NotNull ResultSetMetaData md, int columnIndex) throws SQLException {
        boolean sybaseNative;
        if (md == null) {
            JdbcUtil.$$$reportNull$$$0(0);
        }
        return !(sybaseNative = md.getClass().getSimpleName().equals("RowFormat2Token")) ? md.getColumnName(columnIndex) : md.getColumnLabel(columnIndex);
    }

    static int getFetchDirection(@NotNull ResultSet rset) throws SQLException {
        if (rset == null) {
            JdbcUtil.$$$reportNull$$$0(1);
        }
        try {
            return rset.getFetchDirection();
        }
        catch (UnsupportedOperationException uoe) {
            return 1000;
        }
    }

    static void setFetchDirection(@NotNull ResultSet rset, int fetchDirection) throws SQLException {
        if (rset == null) {
            JdbcUtil.$$$reportNull$$$0(2);
        }
        try {
            rset.setFetchDirection(fetchDirection);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (AbstractMethodError abstractMethodError) {
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    static void setFetchSize(@NotNull ResultSet rset, int rows) throws SQLException {
        if (rset == null) {
            JdbcUtil.$$$reportNull$$$0(3);
        }
        try {
            rset.setFetchSize(rows);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (AbstractMethodError abstractMethodError) {
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    static void setFetchSize(@NotNull Statement stmt, int rows) throws SQLException {
        if (stmt == null) {
            JdbcUtil.$$$reportNull$$$0(4);
        }
        try {
            stmt.setFetchSize(rows);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (AbstractMethodError abstractMethodError) {
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    static boolean isClosed(Connection connection) throws SQLException {
        if (connection == null) {
            return true;
        }
        try {
            return connection.isClosed();
        }
        catch (AbstractMethodError ame) {
            return false;
        }
        catch (UnsupportedOperationException uoe) {
            return false;
        }
    }

    static boolean isClosed(Statement statement) throws SQLException {
        if (statement == null) {
            return true;
        }
        try {
            return statement.isClosed();
        }
        catch (AbstractMethodError ame) {
            return false;
        }
        catch (UnsupportedOperationException uoe) {
            return false;
        }
    }

    static boolean isClosed(ResultSet rset) throws SQLException {
        if (rset == null) {
            return true;
        }
        try {
            return rset.isClosed();
        }
        catch (AbstractMethodError ame) {
            return false;
        }
        catch (UnsupportedOperationException uoe) {
            return false;
        }
        catch (SQLException e) {
            return false;
        }
    }

    static void close(Connection connection) {
        try {
            if (JdbcUtil.isClosed(connection)) {
                return;
            }
            connection.close();
        }
        catch (Exception e) {
            JdbcUtil.printCloseException(e, connection.getClass());
        }
    }

    static void close(Statement statement) {
        try {
            if (!JdbcUtil.isClosed(statement)) {
                statement.close();
            }
        }
        catch (Exception e) {
            JdbcUtil.printCloseException(e, statement.getClass());
        }
    }

    static void close(ResultSet rset) {
        try {
            if (!JdbcUtil.isClosed(rset)) {
                rset.close();
            }
        }
        catch (Exception e) {
            JdbcUtil.printCloseException(e, rset.getClass());
        }
    }

    static void printCloseException(Exception e, Class serviceClass) {
        String operation = "close JDBC object (" + serviceClass.getCanonicalName() + ")";
        JdbcUtil.printOperationException(e, operation);
    }

    static void printOperationException(Exception e, String operation) {
        String message;
        if (e instanceof SQLException) {
            SQLException sqle = (SQLException)e;
            message = String.format("JDBC ERROR: Failed to " + operation + ". SQL exception class (%s) encountered, with SQL state %s, error code %d and message: %s", sqle.getClass().getName(), sqle.getSQLState(), sqle.getErrorCode(), sqle.getMessage());
        } else {
            message = String.format("JDBC ERROR: Failed to " + operation + ". Exception class (%s) encountered with message: %s", e.getClass().getName(), e.getMessage());
        }
        System.err.println(message);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "md";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rset";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stmt";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdba/jdbc/JdbcUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getColumnName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getFetchDirection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setFetchDirection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setFetchSize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

