/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize.kryo;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nullable;
import org.gradle.internal.impldep.com.esotericsoftware.kryo.io.Output;
import org.gradle.internal.serialize.AbstractEncoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.FlushableEncoder;

public class KryoBackedEncoder
extends AbstractEncoder
implements FlushableEncoder,
Closeable {
    private final Output output;
    private KryoBackedEncoder nested;

    public KryoBackedEncoder(OutputStream outputStream) {
        this(outputStream, 4096);
    }

    public KryoBackedEncoder(OutputStream outputStream, int bufferSize) {
        this.output = new Output(outputStream, bufferSize);
    }

    @Override
    public void writeByte(byte value) {
        this.output.writeByte(value);
    }

    @Override
    public void writeBytes(byte[] bytes, int offset, int count) {
        this.output.writeBytes(bytes, offset, count);
    }

    @Override
    public void writeLong(long value) {
        this.output.writeLong(value);
    }

    @Override
    public void writeSmallLong(long value) {
        this.output.writeLong(value, true);
    }

    @Override
    public void writeInt(int value) {
        this.output.writeInt(value);
    }

    @Override
    public void writeSmallInt(int value) {
        this.output.writeInt(value, true);
    }

    @Override
    public void writeBoolean(boolean value) {
        this.output.writeBoolean(value);
    }

    @Override
    public void writeString(CharSequence value) {
        if (value == null) {
            throw new IllegalArgumentException("Cannot encode a null string.");
        }
        this.output.writeString(value);
    }

    @Override
    public void writeNullableString(@Nullable CharSequence value) {
        this.output.writeString(value);
    }

    @Override
    public void encodeChunked(Encoder.EncodeAction<Encoder> writeAction) throws Exception {
        if (this.nested == null) {
            this.nested = new KryoBackedEncoder(new OutputStream(){

                @Override
                public void write(byte[] buffer, int offset, int length) {
                    if (length == 0) {
                        return;
                    }
                    KryoBackedEncoder.this.writeSmallInt(length);
                    KryoBackedEncoder.this.writeBytes(buffer, offset, length);
                }

                @Override
                public void write(byte[] buffer) throws IOException {
                    this.write(buffer, 0, buffer.length);
                }

                @Override
                public void write(int b) {
                    throw new UnsupportedOperationException();
                }
            });
        }
        writeAction.write(this.nested);
        this.nested.flush();
        this.writeSmallInt(0);
    }

    public long getWritePosition() {
        return this.output.total();
    }

    @Override
    public void flush() {
        this.output.flush();
    }

    @Override
    public void close() {
        this.output.close();
    }
}

