/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.detection;

import java.util.regex.Pattern;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.internal.file.RelativeFile;
import org.gradle.api.internal.tasks.testing.DefaultTestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.detection.TestFrameworkDetector;

public class DefaultTestClassScanner
implements Runnable {
    private static final Pattern ANONYMOUS_CLASS_NAME = Pattern.compile(".*\\$\\d+");
    private final FileTree candidateClassFiles;
    private final TestFrameworkDetector testFrameworkDetector;
    private final TestClassProcessor testClassProcessor;

    public DefaultTestClassScanner(FileTree candidateClassFiles, TestFrameworkDetector testFrameworkDetector, TestClassProcessor testClassProcessor) {
        this.candidateClassFiles = candidateClassFiles;
        this.testFrameworkDetector = testFrameworkDetector;
        this.testClassProcessor = testClassProcessor;
    }

    @Override
    public void run() {
        if (this.testFrameworkDetector == null) {
            this.filenameScan();
        } else {
            this.detectionScan();
        }
    }

    private void detectionScan() {
        this.testFrameworkDetector.startDetection(this.testClassProcessor);
        this.candidateClassFiles.visit(new ClassFileVisitor(){

            @Override
            public void visitClassFile(FileVisitDetails fileDetails) {
                DefaultTestClassScanner.this.testFrameworkDetector.processTestClass(new RelativeFile(fileDetails.getFile(), fileDetails.getRelativePath()));
            }
        });
    }

    private void filenameScan() {
        this.candidateClassFiles.visit(new ClassFileVisitor(){

            @Override
            public void visitClassFile(FileVisitDetails fileDetails) {
                DefaultTestClassRunInfo testClass = new DefaultTestClassRunInfo(DefaultTestClassScanner.this.getClassName(fileDetails));
                DefaultTestClassScanner.this.testClassProcessor.processTestClass(testClass);
            }
        });
    }

    private String getClassName(FileVisitDetails fileDetails) {
        return fileDetails.getRelativePath().getPathString().replaceAll("\\.class", "").replace('/', '.');
    }

    private abstract class ClassFileVisitor
    extends EmptyFileVisitor {
        private ClassFileVisitor() {
        }

        @Override
        public void visitFile(FileVisitDetails fileDetails) {
            if (this.isClass(fileDetails) && !this.isAnonymousClass(fileDetails)) {
                this.visitClassFile(fileDetails);
            }
        }

        abstract void visitClassFile(FileVisitDetails var1);

        private boolean isAnonymousClass(FileVisitDetails fileVisitDetails) {
            return ANONYMOUS_CLASS_NAME.matcher(DefaultTestClassScanner.this.getClassName(fileVisitDetails)).matches();
        }

        private boolean isClass(FileVisitDetails fileVisitDetails) {
            String fileName = fileVisitDetails.getFile().getName();
            return fileName.endsWith(".class") && !"module-info.class".equals(fileName);
        }
    }
}

