/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import java.util.Collections;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.internal.DefaultMutationGuard;
import org.gradle.api.internal.MutationGuard;
import org.gradle.api.internal.WithMutationGuard;
import org.gradle.api.internal.project.CrossProjectConfigurator;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.Actions;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;

public class BuildOperationCrossProjectConfigurator
implements CrossProjectConfigurator,
WithMutationGuard {
    private final BuildOperationExecutor buildOperationExecutor;
    private final MutationGuard mutationGuard = new DefaultMutationGuard();
    private static final String ALLPROJECTS = "allprojects";
    private static final String SUBPROJECTS = "subprojects";
    private static final String ROOTPROJECT = "rootProject";
    private static final BuildOperationDescriptor.Builder ALLPROJECTS_DETAILS = BuildOperationCrossProjectConfigurator.computeConfigurationBlockBuildOperationDetails("allprojects");
    private static final BuildOperationDescriptor.Builder SUBPROJECTS_DETAILS = BuildOperationCrossProjectConfigurator.computeConfigurationBlockBuildOperationDetails("subprojects");
    private static final BuildOperationDescriptor.Builder ROOT_PROJECT_DETAILS = BuildOperationCrossProjectConfigurator.computeConfigurationBlockBuildOperationDetails("rootProject");

    public BuildOperationCrossProjectConfigurator(BuildOperationExecutor buildOperationExecutor) {
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public void project(ProjectInternal project, Action<? super Project> configureAction) {
        this.runProjectConfigureAction(project, configureAction);
    }

    @Override
    public void subprojects(Iterable<? extends ProjectInternal> projects, Action<? super Project> configureAction) {
        this.runBlockConfigureAction(SUBPROJECTS_DETAILS, projects, configureAction);
    }

    @Override
    public void allprojects(Iterable<? extends ProjectInternal> projects, Action<? super Project> configureAction) {
        this.runBlockConfigureAction(ALLPROJECTS_DETAILS, projects, configureAction);
    }

    @Override
    public void rootProject(ProjectInternal project, Action<? super Project> buildOperationExecutor) {
        this.runBlockConfigureAction(ROOT_PROJECT_DETAILS, Collections.singleton(project), buildOperationExecutor);
    }

    private void runBlockConfigureAction(BuildOperationDescriptor.Builder details, Iterable<? extends ProjectInternal> projects, Action<? super Project> configureAction) {
        this.buildOperationExecutor.run(new BlockConfigureBuildOperation(details, projects, configureAction));
    }

    private void runProjectConfigureAction(final ProjectInternal project, final Action<? super Project> configureAction) {
        project.getOwner().applyToMutableState(p -> this.buildOperationExecutor.run(new CrossConfigureProjectBuildOperation(project){

            @Override
            public void run(BuildOperationContext context) {
                Actions.with(project, BuildOperationCrossProjectConfigurator.this.mutationGuard.withMutationEnabled(configureAction));
            }
        }));
    }

    @Override
    public MutationGuard getMutationGuard() {
        return this.mutationGuard;
    }

    private static BuildOperationDescriptor.Builder computeConfigurationBlockBuildOperationDetails(String configurationBlockName) {
        return BuildOperationDescriptor.displayName("Execute '" + configurationBlockName + " {}' action").name(configurationBlockName);
    }

    private static abstract class CrossConfigureProjectBuildOperation
    implements RunnableBuildOperation {
        private final Project project;

        private CrossConfigureProjectBuildOperation(Project project) {
            this.project = project;
        }

        @Override
        public BuildOperationDescriptor.Builder description() {
            String name = "Cross-configure project " + ((ProjectInternal)this.project).getIdentityPath().toString();
            return BuildOperationDescriptor.displayName(name);
        }
    }

    private class BlockConfigureBuildOperation
    implements RunnableBuildOperation {
        private final BuildOperationDescriptor.Builder details;
        private final Iterable<? extends ProjectInternal> projects;
        private final Action<? super Project> configureAction;

        private BlockConfigureBuildOperation(BuildOperationDescriptor.Builder details, Iterable<? extends ProjectInternal> projects, Action<? super Project> configureAction) {
            this.details = details;
            this.projects = projects;
            this.configureAction = configureAction;
        }

        @Override
        public BuildOperationDescriptor.Builder description() {
            return this.details;
        }

        @Override
        public void run(BuildOperationContext context) {
            for (ProjectInternal projectInternal : this.projects) {
                BuildOperationCrossProjectConfigurator.this.runProjectConfigureAction(projectInternal, this.configureAction);
            }
        }
    }
}

