/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;

public interface TransformOutputsInternal
extends TransformOutputs {
    public static OutputLocationType determineOutputLocationType(File output, File inputArtifact, String inputArtifactPrefix, File outputDir, String outputDirPrefix) {
        if (output.equals(inputArtifact)) {
            return OutputLocationType.INPUT_ARTIFACT;
        }
        if (output.equals(outputDir)) {
            return OutputLocationType.WORKSPACE;
        }
        if (output.getPath().startsWith(outputDirPrefix)) {
            return OutputLocationType.WORKSPACE;
        }
        if (output.getPath().startsWith(inputArtifactPrefix)) {
            return OutputLocationType.INPUT_ARTIFACT;
        }
        throw new InvalidUserDataException("Transform output " + output.getPath() + " must be a part of the input artifact or refer to a relative path.");
    }

    public static void validateOutputExists(String outputDirPrefix, File output) {
        if (!output.exists()) {
            String outputAbsolutePath = output.getAbsolutePath();
            String reportedPath = outputAbsolutePath.startsWith(outputDirPrefix) ? outputAbsolutePath.substring(outputDirPrefix.length()) : outputAbsolutePath;
            throw new InvalidUserDataException("Transform output " + reportedPath + " must exist.");
        }
    }

    public ImmutableList<File> getRegisteredOutputs();

    public static enum OutputLocationType {
        INPUT_ARTIFACT,
        WORKSPACE;

    }
}

