/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.remotebrowser;

import com.intellij.ide.DeleteProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DistinctRootsCollections;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ProjectDeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.ServerBrowserTask;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.WebDeploymentDataKeys;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ServerItemsDeleteProvider
implements DeleteProvider {
    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ServerItemsDeleteProvider.$$$reportNull$$$0(0);
        }
        if (PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext) == null) {
            return false;
        }
        Deployable server = (Deployable)WebDeploymentDataKeys.DEPLOYABLE.getData(dataContext);
        if (server == null) {
            return false;
        }
        ServerTreeNode[] nodes = (ServerTreeNode[])WebDeploymentDataKeys.SERVER_NODES.getData(dataContext);
        if (nodes == null || nodes.length == 0) {
            return false;
        }
        for (ServerTreeNode node : nodes) {
            if (!node.isRoot()) continue;
            return false;
        }
        return true;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        String message;
        if (dataContext == null) {
            ServerItemsDeleteProvider.$$$reportNull$$$0(1);
        }
        Deployable server = (Deployable)WebDeploymentDataKeys.DEPLOYABLE.getData(dataContext);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        ServerTreeNode[] nodes = (ServerTreeNode[])WebDeploymentDataKeys.SERVER_NODES.getData(dataContext);
        if (nodes.length == 1) {
            String path = server.getPresentablePath(nodes[0].getPath());
            message = WDBundle.message("delete.item.warning", nodes[0].isDirectory() ? 2 : 1, path);
        } else {
            message = WDBundle.message("delete.items.warning", nodes.length);
        }
        if (Messages.showYesNoDialog((Project)project, (String)message, (String)WDBundle.message("delete.items.prompt", server.getName()), (Icon)Messages.getWarningIcon()) != 0) {
            return;
        }
        DistinctRootsCollections.ServerTreeNodes roots = new DistinctRootsCollections.ServerTreeNodes(nodes, server.isCaseSensitive());
        new ServerBrowserTask(project, ConnectionOwnerFactory.createConnectionOwner(project), PublishConfig.getInstance(project), server, WDBundle.message("delete.remote.items.task.title", new Object[0]), ProjectDeploymentRevisionTracker.getInstance(project), true, (Collection)((Object)roots), server){
            final /* synthetic */ Collection val$roots;
            final /* synthetic */ Deployable val$server;
            {
                this.val$roots = collection;
                this.val$server = deployable;
                super(project, connectionOwner, publishConfig, server, title, revisionTracker, serverSideModification);
            }

            @Override
            @NotNull
            protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext context) {
                ArrayList<TransferOperation.Delete> result = new ArrayList<TransferOperation.Delete>();
                for (ServerTreeNode root : this.val$roots) {
                    context.getProgressIndicator().checkCanceled();
                    context.getProgressIndicator().setText(WDBundle.message("processing.0", this.val$server.getPresentablePath(root.getPath())));
                    result.add(new TransferOperation.Delete(root.getPath(), root.isDirectory(), false));
                }
                return new TransferTask.ListBased.ResultWithErrors(result, new DeploymentPathUtils.ErrorsAndExclusions());
            }
        }.queue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "dataContext";
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/remotebrowser/ServerItemsDeleteProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canDeleteElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

