/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.remoteEdit;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.remoteEdit.fs.RemoteVirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteFileEditorTitleTabProvider
implements EditorTabTitleProvider {
    @NlsContexts.TabTitle
    @Nullable
    public String getEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file) {
        String presentableName;
        if (project == null) {
            RemoteFileEditorTitleTabProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            RemoteFileEditorTitleTabProvider.$$$reportNull$$$0(1);
        }
        if (!(file instanceof RemoteVirtualFile)) {
            return null;
        }
        RemoteVirtualFile remoteFile = (RemoteVirtualFile)file;
        Deployable oldServerConfig = remoteFile.getServerConfig();
        String oldServerConfigId = oldServerConfig.getId();
        String uniqueName = RemoteFileEditorTitleTabProvider.getUniqueName(project, file);
        if (uniqueName.startsWith("<" + oldServerConfigId)) {
            String endSeparator = ">";
            int i = uniqueName.indexOf(">");
            uniqueName = uniqueName.substring(i + ">".length());
        }
        String serverName = StringUtil.isNotEmpty((String)(presentableName = remoteFile.getPresentableServerName())) ? presentableName : RemoteFileEditorTitleTabProvider.getServerName(project, oldServerConfig, oldServerConfigId);
        return "<" + serverName + "> " + uniqueName;
    }

    @NlsSafe
    private static String getServerName(@Nullable Project project, @NotNull Deployable oldServerConfig, @Nullable String oldServerConfigId) {
        WebServerConfig currentServer;
        if (oldServerConfig == null) {
            RemoteFileEditorTitleTabProvider.$$$reportNull$$$0(2);
        }
        return (currentServer = GroupedServersConfigManager.getInstance(project).findServer(oldServerConfigId)) == null ? WDBundle.message("remote.edit.deleted.ex.0", oldServerConfig.getName()) : currentServer.getName();
    }

    @NlsSafe
    @NotNull
    private static String getUniqueName(Project project, VirtualFile file) {
        if (!UISettings.getInstance().getShowDirectoryForNonUniqueFilenames() || DumbService.isDumb((Project)project)) {
            String string = file.getPresentableName();
            if (string == null) {
                RemoteFileEditorTitleTabProvider.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(project, file);
        if (string == null) {
            RemoteFileEditorTitleTabProvider.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldServerConfig";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/remoteEdit/RemoteFileEditorTitleTabProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/remoteEdit/RemoteFileEditorTitleTabProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEditorTabTitle";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getServerName";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

