/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger.embedded;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.cpp.embedded.EmbeddedBundle;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.EmbeddedSettingsConfigurable;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.EmbeddedSettingsState;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.OpenOcdLauncher;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.ui.EmbeddedMessages;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.ui.OpenOcdConfigurationEditor;
import com.jetbrains.cidr.cpp.execution.gdbserver.DownloadType;
import com.jetbrains.cidr.cpp.execution.gdbserver.GdbServerRunConfiguration;
import com.jetbrains.cidr.cpp.execution.gdbserver.Utils;
import com.jetbrains.cidr.cpp.execution.remote.CLionRemoteRunConfigurationKt;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrLauncher;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenOcdConfiguration
extends GdbServerRunConfiguration {
    public static final int DEFAULT_GDB_PORT = 3333;
    public static final int DEFAULT_TELNET_PORT = 4444;
    public static final String SCRIPTS_PATH_SHORT = "scripts";
    public static final String SCRIPTS_PATH_LONG = "share/openocd/scripts";
    private static final String ATTR_GDB_PORT = "gdb-port";
    private static final String ATTR_TELNET_PORT = "telnet-port";
    private static final String ATTR_BOARD_CONFIG = "board-config";
    public static final String ATTR_RESET_TYPE = "reset-type";
    public static final ResetType DEFAULT_RESET = ResetType.INIT;
    public static final String TAG_OPENOCD = "openocd";
    private int gdbPort;
    private int telnetPort;
    @Nullable
    private String boardConfigFile;
    @NotNull
    private ResetType resetType;

    public String getGdbRemoteString() {
        return "tcp:localhost:" + this.getGdbPort();
    }

    public void setGdbRemoteString(@NotNull String gdbRemoteString) {
        if (gdbRemoteString == null) {
            OpenOcdConfiguration.$$$reportNull$$$0(0);
        }
        throw new IllegalArgumentException("Not supported");
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new OpenOcdConfigurationEditor(this.getProject(), this.getHelper());
    }

    @Nullable
    public CidrCommandLineState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        if (executor == null) {
            OpenOcdConfiguration.$$$reportNull$$$0(1);
        }
        if (environment == null) {
            OpenOcdConfiguration.$$$reportNull$$$0(2);
        }
        OpenOcdLauncher launcher = new OpenOcdLauncher(environment, this, this.getDebuggerData().getOrCreateDebuggerToolchain());
        return new CidrCommandLineState(environment, (CidrLauncher)launcher);
    }

    public void readExternalGdbServerInfo(@NotNull Element parentElement) throws InvalidDataException {
        Element element;
        if (parentElement == null) {
            OpenOcdConfiguration.$$$reportNull$$$0(3);
        }
        if ((element = parentElement.getChild(TAG_OPENOCD)) != null) {
            this.getDebuggerData().readExternal(element);
            this.boardConfigFile = element.getAttributeValue(ATTR_BOARD_CONFIG);
        } else {
            this.boardConfigFile = "";
        }
        this.gdbPort = Utils.readIntAttr((Element)element, (String)ATTR_GDB_PORT, (int)3333);
        this.telnetPort = Utils.readIntAttr((Element)element, (String)ATTR_TELNET_PORT, (int)4444);
        this.resetType = (ResetType)Utils.readEnumAttr((Element)element, (String)ATTR_RESET_TYPE, (Enum)DEFAULT_RESET);
        this.setDownloadType((DownloadType)Utils.readEnumAttr((Element)element, (String)"download-type", (Enum)DownloadType.ALWAYS));
    }

    public void writeExternalGdbServerInfo(@NotNull Element parentElement) throws WriteExternalException {
        if (parentElement == null) {
            OpenOcdConfiguration.$$$reportNull$$$0(4);
        }
        Element element = new Element(TAG_OPENOCD);
        parentElement.addContent(element);
        this.getDebuggerData().writeExternal(element);
        element.setAttribute(ATTR_GDB_PORT, String.valueOf(this.gdbPort));
        element.setAttribute(ATTR_TELNET_PORT, String.valueOf(this.telnetPort));
        if (this.boardConfigFile != null) {
            element.setAttribute(ATTR_BOARD_CONFIG, this.boardConfigFile);
        }
        element.setAttribute(ATTR_RESET_TYPE, this.resetType.name());
        element.setAttribute("download-type", this.getDownloadType().name());
    }

    public OpenOcdConfiguration(@NotNull Project project, @NotNull ConfigurationFactory configurationFactory, @Nullable String targetName) {
        if (project == null) {
            OpenOcdConfiguration.$$$reportNull$$$0(5);
        }
        if (configurationFactory == null) {
            OpenOcdConfiguration.$$$reportNull$$$0(6);
        }
        super(project, configurationFactory, targetName);
        this.gdbPort = 3333;
        this.telnetPort = 4444;
        this.resetType = DEFAULT_RESET;
    }

    public void doCheckConfiguration(boolean checkExecutable) throws RuntimeConfigurationException {
        CLionRemoteRunConfigurationKt.checkDebuggerToolchain((CPPToolchains.Toolchain)this.getDebuggerData().getOrCreateDebuggerToolchain(), (Project)this.getProject());
        if (checkExecutable) {
            if (!this.serverExecutableIsNotEmpty()) {
                throw new RuntimeConfigurationException(EmbeddedBundle.message("set.openocd.location", new Object[0]));
            }
            if (!this.serverExecutableExists()) {
                throw new RuntimeConfigurationException(EmbeddedBundle.message("set.openocd.location", new Object[0]));
            }
            File openOcdBinary = new File(this.getServerExecutable());
            OpenOcdConfiguration.requireAndReport(this.getProject(), OpenOcdConfiguration.findOcdScripts(openOcdBinary));
        }
        Utils.checkPort((int)this.gdbPort);
        Utils.checkPort((int)this.telnetPort);
        if (this.gdbPort == this.telnetPort) {
            throw new RuntimeConfigurationException(EmbeddedBundle.message("openocd.ports.should.be.different", new Object[0]));
        }
        if (StringUtil.isEmpty((String)this.boardConfigFile)) {
            throw new RuntimeConfigurationException(EmbeddedBundle.message("openocd.board.config.not.defined", new Object[0]));
        }
    }

    @NotNull
    public String getServerExecutable() {
        EmbeddedSettingsState ocdSettings = EmbeddedSettingsConfigurable.getState();
        String string = ocdSettings.openOcdLocation;
        if (string == null) {
            OpenOcdConfiguration.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void setServerExecutable(@NotNull String serverExecutable) {
        if (serverExecutable == null) {
            OpenOcdConfiguration.$$$reportNull$$$0(8);
        }
        throw new IllegalArgumentException("Not supported");
    }

    @NotNull
    public static File requireAndReport(@NotNull Project project, @Nullable File fileToCheck) {
        if (project == null) {
            OpenOcdConfiguration.$$$reportNull$$$0(9);
        }
        try {
            return OpenOcdConfiguration.require(fileToCheck);
        }
        catch (ConfigurationException e) {
            EmbeddedMessages.showErrorMessage(project, e);
            throw new ProcessCanceledException();
        }
    }

    @NotNull
    public static File require(@Nullable File fileToCheck) throws ConfigurationException {
        if (fileToCheck == null || !fileToCheck.exists()) {
            throw new ConfigurationException(EmbeddedBundle.message("set.openocd.location", new Object[0]), "OpenOCD");
        }
        File file = fileToCheck;
        if (file == null) {
            OpenOcdConfiguration.$$$reportNull$$$0(10);
        }
        return file;
    }

    @NotNull
    public static File findOcdScripts(@NotNull File openOcdLocation) {
        File ocdScripts;
        if (openOcdLocation == null) {
            OpenOcdConfiguration.$$$reportNull$$$0(11);
        }
        File binFolder = openOcdLocation.getParentFile();
        File homeFolder = null;
        if (binFolder != null) {
            homeFolder = binFolder.getParentFile();
        }
        if (homeFolder == null) {
            homeFolder = openOcdLocation;
        }
        if (!(ocdScripts = new File(homeFolder, SCRIPTS_PATH_LONG)).exists()) {
            ocdScripts = new File(homeFolder, SCRIPTS_PATH_SHORT);
        }
        File file = ocdScripts;
        if (file == null) {
            OpenOcdConfiguration.$$$reportNull$$$0(12);
        }
        return file;
    }

    public int getGdbPort() {
        return this.gdbPort;
    }

    public void setGdbPort(int gdbPort) {
        this.gdbPort = gdbPort;
    }

    public int getTelnetPort() {
        return this.telnetPort;
    }

    public void setTelnetPort(int telnetPort) {
        this.telnetPort = telnetPort;
    }

    @Nullable
    @NlsSafe
    public String getBoardConfigFile() {
        return this.boardConfigFile;
    }

    public void setBoardConfigFile(@Nullable String boardConfigFile) {
        this.boardConfigFile = boardConfigFile;
    }

    @NotNull
    public ResetType getResetType() {
        ResetType resetType = this.resetType;
        if (resetType == null) {
            OpenOcdConfiguration.$$$reportNull$$$0(13);
        }
        return resetType;
    }

    public void setResetType(@NotNull ResetType resetType) {
        if (resetType == null) {
            OpenOcdConfiguration.$$$reportNull$$$0(14);
        }
        this.resetType = resetType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gdbRemoteString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFactory";
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/embedded/OpenOcdConfiguration";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverExecutable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openOcdLocation";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resetType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/embedded/OpenOcdConfiguration";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerExecutable";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "require";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findOcdScripts";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getResetType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setGdbRemoteString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readExternalGdbServerInfo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeExternalGdbServerInfo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setServerExecutable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "requireAndReport";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findOcdScripts";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setResetType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ResetType {
        RUN("init;reset run;"),
        INIT("init;reset init;"),
        HALT("init;reset halt"),
        NONE("");

        @NotNull
        private final String command;

        @NotNull
        public String toString() {
            switch (this) {
                case INIT: {
                    String string = EmbeddedBundle.message("mcu.reset.type.INIT", new Object[0]);
                    if (string == null) {
                        ResetType.$$$reportNull$$$0(0);
                    }
                    return string;
                }
                case HALT: {
                    String string = EmbeddedBundle.message("mcu.reset.type.HALT", new Object[0]);
                    if (string == null) {
                        ResetType.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                case RUN: {
                    String string = EmbeddedBundle.message("mcu.reset.type.RUN", new Object[0]);
                    if (string == null) {
                        ResetType.$$$reportNull$$$0(2);
                    }
                    return string;
                }
            }
            String string = EmbeddedBundle.message("mcu.reset.type.NONE", new Object[0]);
            if (string == null) {
                ResetType.$$$reportNull$$$0(3);
            }
            return string;
        }

        private ResetType(String command) {
            if (command == null) {
                ResetType.$$$reportNull$$$0(4);
            }
            this.command = command;
        }

        @NotNull
        public final String getCommand() {
            String string = this.command;
            if (string == null) {
                ResetType.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/embedded/OpenOcdConfiguration$ResetType";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/embedded/OpenOcdConfiguration$ResetType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommand";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

