/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.embedded.stm32cubemx;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.cpp.embedded.stm32cubemx.ConvertProjectAction;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CubeMXManager
implements BulkFileListener,
ProjectComponent {
    public static final int FILE_MTIME_TOLERANCE_S = 10;
    public static final Topic<CubeStatusListener> TOPIC = Topic.create((String)"STM32CubeMX Project Updates", CubeStatusListener.class);
    private final Project myProject;
    private VirtualFile myProjectDir;
    private MessageBus myMessageBus;
    private MessageBusConnection myConnection;
    private final AtomicBoolean cmakeUpdateScheduled;
    @NotNull
    private volatile CubeStatus myStatus;
    private volatile String myTargetMCU;
    private volatile boolean myUtilityRunning;

    public CubeMXManager(@NotNull Project project) {
        if (project == null) {
            CubeMXManager.$$$reportNull$$$0(0);
        }
        this.cmakeUpdateScheduled = new AtomicBoolean(false);
        this.myStatus = CubeStatus.BROKEN;
        this.myTargetMCU = null;
        this.myProject = project;
    }

    public void projectOpened() {
        this.notifyPossibleCubeMXChanges();
    }

    public void notifyPossibleCubeMXChanges() {
        this.myMessageBus = this.myProject.getMessageBus();
        if (this.myConnection == null) {
            String[] projectRootFiles;
            this.myProjectDir = ConvertProjectAction.getRootDir(this.myProject);
            if (this.myProjectDir != null && (projectRootFiles = VfsUtilCore.virtualToIoFile((VirtualFile)this.myProjectDir).list()) != null && Stream.of(projectRootFiles).anyMatch(path -> FileUtilRt.extensionEquals((String)path, (String)"ioc"))) {
                this.myConnection = this.myMessageBus.connect((Disposable)this.myProject);
                this.myConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
                this.scheduleProjectUpdate();
            }
        }
    }

    private void scheduleProjectUpdate() {
        if (this.myProjectDir != null && !this.cmakeUpdateScheduled.getAndSet(true)) {
            ApplicationManager.getApplication().invokeLater(this::doUpdateProjectStatus);
        }
    }

    public void projectClosed() {
        if (this.myConnection != null) {
            this.myConnection.disconnect();
        }
    }

    @NotNull
    public CubeStatus getStatus() {
        CubeStatus cubeStatus = this.myStatus;
        if (cubeStatus == null) {
            CubeMXManager.$$$reportNull$$$0(1);
        }
        return cubeStatus;
    }

    @Nullable
    public String getTargetMCU() {
        return this.myTargetMCU;
    }

    public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
        if (events == null) {
            CubeMXManager.$$$reportNull$$$0(2);
        }
        for (VFileEvent vFileEvent : events) {
            String path = vFileEvent.getPath();
            if (!FileUtilRt.extensionEquals((String)path, (String)"ioc") && !StringUtil.endsWithIgnoreCase((String)path, (String)"/.cproject")) continue;
            this.scheduleProjectUpdate();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateProjectStatus() {
        if (this.myProject.isDisposed()) {
            return;
        }
        try {
            VirtualFile cmakeLists;
            VirtualFile iocFile = CubeMXManager.findIocFile(this.myProjectDir, false);
            CubeStatus newStatus = CubeStatus.BROKEN;
            String newTargetMCU = null;
            VirtualFile cProject = null;
            if (iocFile != null) {
                Properties properties = new Properties();
                try {
                    properties.load(iocFile.getInputStream());
                    if (properties.size() > 0) {
                        String targetIde = properties.getProperty("ProjectManager.TargetToolchain", "");
                        if ("SW4STM32".equalsIgnoreCase(targetIde) || "STM32CubeIDE".equalsIgnoreCase(targetIde)) {
                            cProject = this.myProjectDir.findChild(".cproject");
                            if (cProject == null) {
                                newStatus = CubeStatus.REQUIRES_GENERATION;
                            } else if (!cProject.isDirectory()) {
                                newStatus = CubeMXManager.notNewerThan(iocFile, cProject, 10) ? CubeStatus.OK : CubeStatus.OUTDATED;
                            }
                        } else {
                            newStatus = targetIde.toUpperCase(Locale.ROOT).startsWith("EWARM") ? CubeStatus.OK : CubeStatus.WRONG_TARGET;
                        }
                        newTargetMCU = properties.getProperty("Mcu.Name");
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!Objects.equals((Object)this.myStatus, (Object)newStatus) || !Objects.equals(this.myTargetMCU, newTargetMCU)) {
                this.myStatus = newStatus;
                this.myTargetMCU = newTargetMCU;
                ((CubeStatusListener)this.myMessageBus.syncPublisher(TOPIC)).cubeMxStatusUpdated(this);
            }
            if (!(cProject == null || this.myStatus != CubeStatus.OK && this.myStatus != CubeStatus.OUTDATED || (cmakeLists = this.myProjectDir.findChild("CMakeLists.txt")) != null && !CubeMXManager.notNewerThan(cmakeLists, cProject, 0))) {
                ConvertProjectAction.updateProject(this.myProject, true);
            }
        }
        finally {
            this.cmakeUpdateScheduled.set(false);
        }
    }

    @Nullable
    public static VirtualFile findIocFile(@NotNull VirtualFile projectDir, boolean refreshFirst) {
        if (projectDir == null) {
            CubeMXManager.$$$reportNull$$$0(3);
        }
        String iocFileName = projectDir.getNameWithoutExtension() + ".ioc";
        VirtualFile iocFile = refreshFirst ? VfsUtil.refreshAndFindChild((VirtualFile)projectDir, (String)iocFileName) : projectDir.findChild(iocFileName);
        if (iocFile != null && !iocFile.isDirectory()) {
            return iocFile;
        }
        return null;
    }

    public boolean isUtilityRunning() {
        return this.myUtilityRunning;
    }

    public void cubeUtilityStatus(boolean running) {
        if (running != this.myUtilityRunning) {
            this.myUtilityRunning = running;
            ((CubeStatusListener)this.myMessageBus.syncPublisher(TOPIC)).cubeMxStatusUpdated(this);
        }
    }

    private static boolean notNewerThan(VirtualFile fileA, VirtualFile fileB, int timeToleranceS) {
        return VfsUtilCore.virtualToIoFile((VirtualFile)fileA).lastModified() <= VfsUtilCore.virtualToIoFile((VirtualFile)fileB).lastModified() + (long)timeToleranceS * 1000L;
    }

    @Contract(value="!null->!null")
    public static CubeMXManager getInstance(@Nullable Project project) {
        return project == null ? null : (CubeMXManager)project.getComponent(CubeMXManager.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/embedded/stm32cubemx/CubeMXManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/embedded/stm32cubemx/CubeMXManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "after";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findIocFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface CubeStatusListener {
        public void cubeMxStatusUpdated(@NotNull CubeMXManager var1);
    }

    public static enum CubeStatus {
        BROKEN,
        WRONG_TARGET,
        REQUIRES_GENERATION,
        OUTDATED,
        OK;

    }
}

