/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.clion.perf;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profiler.LineByLineParser;
import com.intellij.profiler.clion.perf.PerfFrame;
import com.intellij.profiler.clion.perf.PerfSample;
import com.intellij.profiler.clion.perf.PerfSourceFileLineData;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB0\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012!\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u000fH\u0016J\u0006\u0010\u001b\u001a\u00020\nR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R)\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/profiler/clion/perf/PerfScriptParser;", "Lcom/intellij/profiler/LineByLineParser;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "onSampleParsed", "Lkotlin/Function1;", "Lcom/intellij/profiler/clion/perf/PerfSample;", "Lkotlin/ParameterName;", "name", "sample", "", "(Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;Lkotlin/jvm/functions/Function1;)V", "FRAME_REGEX", "Lkotlin/text/Regex;", "HEX", "", "SOURCE_FILE_LINE_INFO_REGEX", "currentFrames", "", "Lcom/intellij/profiler/clion/perf/PerfFrame;", "currentThreadId", "currentThreadName", "isIncomplete", "", "()Z", "consumeLine", "line", "finish", "Companion", "intellij.profiler.clion"})
public final class PerfScriptParser
extends LineByLineParser {
    private final String HEX;
    private final Regex FRAME_REGEX;
    private final Regex SOURCE_FILE_LINE_INFO_REGEX;
    private String currentThreadName;
    private String currentThreadId;
    private List<PerfFrame> currentFrames;
    private final CidrToolEnvironment environment;
    private final Function1<PerfSample, Unit> onSampleParsed;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    public final boolean isIncomplete() {
        return !this.currentFrames.isEmpty() || this.currentThreadId != null;
    }

    public void consumeLine(@NotNull String line) {
        Object instructionPointer;
        CharSequence groups;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        CharSequence charSequence = line;
        boolean bl = false;
        String trimmedLine = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
        charSequence = trimmedLine;
        Object object = this.FRAME_REGEX;
        boolean bl2 = false;
        if (object.matches(charSequence)) {
            CharSequence charSequence2;
            CharSequence function;
            CharSequence charSequence3;
            MatchResult matchResult = this.FRAME_REGEX.matchEntire((CharSequence)trimmedLine);
            groups = matchResult != null ? matchResult.getGroups() : null;
            CharSequence charSequence4 = groups;
            if (charSequence4 == null || (charSequence4 = charSequence4.get(1)) == null || (charSequence4 = charSequence4.getValue()) == null) {
                charSequence4 = instructionPointer = "";
            }
            if ((charSequence3 = groups) == null || (charSequence3 = charSequence3.get(2)) == null || (charSequence3 = charSequence3.getValue()) == null) {
                charSequence3 = function = "";
            }
            if ((charSequence2 = groups) == null || (charSequence2 = charSequence2.get(3)) == null || (charSequence2 = charSequence2.getValue()) == null) {
                charSequence2 = "";
            }
            CharSequence binary = charSequence2;
            this.currentFrames.add(new PerfFrame((String)function, (String)binary, (String)instructionPointer));
        } else {
            groups = trimmedLine;
            instructionPointer = this.SOURCE_FILE_LINE_INFO_REGEX;
            boolean function = false;
            if (instructionPointer.matches(groups)) {
                if (this.currentFrames.isEmpty()) {
                    LOG.warn("Can't process navigation data, because frame list is empty");
                    return;
                }
                PerfFrame frame = (PerfFrame)CollectionsKt.last(this.currentFrames);
                MatchResult matchResult = this.SOURCE_FILE_LINE_INFO_REGEX.matchEntire((CharSequence)trimmedLine);
                Object groups2 = matchResult != null ? matchResult.getGroups() : null;
                Object object2 = groups2;
                if (object2 == null || (object2 = object2.get(1)) == null || (object2 = object2.getValue()) == null) {
                    object2 = "";
                }
                Object filePath = object2;
                Object object3 = groups2;
                int lineNumber = object3 != null && (object3 = object3.get(2)) != null && (object3 = object3.getValue()) != null && (object3 = StringsKt.toIntOrNull((String)object3)) != null ? (Integer)object3 : 0;
                CharSequence charSequence5 = (CharSequence)filePath;
                boolean bl3 = false;
                if (charSequence5.length() > 0 && Intrinsics.areEqual((Object)filePath, (Object)"??") ^ true && lineNumber > 0) {
                    String string = this.environment.toLocalPath((String)filePath);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"environment.toLocalPath(filePath)");
                    frame.setMySourceFileLineData(new PerfSourceFileLineData(string, lineNumber - 1));
                }
            } else {
                List list = StringUtil.split((String)trimmedLine, (String)" ", (boolean)true, (boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"StringUtil.split(trimmedLine, \" \", true, true)");
                List lineParts = list;
                if (lineParts.size() == 1 || lineParts.size() == 2) {
                    object = this.currentFrames;
                    bl2 = false;
                    if (!object.isEmpty() && this.currentThreadName != null && this.currentThreadId != null) {
                        List list2 = new ArrayList(this.currentFrames);
                        String string = this.currentThreadName;
                        Intrinsics.checkNotNull((Object)string);
                        String string2 = this.currentThreadId;
                        Intrinsics.checkNotNull((Object)string2);
                        this.onSampleParsed.invoke((Object)new PerfSample(list2, string, string2));
                    }
                    this.currentFrames = new ArrayList();
                    this.currentThreadName = lineParts.size() == 2 ? (String)lineParts.get(0) : "";
                    this.currentThreadId = (String)CollectionsKt.last((List)lineParts);
                } else {
                    object = trimmedLine;
                    bl2 = false;
                    if (!StringsKt.isBlank((CharSequence)object)) {
                        this.currentThreadName = null;
                        this.currentThreadId = null;
                        this.currentFrames.clear();
                        LOG.warn("Unrecognized line from perf script: " + trimmedLine);
                    }
                }
            }
        }
    }

    public final void finish() {
        if (this.isIncomplete()) {
            List list = new ArrayList(this.currentFrames);
            String string = this.currentThreadName;
            Intrinsics.checkNotNull((Object)string);
            String string2 = this.currentThreadId;
            Intrinsics.checkNotNull((Object)string2);
            this.onSampleParsed.invoke((Object)new PerfSample(list, string, string2));
        }
        this.currentFrames.clear();
        this.currentThreadId = null;
    }

    public PerfScriptParser(@NotNull CidrToolEnvironment environment2, @NotNull Function1<? super PerfSample, Unit> onSampleParsed) {
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        Intrinsics.checkNotNullParameter(onSampleParsed, (String)"onSampleParsed");
        this.environment = environment2;
        this.onSampleParsed = onSampleParsed;
        this.HEX = "((?:0x|0X)?[a-fA-F0-9]+)";
        this.FRAME_REGEX = new Regex(this.HEX + " (.*) \\((.*)\\)");
        this.SOURCE_FILE_LINE_INFO_REGEX = new Regex("(?:(.*):(.*))|(\\[.*]\\[.*])");
        boolean bl = false;
        this.currentFrames = new ArrayList();
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PerfScriptParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/profiler/clion/perf/PerfScriptParser$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.profiler.clion"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

