/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.browse.ColorDeclarationType;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.psi.css.inspections.CssConvertColorToRgbInspection;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class CssConvertColorToHexInspection
extends CssConvertColorToRgbInspection {
    private static final LocalQuickFix fix = new LocalQuickFix(){

        @NotNull
        public String getName() {
            String string = CssBundle.message((String)"css.convert.color.value.to.hex", (Object[])new Object[0]);
            if (string == null) {
                1.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = CssBundle.message((String)"css.convert.color.to.hex.family", (Object[])new Object[0]);
            if (string == null) {
                1.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement value;
            if (project == null) {
                1.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                1.$$$reportNull$$$0(3);
            }
            if ((value = descriptor.getPsiElement()) == null) {
                return;
            }
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{value.getContainingFile()}).run(() -> {
                Color color = CssPsiColorUtil.getColor(value);
                if (color != null) {
                    Language language = CssPsiUtil.getStylesheetLanguage((PsiElement)value);
                    value.replace((PsiElement)CssElementFactory.getInstance((Project)project).createTerm(CssPsiColorUtil.toHexColor(color), language));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/inspections/CssConvertColorToHexInspection$1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/inspections/CssConvertColorToHexInspection$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    @Override
    @NotNull
    public String getShortName() {
        return "CssConvertColorToHexInspection";
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssConvertColorToHexInspection.$$$reportNull$$$0(0);
        }
        return new CssElementVisitor(){

            public void visitCssTerm(CssTerm _term) {
                super.visitCssTerm(_term);
                if (CssTermTypes.COLOR == _term.getTermType()) {
                    ColorDeclarationType type = ColorDeclarationType.fromColorTerm((PsiElement)_term);
                    Color color = CssPsiColorUtil.getColor((PsiElement)_term);
                    if (!(color == null || type == ColorDeclarationType.HEX || type.withAlphaChannel() && color.getAlpha() != 255)) {
                        holder.registerProblem((PsiElement)_term, CssBundle.message((String)"css.convert.color.value.to.hex", (Object[])new Object[0]), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{fix});
                    }
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/CssConvertColorToHexInspection", "buildVisitor"));
    }
}

