/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssIdSelector;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssPseudoSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssSupportLoader;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.references.CssFontFamilyReference;
import com.intellij.psi.css.impl.util.references.CssIdentifierReference;
import com.intellij.psi.css.impl.util.references.CssKeyframesReference;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.css.index.CssIndex;
import com.intellij.psi.css.resolve.CssComposesClassReference;
import com.intellij.psi.css.resolve.CssCustomPropertyReference;
import com.intellij.psi.css.resolve.CssReferenceProviderUtil;
import com.intellij.psi.css.resolve.CssSelectorSelfReference;
import com.intellij.psi.css.resolve.CssSimpleSelectorReference;
import com.intellij.psi.css.resolve.CssValueReference;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.fileTypes.impl.SvgFileType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssReferenceProvider
extends PsiReferenceProvider {
    public static final FileType[] IMAGE_FILE_TYPES = new FileType[]{ImageFileTypeManager.getInstance().getImageFileType(), SvgFileType.INSTANCE};

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            CssReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            CssReferenceProvider.$$$reportNull$$$0(1);
        }
        PsiReference[] psiReferenceArray = (PsiReference[])CachedValuesManager.getCachedValue((PsiElement)element, () -> CachedValueProvider.Result.create((Object)CssReferenceProvider.getReferences(element), (Object[])new Object[]{element}));
        if (psiReferenceArray == null) {
            CssReferenceProvider.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    private static PsiReference[] getReferences(PsiElement element) {
        PsiElement elementParent;
        if (element instanceof CssIdSelector) {
            int startOffset = element.getTextOffset() - element.getTextRange().getStartOffset();
            CssSelectorSuffix selectorSuffix = (CssSelectorSuffix)element;
            return new PsiReference[]{new CssSelectorSelfReference(selectorSuffix, TextRange.from((int)startOffset, (int)StringUtil.length((CharSequence)selectorSuffix.getName())))};
        }
        PsiElement parent = element.getParent();
        if (parent instanceof CssSimpleSelector) {
            return new PsiReference[]{new CssSimpleSelectorReference(element)};
        }
        if (parent instanceof CssPseudoSelector || element instanceof CssFunction) {
            return PsiReference.EMPTY_ARRAY;
        }
        IElementType elementType = element.getNode().getElementType();
        if (element.getParent().getNode().getElementType() == CssElementTypes.CSS_VALUE_IMPORT) {
            if (CssReferenceProvider.isAfterFromInValueImport(element)) {
                if (CssReferenceProvider.isSimpleString(element)) {
                    return CssReferenceProviderUtil.getFileReferences(element, true, false, new FileType[0]);
                }
                if (elementType == CssElementTypes.CSS_IDENT) {
                    return new PsiReference[]{new CssValueReference(element)};
                }
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (CssReferenceProvider.isStringOrUrl(element)) {
            String value;
            if (CssReferenceProvider.isInImport(element)) {
                return CssReferenceProviderUtil.getFileReferences(element, true, false, new FileType[0]);
            }
            if (CssReferenceProvider.isInsideImageFunction(element) || CssReferenceProvider.isUriElement(element)) {
                return CssReferenceProviderUtil.getFileReferences(element, false, true, IMAGE_FILE_TYPES);
            }
            if (CssUtil.isInsideComposesDeclaration(element)) {
                return CssReferenceProviderUtil.getFileReferences(element, true, false, new FileType[0]);
            }
            if (CssReferenceProvider.isSimpleString(element) && CssReferenceProvider.isFontFamilyPropertyValue(element)) {
                return new PsiReference[]{new CssFontFamilyReference((CssString)element)};
            }
            if (CssReferenceProvider.isSimpleString(element) && parent.getNode().getElementType() == CssElementTypes.CSS_VALUE_VALUE && ((value = ((CssString)element).getValue()).startsWith("./") || value.startsWith("../"))) {
                return CssReferenceProviderUtil.getFileReferences(element, true, false, new FileType[0]);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        SmartList result = new SmartList();
        boolean identReferenceAdded = false;
        if (elementType == CssElementTypes.CSS_IDENT) {
            CssDeclaration declaration;
            if (CssPsiUtil.isCustomVariableReference((PsiElement)element)) {
                identReferenceAdded = true;
                result.add(new CssCustomPropertyReference(element));
            } else if (parent instanceof CssTerm && (declaration = CssUtil.getDeclaration(parent)) != null) {
                String propertyName = declaration.getPropertyName();
                if ("animation-name".equalsIgnoreCase(propertyName) || "animation".equalsIgnoreCase(propertyName)) {
                    identReferenceAdded = true;
                    result.add(new CssKeyframesReference(element));
                } else if (CssReferenceProvider.isComposesClassTerm(parent, declaration)) {
                    identReferenceAdded = true;
                    result.add(new CssComposesClassReference(element));
                }
                result.add(new CssValueReference(element));
            }
        }
        if (!(identReferenceAdded || elementType != CssElementTypes.CSS_HASH && elementType != CssElementTypes.CSS_IDENT || (elementParent = element.getParent()) instanceof CssDeclaration && ((CssDeclaration)elementParent).isCustomProperty() && element.equals(((CssDeclaration)elementParent).getPropertyNameElement()))) {
            result.add(new CssIdentifierReference(element));
        }
        return result.toArray(PsiReference.EMPTY_ARRAY);
    }

    private static boolean isAfterFromInValueImport(@NotNull PsiElement element) {
        if (element == null) {
            CssReferenceProvider.$$$reportNull$$$0(3);
        }
        if (element.getParent().getNode().getElementType() != CssElementTypes.CSS_VALUE_IMPORT) {
            return false;
        }
        PsiElement sibling = element.getPrevSibling();
        if (sibling instanceof PsiWhiteSpace) {
            sibling = sibling.getPrevSibling();
        }
        if (sibling == null || sibling.getNode().getElementType() != CssElementTypes.CSS_IDENT || !sibling.textMatches((CharSequence)"from")) {
            return false;
        }
        if ((sibling = sibling.getPrevSibling()) instanceof PsiWhiteSpace) {
            sibling = sibling.getPrevSibling();
        }
        if (sibling != null && sibling.getNode().getElementType() == CssElementTypes.CSS_RPAREN) {
            sibling = sibling.getPrevSibling();
        }
        if (sibling instanceof PsiWhiteSpace) {
            sibling = sibling.getPrevSibling();
        }
        return sibling != null && sibling.getNode().getElementType() == CssElementTypes.CSS_VALUE_IMPORTED_ALIAS_LIST;
    }

    public static boolean isStringOrUrl(@NotNull PsiElement element) {
        if (element == null) {
            CssReferenceProvider.$$$reportNull$$$0(4);
        }
        return element instanceof CssString || CssReferenceProvider.isUriElement(element);
    }

    private static boolean isFontFamilyPropertyValue(@Nullable PsiElement element) {
        CssDeclaration declaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, CssDeclaration.class, (boolean)true);
        if (declaration != null) {
            for (CssPropertyDescriptor descriptor : declaration.getDescriptors()) {
                if (!CssIndex.isFontOrFontFamily(descriptor.getPropertyName())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isUriElement(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            CssReferenceProvider.$$$reportNull$$$0(5);
        }
        return (parent = element.getParent()) instanceof CssUri || parent instanceof CssTerm && parent.getParent() instanceof CssUri;
    }

    @Contract(value="null -> false")
    private static boolean isSimpleString(@Nullable PsiElement string) {
        if (!(string instanceof CssString)) {
            return false;
        }
        PsiElement[] children = string.getChildren();
        return children.length == 1 && children[0].getNode().getElementType() == CssElementTypes.CSS_STRING_TOKEN;
    }

    public static boolean isInImport(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            CssReferenceProvider.$$$reportNull$$$0(6);
        }
        return (parent = element.getParent()) instanceof CssImport || parent instanceof CssUri && parent.getParent() instanceof CssImport;
    }

    public static boolean isInsideImageFunction(@Nullable PsiElement element) {
        CssFunction function = (CssFunction)PsiTreeUtil.getParentOfType((PsiElement)element, CssFunction.class);
        return function != null && "image".equalsIgnoreCase(function.getName());
    }

    private static boolean isComposesClassTerm(@NotNull PsiElement term, @NotNull CssDeclaration declaration) {
        if (term == null) {
            CssReferenceProvider.$$$reportNull$$$0(7);
        }
        if (declaration == null) {
            CssReferenceProvider.$$$reportNull$$$0(8);
        }
        if (!CssPropertyUtil.isComposesProperty(declaration) || declaration.getValue() == null) {
            return false;
        }
        Object[] terms = declaration.getValue().getTerms();
        if (!ArrayUtil.contains((Object)term, (Object[])terms)) {
            return false;
        }
        if (term == ArrayUtil.getLastElement((Object[])terms)) {
            return true;
        }
        Object nextTerm = terms[ArrayUtil.indexOf((Object[])terms, (Object)term) + 1];
        return nextTerm.getTermType() != CssTermTypes.STRING;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/CssReferenceProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "term";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/CssReferenceProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAfterFromInValueImport";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isStringOrUrl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isUriElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isInImport";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isComposesClassTerm";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CssReferenceFilter
    implements ElementFilter {
        public boolean isAcceptable(Object element, PsiElement context) {
            PsiElement psiElement = (PsiElement)element;
            if (!psiElement.isValid()) {
                return false;
            }
            if (CssPsiUtil.getStylesheetLanguage((PsiElement)context) == null && context.getContainingFile().getFileType() != CssFileType.INSTANCE && !CssSupportLoader.isInFileThatSupportsCssResolve(context)) {
                return false;
            }
            if (element instanceof CssIdSelector) {
                return true;
            }
            if (element instanceof CssTokenImpl) {
                PsiElement parent = psiElement.getParent();
                if (parent != null) {
                    if (parent instanceof CssDeclaration || parent instanceof CssSimpleSelector || parent instanceof CssFunction || parent instanceof CssTerm) {
                        return true;
                    }
                    PsiElement grandParent = parent.getParent();
                    if (grandParent != null && (grandParent instanceof CssTermList || grandParent.getParent() instanceof CssTermList) && PsiTreeUtil.getParentOfType((PsiElement)parent, CssDeclaration.class) != null || parent instanceof CssUri) {
                        return true;
                    }
                }
            } else if (CssReferenceProvider.isStringOrUrl(psiElement)) {
                return true;
            }
            return false;
        }

        public boolean isClassAcceptable(Class hintClass) {
            return true;
        }
    }
}

