/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.navigation.OCSymbolPresentation;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class OCSymbolHolderBase<T extends OCSymbol>
extends FakePsiElement
implements NavigatablePsiElement {
    @NotNull
    protected final T mySymbol;
    @NotNull
    protected final Project myProject;

    public OCSymbolHolderBase(@NotNull T symbol, @NotNull Project project) {
        if (symbol == null) {
            OCSymbolHolderBase.$$$reportNull$$$0(0);
        }
        if (project == null) {
            OCSymbolHolderBase.$$$reportNull$$$0(1);
        }
        this.mySymbol = symbol;
        this.myProject = project;
    }

    @NotNull
    public String getName() {
        String string = this.mySymbol.getName();
        if (string == null) {
            OCSymbolHolderBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    public ItemPresentation getPresentation() {
        return new OCSymbolPresentation((OCSymbol)this.mySymbol, this.myProject);
    }

    protected Icon getBaseIcon() {
        return this.mySymbol.getIcon(this.getProject());
    }

    public Icon getIcon(boolean open) {
        return this.mySymbol.getIcon(this.getProject());
    }

    public void navigate(boolean requestFocus2) {
        int offset = this.mySymbol.getOffset();
        VirtualFile virtualFile = this.mySymbol.getContainingFile();
        if (virtualFile != null && virtualFile.isValid()) {
            PsiNavigationSupport.getInstance().createNavigatable(this.myProject, virtualFile, offset).navigate(true);
        }
    }

    public boolean isValid() {
        VirtualFile virtualFile = this.mySymbol.getContainingFile();
        return virtualFile != null && virtualFile.isValid();
    }

    public boolean canNavigateToSource() {
        return this.isValid();
    }

    public PsiElement getParent() {
        return this.getContainingFile();
    }

    public PsiFile getContainingFile() {
        return this.mySymbol.getContainingPsiFile(this.getProject());
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            OCSymbolHolderBase.$$$reportNull$$$0(3);
        }
        return project;
    }

    public int getTextOffset() {
        return this.mySymbol.getOffset();
    }

    public TextRange getTextRange() {
        return new TextRange(this.mySymbol.getOffset(), this.mySymbol.getOffset());
    }

    public void delete() throws IncorrectOperationException {
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == ((Object)((Object)this)).getClass() && this.mySymbol.equals(((OCSymbolHolderBase)((Object)obj)).mySymbol);
    }

    public int hashCode() {
        return this.mySymbol.hashCode();
    }

    @NotNull
    public T getSymbol() {
        T t = this.mySymbol;
        if (t == null) {
            OCSymbolHolderBase.$$$reportNull$$$0(4);
        }
        return t;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/OCSymbolHolderBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/OCSymbolHolderBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

