/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCVariadicPackExpression;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCVariadicPackExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.visitors.OCBooleanTypeVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCNonPrimitiveTypeCloneVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCArgumentsList<E extends OCTypeOwner> {
    @NotNull
    private List<OCType> types;
    @Nullable
    private List<E> exprs;
    private boolean nonExpandedVariadics;

    public OCArgumentsList(@NotNull List<OCType> types, @Nullable List<E> exprs, boolean nonExpandedVariadics) {
        if (types == null) {
            OCArgumentsList.$$$reportNull$$$0(0);
        }
        this.types = Collections.unmodifiableList(types);
        this.exprs = exprs != null ? Collections.unmodifiableList(exprs) : null;
        this.nonExpandedVariadics = nonExpandedVariadics;
    }

    public OCArgumentsList(@NotNull List<OCType> types, @Nullable List<E> exprs) {
        if (types == null) {
            OCArgumentsList.$$$reportNull$$$0(1);
        }
        this(types, exprs, false);
    }

    public OCArgumentsList() {
        this(Collections.emptyList(), Collections.emptyList(), false);
    }

    @NotNull
    public static OCArgumentsList<OCExpression> getArgumentList(@NotNull List<OCExpression> expressionsList) {
        if (expressionsList == null) {
            OCArgumentsList.$$$reportNull$$$0(2);
        }
        return OCArgumentsList.getArgumentList(expressionsList, null);
    }

    @NotNull
    public static OCArgumentsList<OCExpression> getArgumentList(@NotNull List<OCExpression> expressionsList, @Nullable OCResolveContext context) {
        if (expressionsList == null) {
            OCArgumentsList.$$$reportNull$$$0(3);
        }
        ArrayList<OCType> types = new ArrayList<OCType>();
        boolean nonExpandedVariadics = false;
        ArrayList<OCExpression> expressions = new ArrayList<OCExpression>();
        for (OCExpression expression : expressionsList) {
            if (expression instanceof OCVariadicPackExpression) {
                nonExpandedVariadics = true;
                continue;
            }
            if (expression == null) continue;
            expressions.add(expression);
            types.add(expression.getResolvedType(context != null ? context : OCResolveContext.forPsi(expression)));
        }
        return new OCArgumentsList<OCExpression>(types, expressions, nonExpandedVariadics);
    }

    @NotNull
    public static OCArgumentsList<OCExpressionSymbol> expandVariadicExpressions(@NotNull List<OCExpressionSymbol> expressionsList, @NotNull OCResolveContext context) {
        if (expressionsList == null) {
            OCArgumentsList.$$$reportNull$$$0(4);
        }
        if (context == null) {
            OCArgumentsList.$$$reportNull$$$0(5);
        }
        ArrayList<OCType> expandedTypes = new ArrayList<OCType>();
        ArrayList<OCExpressionSymbol> expandedExprs = new ArrayList<OCExpressionSymbol>();
        boolean nonExpandedVariadics = false;
        for (OCExpressionSymbol expression : expressionsList) {
            if (expression instanceof OCVariadicPackExpressionSymbol) {
                List<OCType> expansions = ((OCVariadicPackExpressionSymbol)expression).getExpandedResolvedTypes(context);
                if (expansions != null) {
                    for (OCType type : expansions) {
                        expandedExprs.add(((OCVariadicPackExpressionSymbol)expression).getExpression());
                        expandedTypes.add(type);
                    }
                    continue;
                }
                nonExpandedVariadics = true;
                continue;
            }
            expandedExprs.add(expression);
            expandedTypes.add(expression.getResolvedType(context));
        }
        return new OCArgumentsList<OCExpressionSymbol>(expandedTypes, expandedExprs, nonExpandedVariadics);
    }

    @NotNull
    public static <T extends OCTypeArgument> List<T> expandVariadicTypes(@NotNull List<T> types, @NotNull OCResolveContext context) {
        if (types == null) {
            OCArgumentsList.$$$reportNull$$$0(6);
        }
        if (context == null) {
            OCArgumentsList.$$$reportNull$$$0(7);
        }
        ArrayList<OCTypeArgument> result = new ArrayList<OCTypeArgument>();
        if (context.isDontExpandVariadics()) {
            List<T> list = types;
            if (list == null) {
                OCArgumentsList.$$$reportNull$$$0(8);
            }
            return list;
        }
        for (OCTypeArgument type : types) {
            List<OCTypeArgument> expandedTypes = null;
            if (type instanceof OCVariadicType) {
                OCType underlyingType = ((OCVariadicType)type).getUnderlyingType();
                expandedTypes = OCArgumentsList.expandExpansionPacks(underlyingType, context);
                if (expandedTypes == null) {
                    expandedTypes = OCArgumentsList.expandVariadicType(underlyingType, context);
                }
            } else if (type.isVariadic() && type instanceof OCExpressionTypeArgument) {
                expandedTypes = OCArgumentsList.expandVariadicPackExpression((OCVariadicPackExpressionSymbol)((OCExpressionTypeArgument)type).getSymbol(), context);
            }
            if (expandedTypes != null) {
                result.addAll(expandedTypes);
                continue;
            }
            result.add(type);
        }
        ArrayList<OCTypeArgument> arrayList = result;
        if (arrayList == null) {
            OCArgumentsList.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Nullable
    private static List<? extends OCTypeArgument> expandExpansionPacks(@NotNull OCType type, final @NotNull OCResolveContext context) {
        if (type == null) {
            OCArgumentsList.$$$reportNull$$$0(10);
        }
        if (context == null) {
            OCArgumentsList.$$$reportNull$$$0(11);
        }
        final Ref expansionsCnt = new Ref();
        final HashMap<OCTypeParameterSymbol, OCExpansionPackType> expansionSubstitutions = new HashMap<OCTypeParameterSymbol, OCExpansionPackType>();
        type.accept(new OCBooleanTypeVisitor(){

            @Override
            public Boolean visitExpansionPackType(OCExpansionPackType type) {
                if (expansionsCnt.isNull() || (Integer)expansionsCnt.get() < type.getExpansionsCnt()) {
                    expansionsCnt.set((Object)type.getExpansionsCnt());
                }
                return true;
            }

            private boolean processSubstitution(@NotNull OCTypeSubstitution substitution, @NotNull Object reference) {
                if (substitution == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (reference == null) {
                    1.$$$reportNull$$$0(1);
                }
                boolean prev = context.dontUseSymbolContextsInDepends();
                context.setDontUseSymbolContextsInDepends(true);
                substitution.getMinimalDependentSubstitution(reference, context).processSubstitutions((Processor<Map.Entry<OCTypeParameterSymbol, OCTypeArgument>>)((Processor)e -> {
                    OCTypeArgument value = (OCTypeArgument)e.getValue();
                    if (value instanceof OCExpansionPackType) {
                        expansionSubstitutions.put((OCTypeParameterSymbol)e.getKey(), (OCExpansionPackType)value);
                    }
                    if (value instanceof OCType) {
                        ((OCType)value).accept(this);
                    }
                    return true;
                }));
                context.setDontUseSymbolContextsInDepends(prev);
                return true;
            }

            @Override
            public Boolean visitReferenceType(OCReferenceType type) {
                return this.processSubstitution(type.getSubstitution(), type);
            }

            @Override
            public Boolean visitArrayType(OCArrayType type) {
                return this.processSubstitution(type.getSubstitution(), type);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "substitution";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "reference";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/resolve/OCArgumentsList$1";
                objectArray[2] = "processSubstitution";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (!expansionsCnt.isNull()) {
            ArrayList<OCType> expandedTypes = new ArrayList<OCType>();
            for (int i2 = 0; i2 < (Integer)expansionsCnt.get(); ++i2) {
                final int expansionIndex = i2;
                OCType resolvedType = type;
                if (!expansionSubstitutions.isEmpty()) {
                    HashMap<OCTypeParameterSymbol, OCTypeArgument> map = new HashMap<OCTypeParameterSymbol, OCTypeArgument>();
                    expansionSubstitutions.forEach((param, pack) -> {
                        if (expansionIndex < pack.getExpansionsCnt()) {
                            map.put((OCTypeParameterSymbol)param, pack.getExpansions().get(expansionIndex));
                        }
                    });
                    OCSimpleTypeSubstitution substitution = OCSimpleTypeSubstitution.create(map);
                    resolvedType = substitution.substitute(type, true, context).resolve(context);
                    if (resolvedType instanceof OCVariadicType) {
                        resolvedType = new OCVariadicType(substitution.substitute(((OCVariadicType)resolvedType).getUnderlyingType(), context));
                    }
                }
                expandedTypes.add(resolvedType.accept(new OCNonPrimitiveTypeCloneVisitor(){

                    @Override
                    public OCType visitExpansionPackType(OCExpansionPackType type) {
                        OCTypeArgument argument;
                        if (expansionIndex < type.getExpansionsCnt() && (argument = type.getExpansions().get(expansionIndex)) instanceof OCType) {
                            return (OCType)argument;
                        }
                        return OCUnknownType.INSTANCE;
                    }
                }));
            }
            return expandedTypes;
        }
        return null;
    }

    @Nullable
    private static List<? extends OCTypeArgument> expandVariadicPackExpression(@NotNull OCVariadicPackExpressionSymbol expressionSymbol, @NotNull OCResolveContext context) {
        if (expressionSymbol == null) {
            OCArgumentsList.$$$reportNull$$$0(12);
        }
        if (context == null) {
            OCArgumentsList.$$$reportNull$$$0(13);
        }
        final OCExpressionSymbol symbol = expressionSymbol.getExpression();
        return OCArgumentsList.getExpandedResolvedTypes(context1 -> symbol.evaluateToTypeArgument((OCResolveContext)context1), new OCTypeOwner(){

            @Override
            @NotNull
            public OCType getResolvedType(@NotNull OCResolveContext context) {
                if (context == null) {
                    3.$$$reportNull$$$0(0);
                }
                OCType oCType = symbol.getResolvedType(context);
                if (oCType == null) {
                    3.$$$reportNull$$$0(1);
                }
                return oCType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/resolve/OCArgumentsList$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/resolve/OCArgumentsList$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getResolvedType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getResolvedType";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, context);
    }

    @Nullable
    private static List<? extends OCTypeArgument> expandVariadicType(final @NotNull OCType underlyingType, @NotNull OCResolveContext context) {
        if (underlyingType == null) {
            OCArgumentsList.$$$reportNull$$$0(14);
        }
        if (context == null) {
            OCArgumentsList.$$$reportNull$$$0(15);
        }
        return OCArgumentsList.getExpandedResolvedTypes(context2 -> context2.getSubstitution().substitute(underlyingType, (OCResolveContext)context2), new OCTypeOwner(){

            @Override
            @NotNull
            public OCType getResolvedType(@NotNull OCResolveContext context2) {
                if (context2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                OCType oCType = underlyingType.resolve(context2);
                if (oCType == null) {
                    4.$$$reportNull$$$0(1);
                }
                return oCType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/resolve/OCArgumentsList$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/resolve/OCArgumentsList$4";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getResolvedType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getResolvedType";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, context);
    }

    @Nullable
    public static List<OCType> getExpandedResolvedTypes(@NotNull OCTypeOwner operand, @NotNull OCTypeOwner dependency, @NotNull OCResolveContext context) {
        if (operand == null) {
            OCArgumentsList.$$$reportNull$$$0(16);
        }
        if (dependency == null) {
            OCArgumentsList.$$$reportNull$$$0(17);
        }
        if (context == null) {
            OCArgumentsList.$$$reportNull$$$0(18);
        }
        return OCArgumentsList.getExpandedResolvedTypes(context1 -> operand.getResolvedType((OCResolveContext)context1), dependency, context);
    }

    @Nullable
    public static <T extends OCTypeArgument> List<T> getExpandedResolvedTypes(@NotNull Function<OCResolveContext, T> operand, @NotNull OCTypeOwner dependency, @NotNull OCResolveContext context) {
        if (operand == null) {
            OCArgumentsList.$$$reportNull$$$0(19);
        }
        if (dependency == null) {
            OCArgumentsList.$$$reportNull$$$0(20);
        }
        if (context == null) {
            OCArgumentsList.$$$reportNull$$$0(21);
        }
        while (context.isVariadicExpansionMode()) {
            context = context.getOriginalContext();
        }
        Set<OCTypeParameterSymbol> dependencies2 = OCArgumentsList.getTypeParameterDependencies(dependency, context);
        List<Pair<OCTypeParameterSymbol, OCExpansionPackType>> expansions = OCArgumentsList.getExpansions(dependencies2, context);
        if (expansions == null || expansions.isEmpty()) {
            return null;
        }
        ArrayList<OCTypeArgument> result = new ArrayList<OCTypeArgument>();
        for (int i2 = 0; i2 < ((OCExpansionPackType)expansions.get((int)0).second).getExpansionsCnt(); ++i2) {
            Map<OCTypeParameterSymbol, OCTypeArgument> map = OCTypeUtils.newTypeParameterMap();
            for (Pair<OCTypeParameterSymbol, OCExpansionPackType> expansion : expansions) {
                map.put((OCTypeParameterSymbol)expansion.first, ((OCExpansionPackType)expansion.second).getExpansions().get(i2));
            }
            OCResolveContext resolveContext = context.substitute(OCSimpleTypeSubstitution.create(map), true, false);
            resolveContext.setVariadicExpansionMode(true);
            OCTypeArgument argument = (OCTypeArgument)operand.fun((Object)resolveContext);
            if (argument == null) {
                return null;
            }
            result.add(argument);
        }
        return result;
    }

    @Nullable
    private static List<Pair<OCTypeParameterSymbol, OCExpansionPackType>> getExpansions(@NotNull Set<OCTypeParameterSymbol> dependencies2, @NotNull OCResolveContext context) {
        if (dependencies2 == null) {
            OCArgumentsList.$$$reportNull$$$0(22);
        }
        if (context == null) {
            OCArgumentsList.$$$reportNull$$$0(23);
        }
        HashSet processed = new HashSet();
        ArrayList<Pair<OCTypeParameterSymbol, OCExpansionPackType>> pairs = new ArrayList<Pair<OCTypeParameterSymbol, OCExpansionPackType>>();
        if (!context.getSubstitution().processSubstitutions((Processor<Map.Entry<OCTypeParameterSymbol, OCTypeArgument>>)((Processor)entry -> {
            OCTypeParameterSymbol parameter = (OCTypeParameterSymbol)entry.getKey();
            OCTypeArgument argument = (OCTypeArgument)entry.getValue();
            if (dependencies2.contains(parameter) && !processed.contains(parameter) && argument instanceof OCExpansionPackType) {
                processed.add(parameter);
                if (!pairs.isEmpty() && ((OCExpansionPackType)((Pair)pairs.get((int)0)).second).getExpansionsCnt() != ((OCExpansionPackType)argument).getExpansionsCnt()) {
                    return false;
                }
                pairs.add(Pair.create((Object)parameter, (Object)((OCExpansionPackType)argument)));
            }
            return true;
        }))) {
            return null;
        }
        return pairs;
    }

    @NotNull
    private static Set<OCTypeParameterSymbol> getTypeParameterDependencies(@NotNull OCTypeOwner dependency, @NotNull OCResolveContext context) {
        if (dependency == null) {
            OCArgumentsList.$$$reportNull$$$0(24);
        }
        if (context == null) {
            OCArgumentsList.$$$reportNull$$$0(25);
        }
        OCResolveContext contextWithoutSubstitutions = context.clearSubstitution();
        contextWithoutSubstitutions.setDontExpandVariadics(true);
        OCType resolvedDependency = dependency.getResolvedType(contextWithoutSubstitutions);
        Set<OCTypeParameterSymbol> set = contextWithoutSubstitutions.getTypeDependencies(resolvedDependency);
        if (set == null) {
            OCArgumentsList.$$$reportNull$$$0(26);
        }
        return set;
    }

    @NotNull
    public List<OCType> getTypes() {
        List<OCType> list = this.types;
        if (list == null) {
            OCArgumentsList.$$$reportNull$$$0(27);
        }
        return list;
    }

    @Nullable
    public List<E> getExprs() {
        return this.exprs;
    }

    public int getCount() {
        return this.types.size();
    }

    public boolean hasNonExpandedVariadics() {
        return this.nonExpandedVariadics;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionsList";
                break;
            }
            case 5: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 9: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/resolve/OCArgumentsList";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionSymbol";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "underlyingType";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 17: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/resolve/OCArgumentsList";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "expandVariadicTypes";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameterDependencies";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentList";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "expandVariadicExpressions";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "expandVariadicTypes";
                break;
            }
            case 8: 
            case 9: 
            case 26: 
            case 27: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "expandExpansionPacks";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "expandVariadicPackExpression";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "expandVariadicType";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getExpandedResolvedTypes";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getExpansions";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterDependencies";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

