/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.UtilKt;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.modulemap.ModuleMapLog;
import com.jetbrains.cidr.lang.modulemap.ModuleMapUtil;
import com.jetbrains.cidr.lang.modulemap.psi.ModuleMapFile;
import com.jetbrains.cidr.lang.modulemap.psi.impl.ModuleMapFileImpl;
import com.jetbrains.cidr.lang.modulemap.resolve.IncludedHeadersRootModuleMapCollector;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapDefaultPathResolver;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapPathResolver;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapAssembledPack;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapSerializationPack;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMap;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSymbol;
import com.jetbrains.cidr.lang.modulemap.symbols.impl.ModuleMapSymbolBuildingService;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.psi.impl.OCCodeFragmentImpl;
import com.jetbrains.cidr.lang.qualifiedName.QualifiedName;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.IncludedHeadersRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.ModuleMapAwareHeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.ModuleMapLocationProvider;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000|\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0004H\u0007\u001a\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"\u001a\u0010\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$*\u00020&\u001a\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$*\b\u0012\u0004\u0012\u00020%0'\u001a\n\u0010(\u001a\u00020)*\u00020\n\u001a\f\u0010(\u001a\u00020)*\u00020\rH\u0002\u001a\n\u0010*\u001a\u00020\u0002*\u00020\"\u001a\f\u0010+\u001a\u0004\u0018\u00010\u0004*\u00020\r\u001a\u0016\u0010,\u001a\u0004\u0018\u00010&*\u00020\n2\b\u0010!\u001a\u0004\u0018\u00010\"\u001a\u0016\u0010-\u001a\u0004\u0018\u00010%*\u00020\u00052\u0006\u0010.\u001a\u00020&H\u0002\u001a\u0016\u0010-\u001a\u0004\u0018\u00010%*\u00020\u00052\b\u0010!\u001a\u0004\u0018\u00010\"\u001a\f\u0010/\u001a\u0004\u0018\u00010\u0004*\u00020\n\u001a\u0012\u00100\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040'*\u00020\u0005\u001a\u001a\u00100\u001a\b\u0012\u0004\u0012\u00020\u00040'*\u00020\u00052\u0006\u0010.\u001a\u00020&H\u0002\u001a\u0010\u00101\u001a\b\u0012\u0004\u0012\u00020\u00040'*\u00020\u0005\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u000e\"\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0015\"\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0016\u00a8\u00062"}, d2={"MODULE_MAP_CONTEXT", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/cidr/lang/preprocessor/OCImmutableInclusionContext;", "mainFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/AppleFramework;", "getMainFile", "(Lcom/jetbrains/cidr/lang/workspace/headerRoots/AppleFramework;)Lcom/intellij/openapi/vfs/VirtualFile;", "possibleModuleMapLocations", "", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot;", "getPossibleModuleMapLocations", "(Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot;)Ljava/util/Collection;", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/IncludedHeadersRoot;", "(Lcom/jetbrains/cidr/lang/workspace/headerRoots/IncludedHeadersRoot;)Ljava/util/Collection;", "rootText", "", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapAssembledPack;", "getRootText", "(Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapAssembledPack;)Ljava/lang/String;", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationPack;", "(Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationPack;)Ljava/lang/String;", "(Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot;)Ljava/lang/String;", "checkModuleMapFile", "", "file", "forceLoadModuleMapFile", "Lcom/jetbrains/cidr/lang/modulemap/psi/ModuleMapFile;", "moduleMapFile", "project", "Lcom/intellij/openapi/project/Project;", "getPreferredLanguageKind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "configuration", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "allModules", "Lkotlin/sequences/Sequence;", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapSymbol;", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMap;", "", "createModuleMapPathResolver", "Lcom/jetbrains/cidr/lang/modulemap/resolve/ModuleMapPathResolver;", "createSignatureContext", "findModuleMapVirtualFile", "getDeclaredModules", "getMainFrameworkModule", "moduleMap", "getModuleMapVirtualFile", "getPublicHeadersToInclude", "getPublicHeadersToIncludeWithoutCaching", "intellij.c"})
@JvmName(name="ModuleMapUtil")
public final class ModuleMapUtil {
    private static final Key<OCImmutableInclusionContext> MODULE_MAP_CONTEXT = new Key("MODULE_MAP_CONTEXT");

    @Contract(value="null -> false")
    public static final boolean checkModuleMapFile(@Nullable VirtualFile file) {
        return file != null && file.isValid() && !file.isDirectory();
    }

    @Nullable
    public static final ModuleMapFile forceLoadModuleMapFile(@NotNull VirtualFile moduleMapFile, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)moduleMapFile, (String)"moduleMapFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"PsiManager.getInstance(project)");
        PsiManager psiManager2 = psiManager;
        PsiFile psi = psiManager2.findFile(moduleMapFile);
        if (psi instanceof ModuleMapFile) {
            return (ModuleMapFile)psi;
        }
        try {
            String string = VfsUtilCore.loadText((VirtualFile)moduleMapFile);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VfsUtilCore.loadText(moduleMapFile)");
            String text = string;
            return ModuleMapFileImpl.createFromText(text, psiManager2);
        }
        catch (IOException e) {
            ModuleMapLog.LOG.info("IOException reading module map at path " + moduleMapFile.getPath(), (Throwable)e);
            return null;
        }
    }

    @NotNull
    public static final List<VirtualFile> getPublicHeadersToIncludeWithoutCaching(@NotNull AppleFramework $this$getPublicHeadersToIncludeWithoutCaching) {
        Intrinsics.checkNotNullParameter((Object)$this$getPublicHeadersToIncludeWithoutCaching, (String)"$this$getPublicHeadersToIncludeWithoutCaching");
        ModuleMap moduleMap = ModuleMapSymbolBuildingService.Companion.getInstance().buildShallowModuleMap((HeadersSearchRoot)$this$getPublicHeadersToIncludeWithoutCaching);
        return ModuleMapUtil.getPublicHeadersToInclude($this$getPublicHeadersToIncludeWithoutCaching, moduleMap);
    }

    @Nullable
    public static final ModuleMap getDeclaredModules(@NotNull HeadersSearchRoot $this$getDeclaredModules, @Nullable OCResolveConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)$this$getDeclaredModules, (String)"$this$getDeclaredModules");
        Project project = $this$getDeclaredModules.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return ModuleMapManager.Companion.getInstance(project).cacheFor(configuration).getModuleMap($this$getDeclaredModules);
    }

    @Nullable
    public static final VirtualFile getMainFile(@NotNull AppleFramework $this$mainFile) {
        Intrinsics.checkNotNullParameter((Object)$this$mainFile, (String)"$this$mainFile");
        ModuleMapSymbol moduleMapSymbol = ModuleMapUtil.getMainFrameworkModule($this$mainFile, null);
        return moduleMapSymbol != null ? moduleMapSymbol.getUmbrellaHeaderVirtualFile() : null;
    }

    @Nullable
    public static final ModuleMapSymbol getMainFrameworkModule(@NotNull AppleFramework $this$getMainFrameworkModule, @Nullable OCResolveConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)$this$getMainFrameworkModule, (String)"$this$getMainFrameworkModule");
        Project project = $this$getMainFrameworkModule.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        ModuleMap moduleMap = ModuleMapManager.Companion.getInstance(project).cacheFor(configuration).getModuleMap((HeadersSearchRoot)$this$getMainFrameworkModule);
        if (moduleMap == null) {
            return null;
        }
        ModuleMap moduleMap2 = moduleMap;
        return ModuleMapUtil.getMainFrameworkModule($this$getMainFrameworkModule, moduleMap2);
    }

    private static final ModuleMapSymbol getMainFrameworkModule(AppleFramework $this$getMainFrameworkModule, ModuleMap moduleMap) {
        String string = $this$getMainFrameworkModule.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        return moduleMap.getModule(QualifiedName.Companion.asQualifiedName(string));
    }

    @NotNull
    public static final List<VirtualFile> getPublicHeadersToInclude(@NotNull AppleFramework $this$getPublicHeadersToInclude) {
        Intrinsics.checkNotNullParameter((Object)$this$getPublicHeadersToInclude, (String)"$this$getPublicHeadersToInclude");
        Object object = ModuleMapUtil.getMainFrameworkModule($this$getPublicHeadersToInclude, null);
        if (object == null || (object = object.getIncludeHeaders()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final List<VirtualFile> getPublicHeadersToInclude(AppleFramework $this$getPublicHeadersToInclude, ModuleMap moduleMap) {
        Object object = ModuleMapUtil.getMainFrameworkModule($this$getPublicHeadersToInclude, moduleMap);
        if (object == null || (object = object.getIncludeHeaders()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Nullable
    public static final VirtualFile findModuleMapVirtualFile(@NotNull IncludedHeadersRoot $this$findModuleMapVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)$this$findModuleMapVirtualFile, (String)"$this$findModuleMapVirtualFile");
        VirtualFile virtualFile = $this$findModuleMapVirtualFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"virtualFile ?: return null");
        VirtualFile dir = virtualFile;
        if (!dir.isValid()) {
            ModuleMapLog.LOG.error("Invalid directory: " + $this$findModuleMapVirtualFile);
            return null;
        }
        VirtualFile defaultFile = dir.findChild("module.modulemap");
        if (ModuleMapUtil.checkModuleMapFile(defaultFile)) {
            return defaultFile;
        }
        VirtualFile legacyFile = dir.findChild("module.map");
        if (ModuleMapUtil.checkModuleMapFile(legacyFile)) {
            return legacyFile;
        }
        return null;
    }

    private static final ModuleMapPathResolver createModuleMapPathResolver(IncludedHeadersRoot $this$createModuleMapPathResolver) {
        ModuleMapPathResolver moduleMapPathResolver;
        VirtualFile virtualFile = $this$createModuleMapPathResolver.getVirtualFile();
        if (virtualFile != null) {
            VirtualFile virtualFile2 = virtualFile;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile it = virtualFile2;
            boolean bl3 = false;
            VirtualFile virtualFile3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"it");
            moduleMapPathResolver = new ModuleMapDefaultPathResolver(virtualFile3, null, 2, null);
        } else {
            moduleMapPathResolver = ModuleMapPathResolver.NULL;
        }
        return moduleMapPathResolver;
    }

    private static final Collection<HeadersSearchRoot> getPossibleModuleMapLocations(IncludedHeadersRoot $this$possibleModuleMapLocations) {
        IncludedHeadersRootModuleMapCollector collector = new IncludedHeadersRootModuleMapCollector($this$possibleModuleMapLocations);
        HeadersSearchRoot.processUnder((PsiElementProcessor)((PsiElementProcessor)collector), (VirtualFile)$this$possibleModuleMapLocations.getVirtualFile(), (boolean)false, (Project)$this$possibleModuleMapLocations.getProject());
        return collector.getRoots();
    }

    @Nullable
    public static final VirtualFile getModuleMapVirtualFile(@NotNull HeadersSearchRoot $this$getModuleMapVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)$this$getModuleMapVirtualFile, (String)"$this$getModuleMapVirtualFile");
        HeadersSearchRoot headersSearchRoot = $this$getModuleMapVirtualFile;
        return headersSearchRoot instanceof ModuleMapAwareHeadersSearchRoot ? ((ModuleMapAwareHeadersSearchRoot)$this$getModuleMapVirtualFile).getModuleMapVirtualFile() : (headersSearchRoot instanceof IncludedHeadersRoot ? ModuleMapUtil.findModuleMapVirtualFile((IncludedHeadersRoot)$this$getModuleMapVirtualFile) : null);
    }

    @NotNull
    public static final ModuleMapPathResolver createModuleMapPathResolver(@NotNull HeadersSearchRoot $this$createModuleMapPathResolver) {
        ModuleMapPathResolver moduleMapPathResolver;
        Intrinsics.checkNotNullParameter((Object)$this$createModuleMapPathResolver, (String)"$this$createModuleMapPathResolver");
        HeadersSearchRoot headersSearchRoot = $this$createModuleMapPathResolver;
        if (headersSearchRoot instanceof ModuleMapAwareHeadersSearchRoot) {
            ModuleMapPathResolver moduleMapPathResolver2 = ((ModuleMapAwareHeadersSearchRoot)$this$createModuleMapPathResolver).createModuleMapPathResolver();
            moduleMapPathResolver = moduleMapPathResolver2;
            Intrinsics.checkNotNullExpressionValue((Object)moduleMapPathResolver2, (String)"this.createModuleMapPathResolver()");
        } else if (headersSearchRoot instanceof IncludedHeadersRoot) {
            moduleMapPathResolver = ModuleMapUtil.createModuleMapPathResolver((IncludedHeadersRoot)$this$createModuleMapPathResolver);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("An attempt to create ModuleMapPathResolver for " + $this$createModuleMapPathResolver)));
        }
        return moduleMapPathResolver;
    }

    @NotNull
    public static final Collection<HeadersSearchRoot> getPossibleModuleMapLocations(@NotNull HeadersSearchRoot $this$possibleModuleMapLocations) {
        Collection<Object> collection;
        Intrinsics.checkNotNullParameter((Object)$this$possibleModuleMapLocations, (String)"$this$possibleModuleMapLocations");
        HeadersSearchRoot headersSearchRoot = $this$possibleModuleMapLocations;
        if (headersSearchRoot instanceof ModuleMapLocationProvider) {
            Collection<Object> collection2 = ((ModuleMapLocationProvider)$this$possibleModuleMapLocations).getPossibleModuleMapLocations();
            collection = collection2;
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"this.possibleModuleMapLocations");
        } else {
            collection = headersSearchRoot instanceof IncludedHeadersRoot ? ModuleMapUtil.getPossibleModuleMapLocations((IncludedHeadersRoot)$this$possibleModuleMapLocations) : (Collection<Object>)CollectionsKt.listOf((Object)$this$possibleModuleMapLocations);
        }
        return collection;
    }

    @NotNull
    public static final String getRootText(@NotNull ModuleMapSerializationPack $this$rootText) {
        Intrinsics.checkNotNullParameter((Object)$this$rootText, (String)"$this$rootText");
        return ModuleMapUtil.getRootText($this$rootText.getHeadersSearchRoot());
    }

    @NotNull
    public static final String getRootText(@NotNull ModuleMapAssembledPack $this$rootText) {
        Intrinsics.checkNotNullParameter((Object)$this$rootText, (String)"$this$rootText");
        return ModuleMapUtil.getRootText($this$rootText.getHeadersSearchRoot());
    }

    @NotNull
    public static final String getRootText(@NotNull HeadersSearchRoot $this$rootText) {
        Intrinsics.checkNotNullParameter((Object)$this$rootText, (String)"$this$rootText");
        boolean $i$f$runReadAction = false;
        Object object = ApplicationManager.getApplication().runReadAction(new Computable($this$rootText){
            final /* synthetic */ HeadersSearchRoot $this_rootText$inlined;
            {
                this.$this_rootText$inlined = headersSearchRoot;
            }

            public final T compute() {
                boolean bl = false;
                return (T)this.$this_rootText$inlined.toString();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction { toString() }");
        return (String)object;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final OCLanguageKind getPreferredLanguageKind(@NotNull OCResolveConfiguration configuration) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            if (PlatformUtils.isAppCode() || PlatformUtils.isMobileIde()) ** GOTO lbl-1000
            v0 = configuration.getEnabledLanguageKinds();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"configuration.enabledLanguageKinds");
            $this$any$iv = v0;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v1 = false;
            } else {
                for (T element$iv : $this$any$iv) {
                    it = (OCLanguageKind)element$iv;
                    $i$a$-any-ModuleMapUtil$getPreferredLanguageKind$hasObjC$1 = false;
                    if (!it.wantsObjC()) continue;
                    v1 = true;
                    break block5;
                }
                v1 = false;
            }
        }
        if (v1) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        hasObjC = v2;
        v3 = CLanguageKind.find((boolean)hasObjC, (boolean)(PlatformUtils.isMobileIde() == false), (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"CLanguageKind.find(hasOb\u2026ils.isMobileIde(), false)");
        return v3;
    }

    @NotNull
    public static final OCImmutableInclusionContext createSignatureContext(@NotNull OCResolveConfiguration $this$createSignatureContext) {
        Intrinsics.checkNotNullParameter((Object)$this$createSignatureContext, (String)"$this$createSignatureContext");
        OCImmutableInclusionContext oCImmutableInclusionContext = (OCImmutableInclusionContext)$this$createSignatureContext.getUserData(MODULE_MAP_CONTEXT);
        if (oCImmutableInclusionContext != null) {
            OCImmutableInclusionContext oCImmutableInclusionContext2 = oCImmutableInclusionContext;
            boolean bl = false;
            boolean bl2 = false;
            OCImmutableInclusionContext it = oCImmutableInclusionContext2;
            boolean bl3 = false;
            OCImmutableInclusionContext oCImmutableInclusionContext3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)oCImmutableInclusionContext3, (String)"it");
            return oCImmutableInclusionContext3;
        }
        OCLanguageKind preferredLanguageKind = ModuleMapUtil.getPreferredLanguageKind($this$createSignatureContext);
        OCCodeFragmentImpl file = new OCCodeFragmentImpl($this$createSignatureContext.getProject(), preferredLanguageKind, "", false, (IElementType)OCTokenTypes.OC_FILE);
        OCInclusionContext oCInclusionContext = OCInclusionContext.beforePCHFileContext($this$createSignatureContext, preferredLanguageKind, file);
        Intrinsics.checkNotNullExpressionValue((Object)oCInclusionContext, (String)"OCInclusionContext.befor\u2026ferredLanguageKind, file)");
        OCInclusionContext context = oCInclusionContext;
        Object object = $this$createSignatureContext.putUserDataIfAbsent(MODULE_MAP_CONTEXT, (Object)context);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"putUserDataIfAbsent(MODULE_MAP_CONTEXT, context)");
        return (OCImmutableInclusionContext)object;
    }

    @NotNull
    public static final Sequence<ModuleMapSymbol> allModules(@NotNull ModuleMap $this$allModules) {
        Intrinsics.checkNotNullParameter((Object)$this$allModules, (String)"$this$allModules");
        return ModuleMapUtil.allModules($this$allModules.getModules());
    }

    @NotNull
    public static final Sequence<ModuleMapSymbol> allModules(@NotNull List<? extends ModuleMapSymbol> $this$allModules) {
        Intrinsics.checkNotNullParameter($this$allModules, (String)"$this$allModules");
        return UtilKt.generateRecursiveSequence((Sequence)CollectionsKt.asSequence((Iterable)$this$allModules), (Function1)allModules.1.INSTANCE);
    }
}

