/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.intentions.OCBraceToggleBaseIntentionAction;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCStatementWithoutBracesIntentionAction
extends OCBraceToggleBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance(OCStatementWithoutBracesIntentionAction.class);

    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message("intentions.add.braces.statement", this.getStatementName());
        if (string == null) {
            OCStatementWithoutBracesIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected void doRun(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCStatement statement;
        if (project == null) {
            OCStatementWithoutBracesIntentionAction.$$$reportNull$$$0(1);
        }
        if (element == null) {
            OCStatementWithoutBracesIntentionAction.$$$reportNull$$$0(2);
        }
        LOG.assertTrue((statement = OCStatementWithoutBracesIntentionAction.getParentStatement(element)) != null);
        PsiElement expr = this.getContainedExpr(statement, element);
        LOG.assertTrue(expr != null);
        PsiElement prevSibling = expr.getPrevSibling();
        PsiElement nestedExpr = OCStatementWithoutBracesIntentionAction.getMacroOrElement(expr, prevSibling);
        CaretModel caretModel = editor.getCaretModel();
        int moveCaretBy = OCStatementWithoutBracesIntentionAction.getCaretAdjustment(caretModel, nestedExpr);
        OCBlockStatement newStatement = OCElementFactory.surroundByBraces(expr);
        PsiElement insertedElement = OCStatementWithoutBracesIntentionAction.replaceElement(expr, newStatement);
        OCStatementWithoutBracesIntentionAction.adjustCaret(insertedElement, prevSibling, caretModel, moveCaretBy);
        OCStatementWithoutBracesIntentionAction.reformat(project, editor.getDocument(), statement);
    }

    @Override
    protected boolean isValidElement(@NotNull OCStatement statement, @NotNull PsiElement element) {
        OCExpression nextExpr;
        PsiElement nextSibling;
        PsiElement expr;
        if (statement == null) {
            OCStatementWithoutBracesIntentionAction.$$$reportNull$$$0(3);
        }
        if (element == null) {
            OCStatementWithoutBracesIntentionAction.$$$reportNull$$$0(4);
        }
        if ((expr = this.getContainedExpr(statement, element)) == null) {
            return false;
        }
        if (expr.getPrevSibling() instanceof OCMacroCall && (nextSibling = statement.getNextSibling()) instanceof OCExpressionStatement && OCElementUtil.isPartOfMacroSubstitution(nextExpr = ((OCExpressionStatement)nextSibling).getExpression())) {
            return false;
        }
        return !(expr instanceof OCBlockStatement);
    }

    private static void adjustCaret(@NotNull PsiElement insertedElement, @NotNull PsiElement prevSibling, @NotNull CaretModel caretModel, int moveCaretBy) {
        List<OCStatement> stmts;
        if (insertedElement == null) {
            OCStatementWithoutBracesIntentionAction.$$$reportNull$$$0(5);
        }
        if (prevSibling == null) {
            OCStatementWithoutBracesIntentionAction.$$$reportNull$$$0(6);
        }
        if (caretModel == null) {
            OCStatementWithoutBracesIntentionAction.$$$reportNull$$$0(7);
        }
        if (insertedElement instanceof OCBlockStatement && (stmts = ((OCBlockStatement)insertedElement).getStatements()).size() == 1) {
            PsiElement containedExpr = stmts.get(0);
            OCStatementWithoutBracesIntentionAction.insertSemiColonIfNeeded(prevSibling, containedExpr);
            PsiElement caretAnchor = OCStatementWithoutBracesIntentionAction.getMacroOrElement(containedExpr);
            OCStatementWithoutBracesIntentionAction.moveCaret(caretModel, moveCaretBy, caretAnchor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCStatementWithoutBracesIntentionAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertedElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevSibling";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCStatementWithoutBracesIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isValidElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "adjustCaret";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

