/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.lang.formatting.OCCodeBlock;
import com.jetbrains.cidr.lang.formatting.OCFormatterInfo;
import com.jetbrains.cidr.lang.formatting.OCFormatterUtil;
import com.jetbrains.cidr.lang.formatting.OCSimpleBlock;
import com.jetbrains.cidr.lang.formatting.OCWrappingProcessor;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCRecursiveBlockTransformer {
    public static final OCRecursiveBlockTransformer CALL_CHAIN_TRANSFORMER = new OCCallChainTransformer();
    public static final OCRecursiveBlockTransformer BINARY_CHAIN_TRANSFORMER = new OCBinaryChainTransformer();

    protected abstract boolean needTransformation(@NotNull ASTNode var1);

    protected abstract boolean needCommonWrapper(@NotNull ASTNode var1);

    protected abstract boolean needKeysFromNodeBlock(@NotNull ASTNode var1);

    protected abstract IElementType getAttrPseudotype(@NotNull ASTNode var1);

    protected abstract boolean chainFirst(@NotNull OCWrappingProcessor var1, @NotNull ASTNode var2);

    @NotNull
    protected abstract SplitterType getSplitterType(@NotNull OCWrappingProcessor var1, @NotNull Block var2, @NotNull ASTNode var3);

    protected void splitAndAdd(@NotNull OCWrappingProcessor ownerWrappingCalculator, @NotNull OCCodeBlock ownerBlock, @NotNull List<Block> ownerCollector, @NotNull Block nodeBlock, @NotNull List<Block> nodeSubBlocks, @NotNull ASTNode node) {
        if (ownerWrappingCalculator == null) {
            OCRecursiveBlockTransformer.$$$reportNull$$$0(0);
        }
        if (ownerBlock == null) {
            OCRecursiveBlockTransformer.$$$reportNull$$$0(1);
        }
        if (ownerCollector == null) {
            OCRecursiveBlockTransformer.$$$reportNull$$$0(2);
        }
        if (nodeBlock == null) {
            OCRecursiveBlockTransformer.$$$reportNull$$$0(3);
        }
        if (nodeSubBlocks == null) {
            OCRecursiveBlockTransformer.$$$reportNull$$$0(4);
        }
        if (node == null) {
            OCRecursiveBlockTransformer.$$$reportNull$$$0(5);
        }
        IElementType formatterPseudotype = this.getAttrPseudotype(node);
        OCFormatterInfo chainAttr = ownerWrappingCalculator.calculate(node, formatterPseudotype);
        OCFormatterInfo joinAttr = OCFormatterInfo.EMPTY;
        ArrayList<Block> commonWrapperCollector = new ArrayList<Block>();
        ArrayList<Object> wrapperCollector = new ArrayList<Block>();
        boolean inChain = !ownerBlock.isInDirective() && this.chainFirst(ownerWrappingCalculator, node);
        Indent childIndent = Indent.getContinuationWithoutFirstIndent();
        for (Block nodeSubBlock : nodeSubBlocks) {
            SplitterType type = this.getSplitterType(ownerWrappingCalculator, nodeSubBlock, node);
            if (type != SplitterType.BlockNotSplitter) {
                if (type == SplitterType.BlockToLeft) {
                    wrapperCollector.add(nodeSubBlock);
                }
                if (!wrapperCollector.isEmpty()) {
                    OCFormatterInfo attr = inChain ? chainAttr : joinAttr;
                    commonWrapperCollector.add(new OCSimpleBlock(attr.wrap, attr.alignment, childIndent, ownerBlock, wrapperCollector));
                    wrapperCollector = new ArrayList();
                }
                if (type == SplitterType.BlockToRight) {
                    wrapperCollector.add(nodeSubBlock);
                }
                inChain = !ownerBlock.isInDirective();
                continue;
            }
            wrapperCollector.add(nodeSubBlock);
        }
        if (!wrapperCollector.isEmpty()) {
            OCFormatterInfo attr = inChain ? chainAttr : joinAttr;
            commonWrapperCollector.add(new OCSimpleBlock(attr.wrap, attr.alignment, childIndent, ownerBlock, wrapperCollector));
        }
        if (!commonWrapperCollector.isEmpty()) {
            if (!ownerBlock.isInDirective()) {
                this.applyIndentCorrection(commonWrapperCollector, ownerWrappingCalculator);
            }
            ownerCollector.add(new OCSimpleBlock(nodeBlock.getWrap(), nodeBlock.getAlignment(), nodeBlock.getIndent(), ownerBlock, commonWrapperCollector));
        }
        ownerBlock.getLocalFormatterData().put(formatterPseudotype, null);
    }

    protected void applyIndentCorrection(List<Block> collector, OCWrappingProcessor ownerWrappingCalculator) {
    }

    public boolean isTransformed(@NotNull OCWrappingProcessor ownerWrappingCalculator, @NotNull OCCodeBlock ownerBlock, @NotNull List<Block> ownerCollector, @NotNull OCCodeBlock nodeBlock, @NotNull ASTNode node) {
        List nodeSubBlocks;
        if (ownerWrappingCalculator == null) {
            OCRecursiveBlockTransformer.$$$reportNull$$$0(6);
        }
        if (ownerBlock == null) {
            OCRecursiveBlockTransformer.$$$reportNull$$$0(7);
        }
        if (ownerCollector == null) {
            OCRecursiveBlockTransformer.$$$reportNull$$$0(8);
        }
        if (nodeBlock == null) {
            OCRecursiveBlockTransformer.$$$reportNull$$$0(9);
        }
        if (node == null) {
            OCRecursiveBlockTransformer.$$$reportNull$$$0(10);
        }
        if (this.needTransformation(node) && !(nodeSubBlocks = nodeBlock.getSubBlocks()).isEmpty()) {
            if (this.needKeysFromNodeBlock(node)) {
                ownerBlock.getLocalFormatterData().merge(nodeBlock.getLocalFormatterData());
            }
            if (this.needCommonWrapper(node)) {
                this.splitAndAdd(ownerWrappingCalculator, ownerBlock, ownerCollector, (Block)nodeBlock, nodeSubBlocks, node);
            } else {
                ownerCollector.addAll(nodeSubBlocks);
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerWrappingCalculator";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerBlock";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerCollector";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeBlock";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeSubBlocks";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/formatting/OCRecursiveBlockTransformer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "splitAndAdd";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isTransformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class OCBinaryChainTransformer
    extends OCRecursiveBlockTransformer {
        @Override
        protected boolean needTransformation(@NotNull ASTNode node) {
            if (node == null) {
                OCBinaryChainTransformer.$$$reportNull$$$0(0);
            }
            return node.getElementType() == OCElementTypes.BINARY_EXPRESSION;
        }

        @Override
        protected boolean needCommonWrapper(@NotNull ASTNode node) {
            if (node == null) {
                OCBinaryChainTransformer.$$$reportNull$$$0(1);
            }
            return !ChainOperations.canChain(node, node.getTreeParent());
        }

        @Override
        protected boolean needKeysFromNodeBlock(@NotNull ASTNode node) {
            if (node == null) {
                OCBinaryChainTransformer.$$$reportNull$$$0(2);
            }
            return !this.needCommonWrapper(node);
        }

        @Override
        protected IElementType getAttrPseudotype(@NotNull ASTNode node) {
            if (node == null) {
                OCBinaryChainTransformer.$$$reportNull$$$0(3);
            }
            return OCWrappingProcessor.BINARY_EXPRESSION_PSEUDOTYPE;
        }

        @Override
        protected boolean chainFirst(@NotNull OCWrappingProcessor ownerWrappingCalculator, @NotNull ASTNode node) {
            if (ownerWrappingCalculator == null) {
                OCBinaryChainTransformer.$$$reportNull$$$0(4);
            }
            if (node == null) {
                OCBinaryChainTransformer.$$$reportNull$$$0(5);
            }
            return true;
        }

        @Override
        @NotNull
        protected SplitterType getSplitterType(@NotNull OCWrappingProcessor ownerWrappingCalculator, @NotNull Block nodeSubBlock, @NotNull ASTNode node) {
            IElementType type;
            if (ownerWrappingCalculator == null) {
                OCBinaryChainTransformer.$$$reportNull$$$0(6);
            }
            if (nodeSubBlock == null) {
                OCBinaryChainTransformer.$$$reportNull$$$0(7);
            }
            if (node == null) {
                OCBinaryChainTransformer.$$$reportNull$$$0(8);
            }
            if ((type = OCCodeBlock.getBlockType(nodeSubBlock)) instanceof OCPunctuatorElementType) {
                SplitterType splitterType = OCTokenTypes.SHIFT_OPERATIONS.contains(type) || ownerWrappingCalculator.getSettings().BINARY_OPERATION_SIGN_ON_NEXT_LINE ? SplitterType.BlockToRight : SplitterType.BlockToLeft;
                if (splitterType == null) {
                    OCBinaryChainTransformer.$$$reportNull$$$0(9);
                }
                return splitterType;
            }
            SplitterType splitterType = SplitterType.BlockNotSplitter;
            if (splitterType == null) {
                OCBinaryChainTransformer.$$$reportNull$$$0(10);
            }
            return splitterType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ownerWrappingCalculator";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeSubBlock";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/formatting/OCRecursiveBlockTransformer$OCBinaryChainTransformer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/formatting/OCRecursiveBlockTransformer$OCBinaryChainTransformer";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSplitterType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "needTransformation";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "needCommonWrapper";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "needKeysFromNodeBlock";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getAttrPseudotype";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "chainFirst";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getSplitterType";
                    break;
                }
                case 9: 
                case 10: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        static class ChainOperations {
            private static final TokenSet ADDITIVE = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.PLUS, OCTokenTypes.MINUS});
            private static final TokenSet MULTIPLICATIVE = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.MUL, OCTokenTypes.DIV, OCTokenTypes.PERC});
            private static final TokenSet BINARY_SHIFT = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.LTLT, OCTokenTypes.GTGT});
            private static final TokenSet LOGICAL = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.LT, OCTokenTypes.GT, OCTokenTypes.LTEQ, OCTokenTypes.GTEQ, OCTokenTypes.EQEQ, OCTokenTypes.EXCLEQ, OCTokenTypes.SPACESHIP});
            private static final TokenSet QUALIFYING = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.DOT_MUL, OCTokenTypes.DEREF_MUL});

            ChainOperations() {
            }

            private static boolean canChain(@Nullable ASTNode node1, @Nullable ASTNode node2) {
                OCElementType type2;
                if (node1 == null || node2 == null) {
                    return false;
                }
                PsiElement psi1 = node1.getPsi();
                PsiElement psi2 = node2.getPsi();
                if (!(psi1 instanceof OCBinaryExpression) || !(psi2 instanceof OCBinaryExpression)) {
                    return false;
                }
                OCElementType type1 = ((OCBinaryExpression)psi1).getOperationSign();
                return type1 == (type2 = ((OCBinaryExpression)psi2).getOperationSign()) || ADDITIVE.contains((IElementType)type1) && ADDITIVE.contains((IElementType)type2) || MULTIPLICATIVE.contains((IElementType)type1) && MULTIPLICATIVE.contains((IElementType)type2) || BINARY_SHIFT.contains((IElementType)type1) && BINARY_SHIFT.contains((IElementType)type2) || LOGICAL.contains((IElementType)type1) && LOGICAL.contains((IElementType)type2) || QUALIFYING.contains((IElementType)type1) && QUALIFYING.contains((IElementType)type2);
            }
        }
    }

    protected static class OCCallChainTransformer
    extends OCRecursiveBlockTransformer {
        protected OCCallChainTransformer() {
        }

        @Override
        protected boolean needTransformation(@NotNull ASTNode node) {
            IElementType type;
            if (node == null) {
                OCCallChainTransformer.$$$reportNull$$$0(0);
            }
            return (type = node.getElementType()) == OCElementTypes.QUALIFIED_EXPRESSION || type == OCElementTypes.CALL_EXPRESSION;
        }

        @Override
        protected boolean needCommonWrapper(@NotNull ASTNode node) {
            if (node == null) {
                OCCallChainTransformer.$$$reportNull$$$0(1);
            }
            return !this.needTransformation(node.getTreeParent());
        }

        @Override
        protected boolean needKeysFromNodeBlock(@NotNull ASTNode node) {
            if (node == null) {
                OCCallChainTransformer.$$$reportNull$$$0(2);
            }
            return true;
        }

        @Override
        protected IElementType getAttrPseudotype(@NotNull ASTNode node) {
            if (node == null) {
                OCCallChainTransformer.$$$reportNull$$$0(3);
            }
            return OCWrappingProcessor.CHAINED_CALL_PSEUDOTYPE;
        }

        @Override
        protected boolean chainFirst(@NotNull OCWrappingProcessor ownerWrappingCalculator, @NotNull ASTNode node) {
            if (ownerWrappingCalculator == null) {
                OCCallChainTransformer.$$$reportNull$$$0(4);
            }
            if (node == null) {
                OCCallChainTransformer.$$$reportNull$$$0(5);
            }
            return false;
        }

        @Override
        protected void applyIndentCorrection(List<Block> collector, OCWrappingProcessor ownerWrappingCalculator) {
            OCFormatterUtil.applyIndentCorrection(false, collector, ownerWrappingCalculator.getSettings().METHOD_CALL_CHAIN_WRAP, ownerWrappingCalculator.getSettings().KEEP_LINE_BREAKS, (Condition<? super ASTNode>)((Condition)node -> OCElementUtil.getElementType(node) == OCElementTypes.QUALIFIED_EXPRESSION_ACCESSOR));
        }

        @Override
        @NotNull
        protected SplitterType getSplitterType(@NotNull OCWrappingProcessor ownerWrappingCalculator, @NotNull Block nodeSubBlock, @NotNull ASTNode node) {
            if (ownerWrappingCalculator == null) {
                OCCallChainTransformer.$$$reportNull$$$0(6);
            }
            if (nodeSubBlock == null) {
                OCCallChainTransformer.$$$reportNull$$$0(7);
            }
            if (node == null) {
                OCCallChainTransformer.$$$reportNull$$$0(8);
            }
            SplitterType splitterType = OCCodeBlock.getBlockType(nodeSubBlock) == OCElementTypes.QUALIFIED_EXPRESSION_ACCESSOR ? SplitterType.BlockToRight : SplitterType.BlockNotSplitter;
            if (splitterType == null) {
                OCCallChainTransformer.$$$reportNull$$$0(9);
            }
            return splitterType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ownerWrappingCalculator";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeSubBlock";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/formatting/OCRecursiveBlockTransformer$OCCallChainTransformer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/formatting/OCRecursiveBlockTransformer$OCCallChainTransformer";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSplitterType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "needTransformation";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "needCommonWrapper";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "needKeysFromNodeBlock";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getAttrPseudotype";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "chainFirst";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getSplitterType";
                    break;
                }
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum SplitterType {
        BlockNotSplitter,
        BlockToLeft,
        BlockToRight;

    }
}

