/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.compdb.wizard;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.CidrProjectOpenProcessor;
import com.jetbrains.cidr.ProjectOpenFileHelper;
import com.jetbrains.cidr.ProjectOpenHelper;
import com.jetbrains.cidr.cpp.compdb.CompDBBundle;
import com.jetbrains.cidr.cpp.compdb.CompDBLog;
import com.jetbrains.cidr.cpp.compdb.CompDBUtil;
import com.jetbrains.cidr.cpp.compdb.CompDBUtilKt;
import com.jetbrains.cidr.cpp.compdb.wizard.OpenProjectSpec;
import com.jetbrains.cidr.external.system.fus.CidrExternalUsageUtil;
import java.io.File;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J$\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/cpp/compdb/wizard/CompDBProjectOpenProcessor;", "Lcom/jetbrains/cidr/CidrProjectOpenProcessor;", "()V", "canOpenProject", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "doOpenProject", "Lcom/intellij/openapi/project/Project;", "virtualFile", "projectToClose", "forceOpenInNewFrame", "getIcon", "Ljavax/swing/Icon;", "getName", "", "Companion", "intellij.clion.compdb"})
public final class CompDBProjectOpenProcessor
extends CidrProjectOpenProcessor {
    private static final Key<OpenProjectSpec> DATA_KEY;
    @NotNull
    private static final ProjectOpenFileHelper<OpenProjectSpec> helper;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public String getName() {
        String string = CompDBBundle.message("external.system.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CompDBBundle.message(\"external.system.name\")");
        return string;
    }

    public boolean canOpenProject(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile = helper.findSupportedSubFile(file);
        if (virtualFile == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"helper.findSupportedSubFile(file) ?: return false");
        VirtualFile databaseFile = virtualFile;
        return super.canOpenProject(databaseFile);
    }

    @Nullable
    public Project doOpenProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        VirtualFile externalProjectPath;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        VirtualFile virtualFile2 = helper.findSupportedSubFile(virtualFile);
        if (virtualFile2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"helper.findSupportedSubF\u2026rtualFile) ?: return null");
        VirtualFile database = virtualFile2;
        CompDBLog.INSTANCE.getLOG().assertTrue(!database.isDirectory());
        Project existingProject = helper.openExistingProjectInDirectory(database, projectToClose, forceOpenInNewFrame);
        if (existingProject != null) {
            return existingProject;
        }
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)database);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"VfsUtilCore.virtualToIoFile(database)");
        OpenProjectSpec spec = new OpenProjectSpec(file);
        Project project = helper.openProject(database, projectToClose, forceOpenInNewFrame, (Object)spec);
        if (project == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"helper.openProject(datab\u2026ame, spec) ?: return null");
        Project project2 = project;
        CidrExternalUsageUtil.INSTANCE.logProjectCreated(CompDBUtilKt.getID(), project2);
        VirtualFile virtualFile3 = externalProjectPath = database.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"externalProjectPath");
        CompDBUtil.INSTANCE.linkCompDBProject(project2, virtualFile3);
        return project2;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Nodes.Project;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AllIcons.Nodes.Project");
        return icon;
    }

    public CompDBProjectOpenProcessor() {
        super((ProjectOpenHelper)helper);
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"COMP_DB_TO_OPEN_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<OpenProjectSpec>(\"COMP_DB_TO_OPEN_KEY\")");
        DATA_KEY = key;
        helper = new ProjectOpenFileHelper(CollectionsKt.listOf((Object)"compile_commands.json"), DATA_KEY);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/cpp/compdb/wizard/CompDBProjectOpenProcessor$Companion;", "", "()V", "DATA_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/cidr/cpp/compdb/wizard/OpenProjectSpec;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "helper", "Lcom/jetbrains/cidr/ProjectOpenFileHelper;", "getHelper", "()Lcom/jetbrains/cidr/ProjectOpenFileHelper;", "intellij.clion.compdb"})
    public static final class Companion {
        @NotNull
        public final ProjectOpenFileHelper<OpenProjectSpec> getHelper() {
            return helper;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

