/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cloudConfig;

import com.intellij.cloudConfig.CloudConfigManager;
import com.intellij.cloudConfig.ConfigList;
import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.idea.cloudConfig.CloudConfigClientUtil;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u001a\u0010\u0017\u001a\u00020\u00132\u0010\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u0018\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u0018\u0010!\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016JL\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0%2\u001e\u0010&\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0'H\u0016J.\u0010)\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0014\u0010*\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010(\u0012\u0004\u0012\u00020\u00130%H\u0016J(\u0010+\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000fj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/cloudConfig/CloudConfigStreamProvider;", "Lcom/intellij/configurationStore/StreamProvider;", "configDir", "Ljava/nio/file/Path;", "manager", "Lcom/intellij/cloudConfig/CloudConfigManager;", "(Ljava/nio/file/Path;Lcom/intellij/cloudConfig/CloudConfigManager;)V", "fileStorages", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "isExclusive", "", "()Z", "osNames", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "schemeStorages", "addConfigToOsSpecific", "", "storageClass", "Ljava/lang/Class;", "fileSpec", "addConfigs", "storageClasses", "", "checkFile", "file", "convertName", "delete", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "findStorage", "isApplicable", "processChildren", "path", "filter", "Lkotlin/Function1;", "processor", "Lkotlin/Function3;", "Ljava/io/InputStream;", "read", "consumer", "write", "content", "", "size", "", "intellij.cloudConfig"})
public final class CloudConfigStreamProvider
implements StreamProvider {
    private final HashSet<String> fileStorages;
    private final HashSet<String> schemeStorages;
    private final HashMap<String, String> osNames;
    private final boolean isExclusive;
    private final Path configDir;
    private final CloudConfigManager manager;

    public boolean isExclusive() {
        return this.isExclusive;
    }

    private final void addConfigs(List<? extends Class<?>> storageClasses) {
        for (Class<?> storageClass : storageClasses) {
            String fileSpec;
            State spec;
            Intrinsics.checkNotNull((Object)StoreUtilKt.getStateSpec(storageClass));
            Intrinsics.checkNotNull((Object)StoreUtilKt.getDefaultStoragePathSpec((State)spec));
            this.fileStorages.add(fileSpec);
            this.addConfigToOsSpecific(storageClass, fileSpec);
            CharSequence charSequence = spec.additionalExportDirectory();
            boolean bl = false;
            if (!(charSequence.length() > 0)) continue;
            this.schemeStorages.add(spec.additionalExportDirectory());
            this.addConfigToOsSpecific(storageClass, spec.additionalExportDirectory());
        }
    }

    private final void addConfigToOsSpecific(Class<?> storageClass, String fileSpec) {
        if (ConfigList.isOSConfig(storageClass)) {
            String string = StringUtil.trimStart((String)fileSpec, (String)(StoreUtilKt.getPerOsSettingsStorageFolderName() + "/"));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.trimStart(fil\u2026torageFolderName() + \"/\")");
            String spec = string;
            ((Map)this.osNames).put(spec, CloudConfigClientUtil.getOS() + "." + spec);
        }
    }

    public boolean isApplicable(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
        String osPrefix = StoreUtilKt.getPerOsSettingsStorageFolderName() + "/";
        int searchForSlash = StringsKt.startsWith$default((String)fileSpec, (String)osPrefix, (boolean)false, (int)2, null) ? osPrefix.length() : 0;
        int index = StringsKt.indexOf$default((CharSequence)fileSpec, (char)'/', (int)searchForSlash, (boolean)false, (int)4, null);
        if (index == -1) {
            return this.findStorage(fileSpec);
        }
        String string = fileSpec;
        int n = 0;
        boolean bl = false;
        String string2 = string.substring(n, index);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return this.findStorage(string2);
    }

    private final boolean findStorage(String fileSpec) {
        return this.fileStorages.contains(fileSpec) || this.schemeStorages.contains(fileSpec);
    }

    private final String convertName(String fileSpec) {
        String string = StringUtil.trimStart((String)fileSpec, (String)(StoreUtilKt.getPerOsSettingsStorageFolderName() + "/"));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.trimStart(fil\u2026torageFolderName() + \"/\")");
        String spec = string;
        int index = StringsKt.indexOf$default((CharSequence)spec, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (index == -1) {
            String string2 = this.osNames.get(spec);
            if (string2 == null) {
                return spec;
            }
            return string2;
        }
        String string3 = spec;
        int n = 0;
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(n, index);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String firstName = this.osNames.get(string5);
        if (firstName != null) {
            StringBuilder stringBuilder = new StringBuilder().append(firstName).append("/");
            string3 = spec;
            n = index + 1;
            bl = false;
            String string6 = string3;
            if (string6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
            return stringBuilder.append(string7).toString();
        }
        return spec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read(@NotNull String fileSpec, @NotNull RoamingType roamingType, @NotNull Function1<? super InputStream, Unit> consumer) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (!this.isApplicable(fileSpec, roamingType)) {
            return false;
        }
        Path path2 = path = this.configDir.resolve(this.convertName(fileSpec));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
        if (this.checkFile(path2)) {
            Closeable closeable = PathKt.inputStream((Path)path);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Object object = consumer.invoke((Object)closeable);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            consumer.invoke(null);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean processChildren(@NotNull String path, @NotNull RoamingType roamingType, @NotNull Function1<? super String, Boolean> filter, @NotNull Function3<? super String, ? super InputStream, ? super Boolean, Boolean> processor) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        if (!this.isApplicable(path, roamingType)) {
            return false;
        }
        Path path2 = this.configDir.resolve(this.convertName(path));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"configDir.resolve(convertName(path))");
        Path path3 = path2;
        Function1 filter$iv = (Function1)new Function1<Path, Boolean>(filter){
            final /* synthetic */ Function1 $filter;

            public final boolean invoke(@NotNull Path it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (Boolean)this.$filter.invoke((Object)((Object)it.getFileName()).toString());
            }
            {
                this.$filter = function1;
                super(1);
            }
        };
        boolean $i$f$directoryStreamIfExists = false;
        try {
            void $this$directoryStreamIfExists$iv;
            Closeable closeable = Files.newDirectoryStream((Path)$this$directoryStreamIfExists$iv, new DirectoryStream.Filter(filter$iv){
                final /* synthetic */ Function1 $filter;
                {
                    this.$filter = function1;
                }

                public final boolean accept(Path it) {
                    Path path = it;
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it");
                    return (Boolean)this.$filter.invoke((Object)path);
                }
            });
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                DirectoryStream directoryStream = (DirectoryStream)closeable;
                boolean bl3 = false;
                Iterator iterator = directoryStream.iterator();
                while (iterator.hasNext()) {
                    boolean bl4;
                    Path file;
                    Path path4 = file = (Path)iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"file");
                    if (!this.checkFile(path4)) continue;
                    Closeable closeable2 = PathKt.inputStream((Path)file);
                    boolean bl5 = false;
                    boolean bl6 = false;
                    Throwable throwable2 = null;
                    try {
                        InputStream it = (InputStream)closeable2;
                        boolean bl7 = false;
                        bl4 = (Boolean)processor.invoke((Object)((Object)file.getFileName()).toString(), (Object)it, (Object)false);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    if (bl4) continue;
                    break;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        return true;
    }

    public void write(@NotNull String fileSpec, @NotNull byte[] content, int size, @NotNull RoamingType roamingType) {
        Path file;
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
        String fileName = this.convertName(fileSpec);
        Path path = file = this.configDir.resolve(fileName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file");
        if (this.checkFile(path)) {
            int n = 0;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)PathKt.readText((Path)file), (Object)new String(content, n, size, Charsets.UTF_8))) {
                return;
            }
        }
        PathKt.write((Path)file, (byte[])content, (int)0, (int)size);
        this.manager.editConfigFiles(fileName);
    }

    public boolean delete(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
        if (!this.isApplicable(fileSpec, roamingType)) {
            return false;
        }
        String fileName = this.convertName(fileSpec);
        Path path = this.configDir.resolve(fileName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"configDir.resolve(fileName)");
        PathKt.delete$default((Path)path, (boolean)false, (int)1, null);
        this.manager.editConfigFiles(fileName);
        return true;
    }

    private final boolean checkFile(Path file) {
        BasicFileAttributes attributes = PathKt.basicAttributesIfExists((Path)file);
        return attributes != null && !attributes.isDirectory() && attributes.size() > 0L && !PathKt.isHidden((Path)file);
    }

    public CloudConfigStreamProvider(@NotNull Path configDir, @NotNull CloudConfigManager manager) {
        Intrinsics.checkNotNullParameter((Object)configDir, (String)"configDir");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.configDir = configDir;
        this.manager = manager;
        this.fileStorages = new HashSet();
        this.schemeStorages = new HashSet();
        this.osNames = new HashMap();
        this.isExclusive = true;
        List<Class<?>> list = this.manager.getAllClasses();
        Intrinsics.checkNotNullExpressionValue(list, (String)"manager.allClasses");
        this.addConfigs(list);
    }

    public void write(@NotNull String path, @NotNull BufferExposingByteArrayOutputStream content, @NotNull RoamingType roamingType) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
        StreamProvider.DefaultImpls.write((StreamProvider)this, (String)path, (BufferExposingByteArrayOutputStream)content, (RoamingType)roamingType);
    }

    public boolean getEnabled() {
        return StreamProvider.DefaultImpls.getEnabled((StreamProvider)this);
    }
}

