/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.fixtures;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.ServiceContainerUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.fixtures.OCMockProjectReader;
import com.jetbrains.cidr.lang.fixtures.OCMockWorkspace;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceImpl;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceProvider;
import java.io.File;
import kotlin.collections.ArraysKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public final class OCMockProjectDescriptor
extends LightProjectDescriptor {
    @NotNull
    private final VirtualFile myProjectFile;

    public OCMockProjectDescriptor(@NotNull VirtualFile projectFile) {
        if (projectFile == null) {
            OCMockProjectDescriptor.$$$reportNull$$$0(0);
        }
        this.myProjectFile = projectFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static OCMockWorkspace createAndRegisterMockWorkspace(@NotNull OCWorkspaceImpl workspace, @NotNull String clientKey, @NotNull VirtualFile projectFile) {
        boolean isProjectFile;
        if (workspace == null) {
            OCMockProjectDescriptor.$$$reportNull$$$0(1);
        }
        if (clientKey == null) {
            OCMockProjectDescriptor.$$$reportNull$$$0(2);
        }
        if (projectFile == null) {
            OCMockProjectDescriptor.$$$reportNull$$$0(3);
        }
        VirtualFile projectDir = (isProjectFile = FileUtilRt.extensionEquals((String)projectFile.getName(), (String)"yaml")) ? projectFile.getParent() : projectFile;
        OCMockWorkspace mockWorkspace = new OCMockWorkspace(workspace, clientKey, projectDir);
        OCMockProjectDescriptor.registerWorkspaceProvider(mockWorkspace);
        if (isProjectFile) {
            OCMockProjectReader.read(new File(projectFile.getPath()), mockWorkspace);
        } else {
            OCWorkspace.ModifiableModel model = workspace.getModifiableModel(clientKey);
            try {
                OCResolveConfiguration.ModifiableModel configModel = model.addConfiguration("default", "default");
                for (CLanguageKind eachLang : CLanguageKind.values()) {
                    OCMockWorkspace.applyDefaultDefinesAndFeatures((OCLanguageKind)eachLang, configModel.getLanguageCompilerSettings((OCLanguageKind)eachLang));
                }
                model.preCommit();
                WriteAction.run(() -> ((OCWorkspace.ModifiableModel)model).commit());
            }
            finally {
                model.dispose();
            }
        }
        OCMockWorkspace oCMockWorkspace = mockWorkspace;
        if (oCMockWorkspace == null) {
            OCMockProjectDescriptor.$$$reportNull$$$0(4);
        }
        return oCMockWorkspace;
    }

    private static void registerWorkspaceProvider(@NotNull CidrWorkspace workspace) {
        if (workspace == null) {
            OCMockProjectDescriptor.$$$reportNull$$$0(5);
        }
        CidrWorkspaceProvider.EP_NAME.getPoint().registerExtension(p -> p == workspace.getProject() ? workspace : null, (Disposable)workspace.getProject());
    }

    @Override
    public void setUpProject(@NotNull Project project2, @NotNull LightProjectDescriptor.SetupHandler handler) throws Exception {
        if (project2 == null) {
            OCMockProjectDescriptor.$$$reportNull$$$0(6);
        }
        if (handler == null) {
            OCMockProjectDescriptor.$$$reportNull$$$0(7);
        }
        super.setUpProject(project2, handler);
        OCWorkspaceImpl workspace = new OCWorkspaceImpl(project2, false);
        OCMockWorkspace mockWorkspace = OCMockProjectDescriptor.createAndRegisterMockWorkspace(workspace, "Legacy", this.myProjectFile);
        ServiceContainerUtil.registerComponentImplementation((ComponentManager)project2, OCWorkspace.class, OCWorkspaceImpl.class);
        ServiceContainerUtil.registerComponentInstance((ComponentManager)project2, OCWorkspace.class, workspace);
        Assert.assertSame((Object)workspace, (Object)OCWorkspace.getInstance((Project)project2));
        ModuleType defaultModuleType = ModuleTypeManager.getInstance().getDefaultModuleType();
        if (defaultModuleType != null) {
            Module module = (Module)ArraysKt.single((Object[])ModuleManager.getInstance((Project)project2).getModules());
            module.setModuleType(defaultModuleType.getId());
        }
        mockWorkspace.initialized();
    }

    @Override
    @Nullable
    public VirtualFile createDirForSources(@NotNull Module module) {
        if (module == null) {
            OCMockProjectDescriptor.$$$reportNull$$$0(8);
        }
        return null;
    }

    @Nullable
    public static OCMockWorkspace getMockWorkspace(@NotNull Project project2) {
        if (project2 == null) {
            OCMockProjectDescriptor.$$$reportNull$$$0(9);
        }
        return (OCMockWorkspace)((Object)ContainerUtil.findInstance((Iterable)CidrWorkspace.getWorkspaces((Project)project2), OCMockWorkspace.class));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFile";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspace";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientKey";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/fixtures/OCMockProjectDescriptor";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/fixtures/OCMockProjectDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndRegisterMockWorkspace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createAndRegisterMockWorkspace";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerWorkspaceProvider";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setUpProject";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDirForSources";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMockWorkspace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

