/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrTestCase;
import com.jetbrains.cidr.CidrTestDataFixture;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.CPPTestCase;
import com.jetbrains.cidr.cpp.cmake.CMakeProjectFixture;
import com.jetbrains.cidr.cpp.cmake.console.CMakeOutputFilter;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.cmake.model.CMakeData;
import com.jetbrains.cidr.cpp.cmake.model.CMakeFileSettings;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGenerator;
import com.jetbrains.cidr.cpp.cmake.model.CMakeListener;
import com.jetbrains.cidr.cpp.cmake.model.CMakeMessage;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModel;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModelConfigurationData;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTarget;
import com.jetbrains.cidr.cpp.cmake.model.CMakeVariable;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeModelFixture {
    private final CidrTestDataFixture myTestDataFixture;
    @Nullable
    private final String myMinimumCmakeVersionOrNullForDefault;
    private int configCounter = 0;

    public CMakeModelFixture(CidrTestDataFixture testDataFixture, @Nullable String minimumCmakeVersionOrNullForDefault) {
        this.myTestDataFixture = testDataFixture;
        this.myMinimumCmakeVersionOrNullForDefault = minimumCmakeVersionOrNullForDefault;
    }

    @NotNull
    public File prepareTestData(@NotNull String relativeTestProject) {
        if (relativeTestProject == null) {
            CMakeModelFixture.$$$reportNull$$$0(0);
        }
        File file2 = this.prepareTestData(relativeTestProject, this.myTestDataFixture.createTempIODir());
        if (file2 == null) {
            CMakeModelFixture.$$$reportNull$$$0(1);
        }
        return file2;
    }

    @NotNull
    public File prepareTestData(@NotNull String relativeTestProject, @NotNull File copyInto) {
        if (relativeTestProject == null) {
            CMakeModelFixture.$$$reportNull$$$0(2);
        }
        if (copyInto == null) {
            CMakeModelFixture.$$$reportNull$$$0(3);
        }
        File testData = this.myTestDataFixture.getTestDataProjectsFile(relativeTestProject);
        this.myTestDataFixture.copyTestData(testData, copyInto);
        File result = new File(copyInto, testData.getName());
        FileUtil.processFilesRecursively((File)result, file2 -> {
            try {
                if (file2.getName().equalsIgnoreCase("CMakeLists.txt") && FileUtil.loadFile((File)file2).contains("project(")) {
                    String version = this.myMinimumCmakeVersionOrNullForDefault == null ? CMakeModelFixture.getCurrentCMakeVersion() : this.myMinimumCmakeVersionOrNullForDefault;
                    String updateWith = "cmake_minimum_required(VERSION " + version + ")";
                    this.myTestDataFixture.updateIOFileRegexpText((File)file2, "(.*)cmake_minimum_required\\(VERSION .*?\\)(.*)", "$1" + Matcher.quoteReplacement(updateWith) + "$2");
                    return false;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Main CMakeLists.txt should contain cmake_minimum_required() line ", e);
            }
            return true;
        });
        File file3 = result;
        if (file3 == null) {
            CMakeModelFixture.$$$reportNull$$$0(4);
        }
        return file3;
    }

    @NotNull
    private static String getCurrentCMakeVersion() {
        String string = CPPTestCase.getTestCMakeVersion();
        if (string == null) {
            CMakeModelFixture.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static boolean isApiWithoutToolchainsForced() {
        return CMakeGenerator.isAPIForced() && CPPTestCase.getTestCMakeParsedVersion().lessThan(Integer.valueOf(3), Integer.valueOf(20));
    }

    @NotNull
    public GenerateInfo generateProjectFromScratch(@NotNull String relativeTestProject, String ... configNames) {
        if (relativeTestProject == null) {
            CMakeModelFixture.$$$reportNull$$$0(6);
        }
        File projectDir = this.prepareTestData(relativeTestProject);
        if (configNames.length == 0) {
            configNames = new String[]{"Debug"};
        }
        GenerateInfo generateInfo = this.generateProject(projectDir, null, ContainerUtil.map((Object[])configNames, name -> this.config((String)name, this.myTestDataFixture.createTempIODir())));
        if (generateInfo == null) {
            CMakeModelFixture.$$$reportNull$$$0(7);
        }
        return generateInfo;
    }

    @NotNull
    public CMakeGenerator.Parameters debug() {
        CMakeGenerator.Parameters parameters = this.debug(this.myTestDataFixture.createTempIODir());
        if (parameters == null) {
            CMakeModelFixture.$$$reportNull$$$0(8);
        }
        return parameters;
    }

    @NotNull
    public CMakeGenerator.Parameters debug(@NotNull File generatedDir) {
        if (generatedDir == null) {
            CMakeModelFixture.$$$reportNull$$$0(9);
        }
        CMakeGenerator.Parameters parameters = this.config("Debug", generatedDir);
        if (parameters == null) {
            CMakeModelFixture.$$$reportNull$$$0(10);
        }
        return parameters;
    }

    @NotNull
    public CMakeGenerator.Parameters config(@NotNull String profileAndBuildType) {
        if (profileAndBuildType == null) {
            CMakeModelFixture.$$$reportNull$$$0(11);
        }
        CMakeGenerator.Parameters parameters = this.config(profileAndBuildType, this.myTestDataFixture.createTempIODir());
        if (parameters == null) {
            CMakeModelFixture.$$$reportNull$$$0(12);
        }
        return parameters;
    }

    @NotNull
    public CMakeGenerator.Parameters config(@NotNull String profileAndBuildType, @NotNull File generatedDir) {
        if (profileAndBuildType == null) {
            CMakeModelFixture.$$$reportNull$$$0(13);
        }
        if (generatedDir == null) {
            CMakeModelFixture.$$$reportNull$$$0(14);
        }
        return new CMakeGenerator.Parameters(this.configCounter++, profileAndBuildType, profileAndBuildType, generatedDir, Collections.emptyList(), true, Collections.emptyMap(), (CMakeListener)new TestCMakeListener(profileAndBuildType), CPPTestCase.getTestCPPEnvironment());
    }

    @NotNull
    public CMakeGenerator.Parameters debugWithAdditionalOptions(String ... additionalOptions) {
        if (additionalOptions == null) {
            CMakeModelFixture.$$$reportNull$$$0(15);
        }
        CMakeGenerator.Parameters parameters = this.withAdditionalOptions("Debug", additionalOptions);
        if (parameters == null) {
            CMakeModelFixture.$$$reportNull$$$0(16);
        }
        return parameters;
    }

    @NotNull
    public CMakeGenerator.Parameters withAdditionalOptions(@NotNull String profileAndBuildType, String ... additionalOptions) {
        if (profileAndBuildType == null) {
            CMakeModelFixture.$$$reportNull$$$0(17);
        }
        if (additionalOptions == null) {
            CMakeModelFixture.$$$reportNull$$$0(18);
        }
        CMakeGenerator.Parameters parameters = this.withAdditionalOptions(profileAndBuildType, this.myTestDataFixture.createTempIODir(), additionalOptions);
        if (parameters == null) {
            CMakeModelFixture.$$$reportNull$$$0(19);
        }
        return parameters;
    }

    @NotNull
    public CMakeGenerator.Parameters debugWithAdditionalOptions(@NotNull File generatedDir, String ... additionalOptions) {
        if (generatedDir == null) {
            CMakeModelFixture.$$$reportNull$$$0(20);
        }
        if (additionalOptions == null) {
            CMakeModelFixture.$$$reportNull$$$0(21);
        }
        CMakeGenerator.Parameters parameters = this.withAdditionalOptions("Debug", generatedDir, additionalOptions);
        if (parameters == null) {
            CMakeModelFixture.$$$reportNull$$$0(22);
        }
        return parameters;
    }

    @NotNull
    public CMakeGenerator.Parameters withAdditionalOptions(@NotNull String profileAndBuildType, @NotNull File generatedDir, String ... additionalOptions) {
        if (profileAndBuildType == null) {
            CMakeModelFixture.$$$reportNull$$$0(23);
        }
        if (generatedDir == null) {
            CMakeModelFixture.$$$reportNull$$$0(24);
        }
        if (additionalOptions == null) {
            CMakeModelFixture.$$$reportNull$$$0(25);
        }
        return new CMakeGenerator.Parameters(this.configCounter++, profileAndBuildType, profileAndBuildType, generatedDir, Arrays.asList(additionalOptions), true, Collections.emptyMap(), (CMakeListener)new TestCMakeListener(profileAndBuildType), CPPTestCase.getTestCPPEnvironment());
    }

    @NotNull
    public CMakeGenerator.Parameters debugWithEnvironment(@NotNull File generatedDir, boolean passSystem, String ... additionalVariables) {
        if (generatedDir == null) {
            CMakeModelFixture.$$$reportNull$$$0(26);
        }
        if (additionalVariables == null) {
            CMakeModelFixture.$$$reportNull$$$0(27);
        }
        return new CMakeGenerator.Parameters(this.configCounter++, "Debug", "Debug", generatedDir, Collections.emptyList(), passSystem, ContainerUtil.stringMap((String[])additionalVariables), (CMakeListener)new TestCMakeListener("Debug"), CPPTestCase.getTestCPPEnvironment());
    }

    @NotNull
    public GenerateInfo generateProject(@NotNull GenerateInfo info) {
        if (info == null) {
            CMakeModelFixture.$$$reportNull$$$0(28);
        }
        GenerateInfo generateInfo = this.generateProject(info.projectDir, info.model, ContainerUtil.map((Collection)info.model.getConfigurationData(), each -> this.config(each.getConfigName(), each.getGenerationDir())));
        if (generateInfo == null) {
            CMakeModelFixture.$$$reportNull$$$0(29);
        }
        return generateInfo;
    }

    @NotNull
    public GenerateInfo generateProject(@NotNull File projectDir, @Nullable CMakeModel existingModel, CMakeGenerator.Parameters ... parameters) {
        if (projectDir == null) {
            CMakeModelFixture.$$$reportNull$$$0(30);
        }
        if (parameters == null) {
            CMakeModelFixture.$$$reportNull$$$0(31);
        }
        GenerateInfo generateInfo = this.generateProject(projectDir, existingModel, Arrays.asList(parameters));
        if (generateInfo == null) {
            CMakeModelFixture.$$$reportNull$$$0(32);
        }
        return generateInfo;
    }

    @NotNull
    public GenerateInfo generateProject(@NotNull File projectDir, @Nullable CMakeModel existingModel, @NotNull List<CMakeGenerator.Parameters> parameters) {
        if (projectDir == null) {
            CMakeModelFixture.$$$reportNull$$$0(33);
        }
        if (parameters == null) {
            CMakeModelFixture.$$$reportNull$$$0(34);
        }
        GenerateInfo generateInfo = this.generateProject(projectDir, existingModel, Charset.defaultCharset(), parameters);
        if (generateInfo == null) {
            CMakeModelFixture.$$$reportNull$$$0(35);
        }
        return generateInfo;
    }

    @NotNull
    public GenerateInfo generateProject(@NotNull File projectDir, @Nullable CMakeModel existingModel, @NotNull Charset charset, @NotNull List<CMakeGenerator.Parameters> parameters) {
        if (projectDir == null) {
            CMakeModelFixture.$$$reportNull$$$0(36);
        }
        if (charset == null) {
            CMakeModelFixture.$$$reportNull$$$0(37);
        }
        if (parameters == null) {
            CMakeModelFixture.$$$reportNull$$$0(38);
        }
        MessagesCollector messagesCollector = new MessagesCollector();
        CMakeGenerator generator = new CMakeGenerator(ProjectManager.getInstance().getDefaultProject(), CMakeModelFixture.toNonCanonicalPath(projectDir), ContainerUtil.map(parameters, p -> {
            TestCMakeListener listener = (TestCMakeListener)p.listener;
            listener.collector = messagesCollector;
            listener.environment = p.environment;
            listener.projectDir = projectDir;
            p = CMakeProjectFixture.prepareCMakeProjectCache(p);
            return CMakeModelFixture.toNonCanonicalPaths(p);
        }), charset.name(), charset);
        CMakeModel model = generator.generate(existingModel, (ProgressIndicator)new EmptyProgressIndicator());
        return new GenerateInfo(projectDir, model, messagesCollector.getMessages(), parameters);
    }

    @NotNull
    private static CMakeGenerator.Parameters toNonCanonicalPaths(@NotNull CMakeGenerator.Parameters parameters) {
        if (parameters == null) {
            CMakeModelFixture.$$$reportNull$$$0(39);
        }
        return new CMakeGenerator.Parameters(parameters.profileId, parameters.profileName, parameters.buildType, CMakeModelFixture.toNonCanonicalPath(parameters.generationDir), parameters.additionalOptions, parameters.passSystemEnvironment, parameters.additionalEnvironment, parameters.listener, parameters.environment);
    }

    private static File toNonCanonicalPath(File projectDir) {
        return new File(projectDir.getPath() + "/../" + projectDir.getName());
    }

    public List<String> getTargetNames(GenerateInfo info) {
        return ContainerUtil.map((Collection)info.model.getTargets(), target -> target.getName());
    }

    public void assertTargets(GenerateInfo info, String ... expectedTargets) {
        UsefulTestCase.assertSameElements(this.getTargetNames(info), expectedTargets);
    }

    @Nullable
    public CMakeTarget findTarget(GenerateInfo info, @NotNull String targetName) {
        if (targetName == null) {
            CMakeModelFixture.$$$reportNull$$$0(40);
        }
        for (CMakeTarget eachTarget : info.model.getTargets()) {
            if (!eachTarget.getName().equals(targetName)) continue;
            return eachTarget;
        }
        return null;
    }

    @Nullable
    public CMakeConfiguration findConfig(GenerateInfo info, @NotNull String targetName, @NotNull String configName) {
        if (targetName == null) {
            CMakeModelFixture.$$$reportNull$$$0(41);
        }
        if (configName == null) {
            CMakeModelFixture.$$$reportNull$$$0(42);
        }
        CMakeTarget target = this.findTarget(info, targetName);
        TestCase.assertNotNull((String)("target not found " + targetName), (Object)target);
        for (CMakeConfiguration eachConfig : target.getBuildConfigurations()) {
            if (!eachConfig.getName().equals(configName)) continue;
            return eachConfig;
        }
        return null;
    }

    public void assertTargetConfigs(GenerateInfo info, String targetName, String ... expectedConfigs) {
        this.assertTargetConfigs(info, targetName, Arrays.asList(expectedConfigs));
    }

    public void assertTargetConfigs(GenerateInfo info, String targetName, List<String> expectedConfigs) {
        for (CMakeTarget eachTarget : info.model.getTargets()) {
            if (!eachTarget.getName().equals(targetName)) continue;
            UsefulTestCase.assertOrderedEquals(ContainerUtil.map((Collection)eachTarget.getBuildConfigurations(), each -> each.getName()), expectedConfigs);
            return;
        }
        Assert.fail((String)("target not found " + targetName));
    }

    public void assertSources(GenerateInfo info, @Nullable String targetOrNullForAll, @Nullable String configNameOrNullForAll, String ... relativePaths) {
        List expectedFiles = ContainerUtil.map((Object[])relativePaths, s -> this.subFile(info, (String)s));
        UsefulTestCase.assertSameElements(this.getSources(info, targetOrNullForAll, configNameOrNullForAll), expectedFiles);
    }

    public Set<File> getSources(GenerateInfo info, @Nullable String targetOrNullForAll, @Nullable String configNameOrNullForAll) {
        boolean targetFound = targetOrNullForAll == null;
        boolean configFound = configNameOrNullForAll == null;
        HashSet<File> actualFiles = new HashSet<File>();
        for (CMakeTarget eachTarget : info.model.getTargets()) {
            if (targetOrNullForAll != null && !eachTarget.getName().equals(targetOrNullForAll)) continue;
            targetFound = true;
            for (CMakeConfiguration eachConfig : eachTarget.getBuildConfigurations()) {
                configFound = true;
                if (configNameOrNullForAll != null && !eachConfig.getName().equals(configNameOrNullForAll)) continue;
                actualFiles.addAll(eachConfig.getSources());
            }
        }
        Assert.assertTrue((String)("target not found " + targetOrNullForAll), (boolean)targetFound);
        Assert.assertTrue((String)("config not found " + configNameOrNullForAll), (boolean)configFound);
        return actualFiles;
    }

    public void assertFileLanguage(GenerateInfo info, @NotNull String relativeFile, @NotNull String targetName, @NotNull String configName, @Nullable OCLanguageKind expectedLanguage) {
        if (relativeFile == null) {
            CMakeModelFixture.$$$reportNull$$$0(43);
        }
        if (targetName == null) {
            CMakeModelFixture.$$$reportNull$$$0(44);
        }
        if (configName == null) {
            CMakeModelFixture.$$$reportNull$$$0(45);
        }
        CMakeConfiguration config = this.findConfig(info, targetName, configName);
        String targetConfig = targetName + "-" + configName;
        TestCase.assertNotNull((String)("config not found " + targetConfig), (Object)config);
        CMakeFileSettings fileSettings = config.getFileSettings(this.subFile(info, relativeFile));
        TestCase.assertNotNull((String)("file settings not found for " + relativeFile + " in " + targetConfig), (Object)fileSettings);
        TestCase.assertEquals((Object)expectedLanguage, (Object)fileSettings.getLanguageKind());
    }

    @Nullable
    public File getProductFile(GenerateInfo info, String targetName, String configName) {
        CMakeConfiguration config = this.findConfig(info, targetName, configName);
        TestCase.assertNotNull((String)("Config " + targetName + "-" + configName + " not found"), (Object)config);
        return config.getProductFile();
    }

    @NotNull
    public File subFile(GenerateInfo info, String relativePath) {
        return new File(FileUtil.toCanonicalPath((String)new File(info.projectDir, relativePath).getPath()));
    }

    public Collection<String> configurationsForFile(GenerateInfo info, @NotNull String relativePath) {
        if (relativePath == null) {
            CMakeModelFixture.$$$reportNull$$$0(46);
        }
        return this.configurationsForFile(info, this.subFile(info, relativePath));
    }

    public Collection<String> configurationsForFile(GenerateInfo info, @NotNull File file2) {
        if (file2 == null) {
            CMakeModelFixture.$$$reportNull$$$0(47);
        }
        HashSet<String> result = new HashSet<String>();
        for (CMakeTarget eachTarget : info.model.getTargets()) {
            for (CMakeConfiguration eachConfig : eachTarget.getBuildConfigurations()) {
                if (!eachConfig.getSources().contains(file2)) continue;
                result.add(eachConfig.getName());
            }
        }
        return result;
    }

    public void assertNoConfigurationErrors(GenerateInfo info) {
        for (List each : info.messages.getAll().values()) {
            UsefulTestCase.assertEmpty(each);
        }
    }

    public void assertMessageMatches(CMakeMessage actualMessage, CMakeMessage.MessageLevel error, File file2, Integer line, String textRegexp) {
        String str = actualMessage.toString();
        TestCase.assertEquals((String)str, (Object)error, (Object)actualMessage.getLevel());
        TestCase.assertEquals((String)str, (Object)file2, (Object)actualMessage.getFile());
        TestCase.assertEquals((String)str, (Object)line, (Object)actualMessage.getLine());
        CidrTestCase.assertMatches(actualMessage.getText(), textRegexp, 40);
    }

    public CMakeVariable findVariable(Collection<CMakeVariable> variables, String variableName) {
        for (CMakeVariable each : variables) {
            if (!each.getName().equals(variableName)) continue;
            return each;
        }
        return null;
    }

    public static void assertFlags(List<String> actualFlags, List<String> expectedFlags) {
        CMakeModelFixture.assertFlags(actualFlags, expectedFlags, true);
    }

    public static void assertFlags(List<String> actualFlags, List<String> expectedFlags, boolean assertOrder) {
        ArrayList<String> effectiveFlags = new ArrayList<String>(actualFlags);
        int iSysrootIdx = effectiveFlags.indexOf("-isysroot");
        if (iSysrootIdx >= 0) {
            effectiveFlags.remove(iSysrootIdx);
            effectiveFlags.remove(iSysrootIdx);
        }
        effectiveFlags.removeIf(string -> string.contains("-mmacosx-version-min"));
        if (assertOrder) {
            UsefulTestCase.assertOrderedEquals(effectiveFlags, expectedFlags);
        } else {
            UsefulTestCase.assertSameElements(effectiveFlags, expectedFlags);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 22: 
            case 29: 
            case 32: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 22: 
            case 29: 
            case 32: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeTestProject";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 22: 
            case 29: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeModelFixture";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyInto";
                break;
            }
            case 9: 
            case 14: 
            case 20: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedDir";
                break;
            }
            case 11: 
            case 13: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileAndBuildType";
                break;
            }
            case 15: 
            case 18: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalOptions";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalVariables";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 30: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDir";
                break;
            }
            case 31: 
            case 34: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 40: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetName";
                break;
            }
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configName";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeFile";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeModelFixture";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareTestData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentCMakeVersion";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "generateProjectFromScratch";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "debug";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "config";
                break;
            }
            case 16: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "debugWithAdditionalOptions";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "withAdditionalOptions";
                break;
            }
            case 29: 
            case 32: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "generateProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepareTestData";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 22: 
            case 29: 
            case 32: 
            case 35: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateProjectFromScratch";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "debug";
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "config";
                break;
            }
            case 15: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "debugWithAdditionalOptions";
                break;
            }
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "withAdditionalOptions";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "debugWithEnvironment";
                break;
            }
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "generateProject";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "toNonCanonicalPaths";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findTarget";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findConfig";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "assertFileLanguage";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "configurationsForFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 22: 
            case 29: 
            case 32: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MessagesCollector {
        private final LinkedHashMap<String, List<CMakeMessage>> myGroupedMessages = new LinkedHashMap();

        private MessagesCollector() {
        }

        public synchronized void add(@NotNull String group, @NotNull CMakeMessage message) {
            if (group == null) {
                MessagesCollector.$$$reportNull$$$0(0);
            }
            if (message == null) {
                MessagesCollector.$$$reportNull$$$0(1);
            }
            this.addAll(group, Collections.singletonList(message));
        }

        public synchronized void addAll(@NotNull String group, @NotNull List<CMakeMessage> messages) {
            List<CMakeMessage> list;
            if (group == null) {
                MessagesCollector.$$$reportNull$$$0(2);
            }
            if (messages == null) {
                MessagesCollector.$$$reportNull$$$0(3);
            }
            if ((list = this.myGroupedMessages.get(group)) == null) {
                list = new ArrayList<CMakeMessage>();
                this.myGroupedMessages.put(group, list);
            }
            list.addAll(messages);
        }

        public synchronized CMakeData<List<CMakeMessage>> getMessages() {
            return new CMakeData(this.myGroupedMessages);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "messages";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeModelFixture$MessagesCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addAll";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class GenerateInfo {
        public File projectDir;
        public CMakeModel model;
        public CMakeData<List<CMakeMessage>> messages;
        public final List<CMakeGenerator.Parameters> parameters;

        public GenerateInfo(File projectDir, CMakeModel model, CMakeData<List<CMakeMessage>> messages, List<CMakeGenerator.Parameters> parameters) {
            this.projectDir = projectDir;
            this.model = model;
            this.messages = messages;
            this.parameters = parameters;
        }

        @NotNull
        public List<String> getConfigNames() {
            List list = ContainerUtil.map((Collection)this.model.getConfigurationData(), it -> it.getConfigName());
            if (list == null) {
                GenerateInfo.$$$reportNull$$$0(0);
            }
            return list;
        }

        @NotNull
        public File getGenerationDir(String configType) {
            File file2 = this.getConfigurationData(configType).getGenerationDir();
            if (file2 == null) {
                GenerateInfo.$$$reportNull$$$0(1);
            }
            return file2;
        }

        @NotNull
        public CMakeModelConfigurationData getConfigurationData(String configName) {
            CMakeModelConfigurationData cMakeModelConfigurationData = this.model.getConfigurationData().stream().filter(it -> it.getConfigName().equals(configName)).findFirst().get();
            if (cMakeModelConfigurationData == null) {
                GenerateInfo.$$$reportNull$$$0(2);
            }
            return cMakeModelConfigurationData;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeModelFixture$GenerateInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigNames";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGenerationDir";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigurationData";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    static class TestCMakeListener
    implements CMakeListener {
        String configName;
        MessagesCollector collector;
        CPPEnvironment environment;
        File projectDir;

        TestCMakeListener(String configName) {
            this.configName = configName;
        }

        public void message(@NotNull CMakeMessage message) {
            if (message == null) {
                TestCMakeListener.$$$reportNull$$$0(0);
            }
            this.collector.add(this.configName, message);
        }

        public void attachTo(@NotNull ProcessHandler handler) {
            if (handler == null) {
                TestCMakeListener.$$$reportNull$$$0(1);
            }
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){
                final StringBuilder output = new StringBuilder();

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    this.output.append(event.getText());
                    CPPLog.LOG.debug(StringUtil.trimTrailing((String)event.getText()));
                }

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    CMakeOutputFilter filter = new CMakeOutputFilter(null, (CidrToolEnvironment)environment, projectDir.toPath());
                    int length = 0;
                    for (String each : StringUtil.splitByLinesKeepSeparators((String)this.output.toString())) {
                        filter.applyFilter(each, length += each.length());
                    }
                    collector.addAll(configName, filter.finishAndGetMessages());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeModelFixture$TestCMakeListener$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTextAvailable";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeModelFixture$TestCMakeListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "message";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "attachTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

