/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.impl.VirtualFilePointerImpl;
import com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@TestOnly
public final class VirtualFilePointerTracker {
    private static final Set<VirtualFilePointer> storedPointers = new ReferenceOpenHashSet();
    private static Throwable trace;
    private static boolean isTracking;

    public VirtualFilePointerTracker() {
        this.storePointers();
    }

    private synchronized void storePointers() {
        if (isTracking) {
            isTracking = false;
            throw new IllegalStateException("Previous test did not call assertPointersAreDisposed() - see 'Caused by:' for its stacktrace", trace);
        }
        trace = new Throwable();
        storedPointers.clear();
        storedPointers.addAll(VirtualFilePointerTracker.dumpAllPointers());
        isTracking = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void assertPointersAreDisposed() {
        if (!isTracking) {
            throw new IllegalStateException("Double call of assertPointersAreDisposed() - see 'Caused by:' for the previous call", trace);
        }
        ArrayList<VirtualFilePointer> pointers = new ArrayList<VirtualFilePointer>(VirtualFilePointerTracker.dumpAllPointers());
        for (int i = pointers.size() - 1; i >= 0; --i) {
            VirtualFilePointer pointer = (VirtualFilePointer)pointers.get(i);
            if (!storedPointers.remove(pointer)) continue;
            pointers.remove(i);
        }
        try {
            ObjectOpenCustomHashSet leaked = new ObjectOpenCustomHashSet(pointers, (Hash.Strategy)new Hash.Strategy<VirtualFilePointer>(){

                public int hashCode(@Nullable VirtualFilePointer pointer) {
                    if (pointer == null) {
                        return 0;
                    }
                    String url = pointer.getUrl();
                    return SystemInfoRt.isFileSystemCaseSensitive ? url.hashCode() : Strings.stringHashCodeInsensitive((CharSequence)url);
                }

                public boolean equals(VirtualFilePointer o1, VirtualFilePointer o2) {
                    return o1 == o2 || o1 != null && o2 != null && (SystemInfoRt.isFileSystemCaseSensitive ? o1.getUrl().equals(o2.getUrl()) : o1.getUrl().equalsIgnoreCase(o2.getUrl()));
                }
            });
            leaked.removeAll(storedPointers);
            for (VirtualFilePointer pointer : leaked) {
                ((VirtualFilePointerImpl)pointer).throwDisposalError("Virtual pointer '" + pointer + "' hasn't been disposed: " + ((VirtualFilePointerImpl)pointer).getStackTrace());
            }
        }
        finally {
            storedPointers.clear();
            trace = new Throwable();
            isTracking = false;
        }
    }

    @NotNull
    private static Collection<VirtualFilePointer> dumpAllPointers() {
        Collection collection = ((VirtualFilePointerManagerImpl)VirtualFilePointerManager.getInstance()).dumpAllPointers();
        if (collection == null) {
            VirtualFilePointerTracker.$$$reportNull$$$0(0);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerTracker", "dumpAllPointers"));
    }
}

