/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.services;

import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.layout.NodeLayout;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class GraphCanvasLocationService {
    @NotNull
    private static final GraphCanvasLocationService INSTANCE = new GraphCanvasLocationService();

    @NotNull
    public static GraphCanvasLocationService getInstance() {
        GraphCanvasLocationService graphCanvasLocationService = INSTANCE;
        if (graphCanvasLocationService == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(0);
        }
        return graphCanvasLocationService;
    }

    @NotNull
    public Point getNodeCoordinatesOnScreen(@NotNull Node node, @NotNull GraphBuilder<?, ?> builder) {
        if (node == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(2);
        }
        Graph2D graph2D = builder.getGraph();
        Graph2DView view = builder.getView();
        Point viewPoint = view.getViewPoint();
        NodeRealizer nodeRealizer = graph2D.getRealizer(node);
        double x = nodeRealizer.getX();
        double y = nodeRealizer.getY();
        JComponent owner = view.getCanvasComponent();
        double oX = owner.getLocationOnScreen().getX();
        double oY = owner.getLocationOnScreen().getY();
        double pX = Math.max((x - (double)viewPoint.x) * view.getZoom() + oX, oX);
        double pY = (y - (double)viewPoint.y) * view.getZoom() + oY;
        return new Point((int)pX, (int)pY);
    }

    @NotNull
    public Point getGraphCenterOnScreen(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(3);
        }
        Graph2DView view = builder.getView();
        Dimension size = view.getViewSize();
        Point top = view.getCanvasComponent().getLocationOnScreen();
        return new Point(top.x + size.width / 2, top.y + size.height / 2);
    }

    @NotNull
    public Point getBestPositionForNode(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(4);
        }
        double yy = -1.7976931348623157E308;
        double xx = -1.7976931348623157E308;
        double rightest = -1.7976931348623157E308;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        double leftest = Double.MAX_VALUE;
        for (Node node : builder.getGraph().getNodeArray()) {
            NodeLayout nodeLayout = builder.getGraph().getNodeLayout(node);
            if (nodeLayout == null) continue;
            double w = nodeLayout.getWidth();
            double nx = nodeLayout.getX();
            double x = nx + w;
            double h = nodeLayout.getHeight();
            double ny = nodeLayout.getY();
            double y = ny + h;
            if (x > rightest) {
                rightest = x;
            }
            if (x < leftest) {
                leftest = x - w;
            }
            if (!(y >= maxY)) continue;
            xx = y == maxY ? Math.max(xx, nx) : nx;
            yy = Math.max(yy, ny);
            maxX = y == maxY ? Math.max(x, maxX) : x;
            maxY = y;
        }
        if (maxY == -1.7976931348623157E308 || maxX == -1.7976931348623157E308) {
            return new Point(200, 200);
        }
        Point p = new Point();
        if (rightest - maxX < 100.0) {
            p.setLocation(leftest, maxY + 20.0);
        } else {
            p.setLocation(maxX + 20.0, yy);
        }
        Point point = p;
        if (point == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(5);
        }
        return point;
    }

    public void showPopupBeneathNode(@NotNull JBPopup popup, @NotNull GraphBuilder<?, ?> builder, @NotNull Node node) {
        if (popup == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(6);
        }
        if (builder == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(7);
        }
        if (node == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(8);
        }
        Graph2DView view = builder.getView();
        Point nodePos = this.getNodeCoordinatesOnScreen(node, builder);
        popup.showInScreenCoordinates((Component)view.getCanvasComponent(), new Point(nodePos.x, nodePos.y + (int)(24.0 * view.getZoom())));
    }

    public void showPopupInTopCenterOfViewport(@NotNull JBPopup popup, @NotNull GraphBuilder<?, ?> builder) {
        if (popup == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(9);
        }
        if (builder == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(10);
        }
        JComponent canvas = builder.getView().getCanvasComponent();
        JComponent viewport = (JComponent)canvas.getParent();
        Rectangle viewportBounds = viewport.getBounds();
        Point viewportScreenPoint = viewportBounds.getLocation();
        SwingUtilities.convertPointToScreen(viewportScreenPoint, viewport);
        Dimension popupSize = popup.getSize();
        int popupWidth = popupSize != null ? popupSize.width : JBUI.scale((int)(Toolkit.getDefaultToolkit().getScreenSize().width / 3));
        popup.showInScreenCoordinates((Component)canvas, new Point(viewportScreenPoint.x + viewportBounds.width / 2 - popupWidth / 2, viewportScreenPoint.y + 10));
    }

    public void showInGraphCenter(@NotNull JBPopup popup, @NotNull GraphBuilder<?, ?> builder) {
        if (popup == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(11);
        }
        if (builder == null) {
            GraphCanvasLocationService.$$$reportNull$$$0(12);
        }
        Point graphCenter = this.getGraphCenterOnScreen(builder);
        popup.showInScreenCoordinates((Component)builder.getView().getCanvasComponent(), new Point(graphCenter.x - 100, graphCenter.y - 100));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/services/GraphCanvasLocationService";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/services/GraphCanvasLocationService";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBestPositionForNode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNodeCoordinatesOnScreen";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getGraphCenterOnScreen";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBestPositionForNode";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showPopupBeneathNode";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showPopupInTopCenterOfViewport";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "showInGraphCenter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

