/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.printing;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.GraphDataKeys;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphBundle;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.builder.actions.printing.DarculaAwareGraph2DPrinter;
import com.intellij.openapi.graph.builder.actions.printing.PrintOptionsDialog;
import com.intellij.openapi.graph.builder.actions.printing.PrintUtil;
import com.intellij.openapi.graph.option.OptionHandler;
import com.intellij.openapi.graph.services.GraphExportService;
import com.intellij.openapi.graph.view.BackgroundRenderer;
import com.intellij.openapi.graph.view.DefaultBackgroundRenderer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion="2021.3")
public class PrintGraphAction
extends AbstractGraphAction {
    private static final Logger LOG = Logger.getInstance(PrintGraphAction.class);
    private PageFormat myPageFormat;

    public PrintGraphAction() {
        this.getTemplatePresentation().setText(GraphBundle.message("action.text.print.graph", new Object[0]));
        this.getTemplatePresentation().setIcon(AllIcons.General.Print);
    }

    @Override
    public void update(@NotNull AnActionEvent e, @NotNull Graph2D graph) {
        if (e == null) {
            PrintGraphAction.$$$reportNull$$$0(0);
        }
        if (graph == null) {
            PrintGraphAction.$$$reportNull$$$0(1);
        }
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Graph2D graph2D) {
        PageFormat pf;
        if (e == null) {
            PrintGraphAction.$$$reportNull$$$0(2);
        }
        if (graph2D == null) {
            PrintGraphAction.$$$reportNull$$$0(3);
        }
        Graph2DView view = PrintGraphAction.getGraph2DView(graph2D);
        BackgroundRenderer renderer = view.getBackgroundRenderer();
        GraphBuilder builder = (GraphBuilder)((Object)e.getData(GraphDataKeys.GRAPH_BUILDER));
        DarculaAwareGraph2DPrinter printer = new DarculaAwareGraph2DPrinter(view);
        OptionHandler handler = PrintUtil.createPrintOptions();
        Project project = e.getProject();
        PrintOptionsDialog dialog = new PrintOptionsDialog(project, handler);
        if (!dialog.showAndGet()) {
            return;
        }
        PrintUtil.initGraph2DPrinter(printer, handler);
        PrinterJob printJob = PrinterJob.getPrinterJob();
        if (this.myPageFormat == null) {
            this.myPageFormat = printJob.defaultPage();
        }
        if ((pf = printJob.pageDialog(this.myPageFormat)) == this.myPageFormat) {
            return;
        }
        this.myPageFormat = pf;
        printJob.setPrintable(printer, this.myPageFormat);
        PrintGraphAction.doPrint(graph2D, renderer, builder, printJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doPrint(@NotNull Graph2D graph2D, BackgroundRenderer renderer, GraphBuilder builder, PrinterJob printJob) {
        if (graph2D == null) {
            PrintGraphAction.$$$reportNull$$$0(4);
        }
        if (printJob.printDialog()) {
            try {
                PrintGraphAction.setupBackgroundBeforePrint(graph2D, renderer, builder);
                printJob.print();
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
            finally {
                PrintGraphAction.rollbackBackgroundAfterPrint(renderer, builder);
            }
        }
    }

    public static void setupBackgroundBeforePrint(@NotNull Graph2D graph2D, @Nullable BackgroundRenderer renderer, @Nullable GraphBuilder builder) {
        if (graph2D == null) {
            PrintGraphAction.$$$reportNull$$$0(5);
        }
        if (!StartupUiUtil.isUnderDarcula()) {
            return;
        }
        if (renderer instanceof DefaultBackgroundRenderer) {
            ((DefaultBackgroundRenderer)renderer).setColor(Color.white);
        }
        JBColor.setDark((boolean)false);
        GraphExportService.getInstance().setPrintMode(true);
        graph2D.getCurrentView().updateView();
        if (builder != null) {
            builder.updateGraph();
            builder.getGraph().updateViews();
        }
    }

    public static void rollbackBackgroundAfterPrint(@Nullable BackgroundRenderer renderer, @Nullable GraphBuilder builder) {
        if (!StartupUiUtil.isUnderDarcula()) {
            return;
        }
        GraphExportService.getInstance().setPrintMode(false);
        JBColor.setDark((boolean)StartupUiUtil.isUnderDarcula());
        if (renderer instanceof DefaultBackgroundRenderer) {
            ((DefaultBackgroundRenderer)renderer).setColor(JBColor.background());
        }
        if (builder != null) {
            builder.updateGraph();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph2D";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/graph/builder/actions/printing/PrintGraphAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doPrint";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setupBackgroundBeforePrint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

