/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.servlet.ResponseUtils;
import org.slf4j.Logger;

public abstract class BaseSolrResource {
    protected static final String SHOW_DEFAULTS = "showDefaults";
    public static final String UPDATE_TIMEOUT_SECS = "updateTimeoutSecs";
    private SolrCore solrCore;
    private IndexSchema schema;
    private SolrQueryRequest solrRequest;
    private SolrQueryResponse solrResponse;
    private QueryResponseWriter responseWriter;
    private String contentType;
    private int updateTimeoutSecs = -1;
    private int statusCode = -1;

    public SolrCore getSolrCore() {
        return this.solrCore;
    }

    public IndexSchema getSchema() {
        return this.schema;
    }

    public SolrQueryRequest getSolrRequest() {
        return this.solrRequest;
    }

    public SolrQueryResponse getSolrResponse() {
        return this.solrResponse;
    }

    public String getContentType() {
        return this.contentType;
    }

    protected int getUpdateTimeoutSecs() {
        return this.updateTimeoutSecs;
    }

    protected BaseSolrResource() {
    }

    public void doInit(SolrQueryRequest solrRequest, SolrQueryResponse solrResponse) {
        try {
            String updateTimeoutSecsParam;
            this.solrRequest = solrRequest;
            this.solrResponse = solrResponse;
            this.solrCore = solrRequest.getCore();
            this.schema = solrRequest.getSchema();
            String responseWriterName = solrRequest.getParams().get("wt", "json");
            this.responseWriter = this.solrCore.getQueryResponseWriter(responseWriterName);
            this.contentType = this.responseWriter.getContentType(solrRequest, solrResponse);
            String path = solrRequest.getPath();
            if (!"/schema".equals(path)) {
                int cutoffPoint = path.indexOf("/", 1);
                String firstPathElement = -1 == cutoffPoint ? path : path.substring(0, cutoffPoint);
                solrRequest.getContext().put("webapp", firstPathElement);
            }
            if ((updateTimeoutSecsParam = solrRequest.getParams().get(UPDATE_TIMEOUT_SECS)) != null) {
                this.updateTimeoutSecs = Integer.parseInt(updateTimeoutSecsParam);
            }
        }
        catch (Throwable t) {
            if (t instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)t;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, t);
        }
    }

    protected void handlePostExecution(Logger log) {
        this.handleException(log);
        this.addDeprecatedWarning();
        if (log.isInfoEnabled() && this.solrResponse.getToLog().size() > 0) {
            log.info(this.solrResponse.getToLogAsString(this.solrCore.getLogId()));
        }
    }

    protected void addDeprecatedWarning() {
        this.solrResponse.add("warn", "This API is deprecated");
    }

    protected void handleException(Logger log) {
        Exception exception = this.getSolrResponse().getException();
        if (null != exception) {
            SimpleOrderedMap info = new SimpleOrderedMap();
            this.statusCode = ResponseUtils.getErrorInfo(exception, (NamedList)info, log);
            this.getSolrResponse().add("error", info);
            String message = (String)info.get("msg");
            if (null != message && !message.trim().isEmpty()) {
                this.getSolrResponse().getToLog().add("msg", (Object)("{" + message.trim() + "}"));
            }
        }
    }

    protected static String urlDecode(String str) throws UnsupportedEncodingException {
        return URLDecoder.decode(str.replace("+", "%2B"), "UTF-8");
    }
}

