/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Clock {
    private static final Logger logger = LoggerFactory.getLogger(Clock.class);
    public static Clock instance;

    public long nanoTime() {
        return System.nanoTime();
    }

    public long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    static {
        String sclock = System.getProperty("cassandra.clock");
        if (sclock == null) {
            instance = new Clock();
        } else {
            try {
                logger.debug("Using custom clock implementation: {}", (Object)sclock);
                instance = (Clock)Class.forName(sclock).newInstance();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

