/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.stress.generate.Distribution;
import org.apache.cassandra.stress.generate.DistributionFactory;
import org.apache.cassandra.stress.generate.DistributionFixed;
import org.apache.cassandra.stress.settings.GroupedOptions;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionDistribution;
import org.apache.cassandra.stress.settings.OptionSimple;
import org.apache.cassandra.stress.util.ResultLogger;
import org.apache.cassandra.utils.ByteBufferUtil;

public class SettingsColumn
implements Serializable {
    public final int maxColumnsPerKey;
    public transient List<ByteBuffer> names;
    public final List<String> namestrs;
    public final String comparator;
    public final String timestamp;
    public final boolean variableColumnCount;
    public final boolean slice;
    public final DistributionFactory sizeDistribution;
    public final DistributionFactory countDistribution;

    public SettingsColumn(GroupedOptions options) {
        this((Options)options, options instanceof NameOptions ? (NameOptions)options : null, options instanceof CountOptions ? (CountOptions)options : null);
    }

    public SettingsColumn(Options options, NameOptions name, CountOptions count) {
        this.sizeDistribution = options.size.get();
        this.timestamp = options.timestamp.value();
        this.comparator = options.comparator.value();
        AbstractType parsed = null;
        try {
            parsed = TypeParser.parse((String)this.comparator);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        if (!(parsed instanceof TimeUUIDType || parsed instanceof AsciiType || parsed instanceof UTF8Type)) {
            System.err.println("Currently supported types are: TimeUUIDType, AsciiType, UTF8Type.");
            System.exit(1);
        }
        if (name != null) {
            AbstractType comparator;
            assert (count == null);
            try {
                comparator = TypeParser.parse((String)this.comparator);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(this.comparator + " is not a valid type");
            }
            String[] names = name.name.value().split(",");
            this.names = new ArrayList<ByteBuffer>(names.length);
            for (String columnName : names) {
                this.names.add(comparator.fromString(columnName));
            }
            Collections.sort(this.names, BytesType.instance);
            this.namestrs = new ArrayList<String>();
            for (ByteBuffer columnName : this.names) {
                this.namestrs.add(comparator.getString(columnName));
            }
            final int nameCount = this.names.size();
            this.countDistribution = new DistributionFactory(){

                @Override
                public Distribution get() {
                    return new DistributionFixed(nameCount);
                }

                @Override
                public String getConfigAsString() {
                    return String.format("Count:  fixed=%d", nameCount);
                }
            };
        } else {
            int i;
            this.countDistribution = count.count.get();
            ByteBuffer[] names = new ByteBuffer[(int)this.countDistribution.get().maxValue()];
            String[] namestrs = new String[(int)this.countDistribution.get().maxValue()];
            for (i = 0; i < names.length; ++i) {
                names[i] = ByteBufferUtil.bytes((String)("C" + i));
            }
            Arrays.sort(names, BytesType.instance);
            try {
                for (i = 0; i < names.length; ++i) {
                    namestrs[i] = ByteBufferUtil.string((ByteBuffer)names[i]);
                }
            }
            catch (CharacterCodingException e) {
                throw new RuntimeException(e);
            }
            this.names = Arrays.asList(names);
            this.namestrs = Arrays.asList(namestrs);
        }
        this.maxColumnsPerKey = (int)this.countDistribution.get().maxValue();
        this.variableColumnCount = this.countDistribution.get().minValue() < (long)this.maxColumnsPerKey;
        this.slice = options.slice.setByUser();
    }

    public void printSettings(ResultLogger out) {
        out.printf("  Max Columns Per Key: %d%n", this.maxColumnsPerKey);
        out.printf("  Column Names: %s%n", this.namestrs);
        out.printf("  Comparator: %s%n", this.comparator);
        out.printf("  Timestamp: %s%n", this.timestamp);
        out.printf("  Variable Column Count: %b%n", this.variableColumnCount);
        out.printf("  Slice: %b%n", this.slice);
        if (this.sizeDistribution != null) {
            out.println("  Size Distribution: " + this.sizeDistribution.getConfigAsString());
        }
        if (this.sizeDistribution != null) {
            out.println("  Count Distribution: " + this.countDistribution.getConfigAsString());
        }
    }

    static SettingsColumn get(Map<String, String[]> clArgs) {
        String[] params = clArgs.remove("-col");
        if (params == null) {
            return new SettingsColumn(new CountOptions());
        }
        GroupedOptions options = GroupedOptions.select((String[])params, (GroupedOptions[])new Options[]{new NameOptions(), new CountOptions()});
        if (options == null) {
            SettingsColumn.printHelp();
            System.out.println("Invalid -col options provided, see output for valid options");
            System.exit(1);
        }
        return new SettingsColumn(options);
    }

    static void printHelp() {
        GroupedOptions.printOptions(System.out, "-col", new NameOptions(), new CountOptions());
    }

    static Runnable helpPrinter() {
        return new Runnable(){

            @Override
            public void run() {
                SettingsColumn.printHelp();
            }
        };
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        ArrayList<byte[]> namesBytes = new ArrayList<byte[]>();
        for (ByteBuffer buffer : this.names) {
            namesBytes.add(ByteBufferUtil.getArray((ByteBuffer)buffer));
        }
        oos.writeObject(namesBytes);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        ArrayList<ByteBuffer> namesBuffer = new ArrayList<ByteBuffer>();
        List namesBytes = (List)ois.readObject();
        for (byte[] bytes : namesBytes) {
            namesBuffer.add(ByteBuffer.wrap(bytes));
        }
        this.names = new ArrayList<ByteBuffer>(namesBuffer);
    }

    private static final class CountOptions
    extends Options {
        final OptionDistribution count = new OptionDistribution("n=", "FIXED(5)", "Cell count distribution, per operation");

        private CountOptions() {
        }

        @Override
        public List<? extends Option> options() {
            return Arrays.asList(this.count, this.slice, this.superColumns, this.comparator, this.timestamp, this.size);
        }
    }

    private static final class NameOptions
    extends Options {
        final OptionSimple name = new OptionSimple("names=", ".*", null, "Column names", true);

        private NameOptions() {
        }

        @Override
        public List<? extends Option> options() {
            return Arrays.asList(this.name, this.slice, this.superColumns, this.comparator, this.timestamp, this.size);
        }
    }

    private static abstract class Options
    extends GroupedOptions {
        final OptionSimple superColumns = new OptionSimple("super=", "[0-9]+", "0", "Number of super columns to use (no super columns used if not specified)", false);
        final OptionSimple comparator = new OptionSimple("comparator=", "TimeUUIDType|AsciiType|UTF8Type", "AsciiType", "Column Comparator to use", false);
        final OptionSimple slice = new OptionSimple("slice", "", null, "If set, range slices will be used for reads, otherwise a names query will be", false);
        final OptionSimple timestamp = new OptionSimple("timestamp=", "[0-9]+", null, "If set, all columns will be written with the given timestamp", false);
        final OptionDistribution size = new OptionDistribution("size=", "FIXED(34)", "Cell size distribution");

        private Options() {
        }
    }
}

