/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml;

public class Entity {
    private Type entityType;
    private boolean parameter;
    private String name;
    private String originalName;
    private String value;
    private String publicId;
    private String systemId;

    public Type getType() {
        return this.entityType;
    }

    public boolean isParameter() {
        return this.parameter;
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getValue() {
        return this.value;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    private void setName(String name) {
        this.originalName = name;
        if (name.codePointAt(0) == 37) {
            this.parameter = true;
            this.name = name.substring(name.offsetByCodePoints(0, 1));
        } else {
            this.parameter = false;
            this.name = name;
        }
    }

    public Entity(String name, String value) {
        this.entityType = Type.INTERNAL;
        this.setName(name);
        this.value = value;
    }

    public Entity(String name, String publicId, String systemId) {
        this.entityType = Type.EXTERNAL;
        this.setName(name);
        this.publicId = publicId;
        this.systemId = systemId;
    }

    public Entity(String name) {
        this.entityType = Type.REFERENCE;
        this.setName(name);
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        if (this.entityType == Type.REFERENCE) {
            if (this.parameter) {
                res.append('%').append(this.name).append(';');
            } else {
                res.append('&').append(this.name).append(';');
            }
        } else {
            res.append("<!ENTITY");
            if (this.parameter) {
                res.append(" %");
            }
            res.append(' ');
            res.append(this.name);
            if (this.entityType == Type.INTERNAL) {
                res.append(" \"").append(this.value).append('\"');
            } else if (this.entityType == Type.EXTERNAL) {
                if (this.publicId != null) {
                    res.append(" PUBLIC \"").append(this.publicId).append('\"');
                }
                res.append(" SYSTEM \"").append(this.systemId).append('\"');
            }
            res.append('>');
        }
        return res.toString();
    }

    static enum Type {
        INTERNAL,
        EXTERNAL,
        REFERENCE;

    }
}

