# Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
# file Copyright.txt or https://cmake.org/licensing for details.


# This module is shared by multiple languages; use include blocker.
if(__COMPILER_PGI)
  return()
endif()
set(__COMPILER_PGI 1)

include(Compiler/CMakeCommonCompilerMacros)

macro(__compiler_pgi lang)
  # Feature flags.
  set(CMAKE_${lang}_VERBOSE_FLAG "-v")

  # Initial configuration flags.
  string(APPEND CMAKE_${lang}_FLAGS_INIT " ")
  string(APPEND CMAKE_${lang}_FLAGS_DEBUG_INIT " -g ")
  string(APPEND CMAKE_${lang}_FLAGS_MINSIZEREL_INIT "  -s")
  string(APPEND CMAKE_${lang}_FLAGS_RELEASE_INIT " -fast ")
  # -Mipa was dropped with PGI 16.3 from Windows versions
  if(NOT CMAKE_HOST_WIN32 OR CMAKE_${lang}_COMPILER_VERSION VERSION_LESS 16.3)
    string(APPEND CMAKE_${lang}_FLAGS_RELEASE_INIT " -Mipa=fast")
  endif()
  string(APPEND CMAKE_${lang}_FLAGS_RELWITHDEBINFO_INIT "  -gopt")

  if(CMAKE_HOST_WIN32)
    string(APPEND CMAKE_${lang}_FLAGS_INIT " -Bdynamic")
  endif()

  # Preprocessing and assembly rules.
  set(CMAKE_${lang}_CREATE_PREPROCESSED_SOURCE "<CMAKE_${lang}_COMPILER> <DEFINES> <INCLUDES> <FLAGS> -E <SOURCE> > <PREPROCESSED_SOURCE>")
  set(CMAKE_${lang}_CREATE_ASSEMBLY_SOURCE "<CMAKE_${lang}_COMPILER> <DEFINES> <INCLUDES> <FLAGS> -S <SOURCE> -o <ASSEMBLY_SOURCE>")
endmacro()
