/*
 * Decompiled with CFR 0.152.
 */
package cycinf.cvars.usedtype;

import cycinf.cvars.usedtype.Identifier;
import cycinf.cvars.usedtype.UsedType;
import cycinf.util.ParseException;
import cycinf.util.ParsingUtils;
import general.util.Validator;
import java.text.MessageFormat;

public class LocalVariable
extends UsedType {
    private final UsedType function;
    private final Identifier localName;
    private final int index;
    private static final MessageFormat prettyFormat = new MessageFormat("{0} in {1}");

    public final UsedType getFunction() {
        return this.function;
    }

    public final Identifier getLocalName() {
        return this.localName;
    }

    public final int getIndex() {
        return this.index;
    }

    public LocalVariable(UsedType function, Identifier localName, int index) {
        this.function = (UsedType)Validator.nonnull((Object)function, (String)"function");
        this.localName = (Identifier)Validator.nonnull((Object)localName, (String)"localName");
        this.index = Validator.nonnegative((int)index, (String)"index");
    }

    public final String toString() {
        return String.valueOf(this.function.toString()) + "_" + this.localName.toString() + "_" + Integer.toString(this.index);
    }

    public final String prettyString() {
        return prettyFormat.format(new Object[]{this.getLocalName().getName(), this.getFunction().prettyString()});
    }

    public static final LocalVariable parse1(String x) throws ParseException {
        String x1 = ParsingUtils.chopNumberSuffix((String)x);
        if (x1 == null) {
            return null;
        }
        int index = ParsingUtils.nval;
        String x2 = ParsingUtils.chopSuffix((String)x1, (String)"_");
        if (x2 == null) {
            return null;
        }
        String x3 = ParsingUtils.chopIdentifierSuffix((String)x2);
        if (x3 == null) {
            return null;
        }
        String x4 = ParsingUtils.chopSuffix((String)x3, (String)"_");
        if (x4 == null) {
            return null;
        }
        Identifier localName = ParsingUtils.ival;
        UsedType function = UsedType.parse((String)x4);
        return new LocalVariable(function, localName, index);
    }
}

