use regex::Regex;

/* /// Convert article body into styled lines with URLs highlighted.
// not using this for now any more made link_ranges instead
pub fn highlight_links_in_body(body: &str) -> Vec<Line<'_>> {
    let mut lines = Vec::new();

    for line in body.lines() {
        if let Some(start) = line
            .find("http://")
            .or_else(|| line.find("https://"))
            .or_else(|| line.find("ftp://"))
            .or_else(|| line.find("gopher://"))
            .or_else(|| line.find("gemini://"))
        {
            let (prefix, url) = line.split_at(start);
            lines.push(Line::from(vec![
                Span::raw(prefix),
                Span::styled(
                    url,
                    Style::default()
                        .fg(Color::LightGreen)
                        .add_modifier(Modifier::UNDERLINED),
                ),
            ]));
        } else {
            lines.push(Line::raw(line));
        }
    }

    lines
}
*/

pub fn extract_links(text: &str) -> Vec<String> {
    let url_re = Regex::new(r#"(?i)\b(https?|ftp|gopher|gemini)://[^\s<>"']+"#).unwrap();

    url_re
        .find_iter(text)
        .map(|m| m.as_str().to_string())
        .collect()
}

pub fn link_ranges(body: &str) -> Vec<Vec<(usize, usize)>> {
    let url_re = Regex::new(r#"(?i)\b(https?|ftp|gopher|gemini)://[^\s<>"']+"#).unwrap();
    body.lines()
        .map(|line| {
            let mut ranges = Vec::new();
            for m in url_re.find_iter(line) {
                let prefix = &line[..m.start()];
                let start = prefix.chars().count();
                let url = m.as_str();
                let end = start + url.chars().count() - 1;
                ranges.push((start, end));
            }
            ranges
        })
        .collect()
}
