@echo off
REM Generates a .nsh file for the NSIS Windows installer with MD5 checksums
REM and file sizes of the UQM packages.
REM CMD command extension must be enabled to use this script.
REM The packages must be in the current directory.
REM Uses GNU md5sum utility, such as in Cygwin, which you must have somewhere
REM in PATH.

setlocal

set nsh_file=packages.nsh
set md5_tool=md5sum
set pkg_version=0.7.0

set content_pkg=uqm-%pkg_version%-content.uqm
set music_pkg=uqm-%pkg_version%-3domusic.uqm
set voice_pkg=uqm-%pkg_version%-voice.uqm
set remix1_pkg=uqm-remix-disc1.uqm
set remix2_pkg=uqm-remix-disc2.uqm
set remix3_pkg=uqm-remix-disc3.uqm
set remix4_pkg=uqm-remix-disc4.uqm

call :check_exists %content_pkg%
call :check_exists %music_pkg%
call :check_exists %voice_pkg%
call :check_exists %remix1_pkg%
call :check_exists %remix2_pkg%
call :check_exists %remix3_pkg%
REM call :check_exists %remix4_pkg%

call :check_md5_tool

echo # Autogenerated by procpkgs.cmd>%nsh_file%
echo #>>%nsh_file%

call :process_pkg %content_pkg% PKG_CONTENT
call :process_pkg %music_pkg% PKG_3DOMUSIC
call :process_pkg %voice_pkg% PKG_VOICE
call :process_pkg %remix1_pkg% PKG_REMIX1
call :process_pkg %remix2_pkg% PKG_REMIX2
call :process_pkg %remix3_pkg% PKG_REMIX3
REM call :process_pkg %remix4_pkg% PKG_REMIX4

echo All packages processed. %nsh_file% generated.
exit 0

:process_pkg
setlocal
echo Processing %1...>&2
echo !define %2_FILE "%1">>%nsh_file%
for /f %%s in ('%md5_tool% %1') do (set md5=%%s)
echo !define %2_MD5SUM "%md5%">>%nsh_file%
for /f "tokens=4" %%s in ('dir /n /-c %1 ^|find "%1"') do (set size=%%s)
set /a size/=1024
echo !define %2_SIZE %size%>>%nsh_file%
endlocal
goto :eof

:check_exists
if not exist %1 (echo %1 not found & exit 1)
goto :eof

:check_md5_tool
setlocal
echo Checking for GNU %md5_tool%...>&2
%md5_tool% --version >nul 2>&1 || (echo GNU %md5_tool% not found & exit 1)
for /f %%s in ('echo foo^|%md5_tool%') do (set md5=%%s)
if not "%md5%"=="2145971cf82058b108229a3a2e3bff35" (echo %md5_tool% is not GNU or does not operate correctly & exit 1)
endlocal
goto :eof
