/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{LitElement as u,html as s,nothing as m}from"lit";import{property as d,state as p,customElement as b}from"lit/decorators.js";import v from"@typo3/core/ajax/ajax-request.js";import"@typo3/backend/element/icon-element.js";var a=function(c,e,t,i){var r=arguments.length,n=r<3?e:i===null?i=Object.getOwnPropertyDescriptor(e,t):i,l;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")n=Reflect.decorate(c,e,t,i);else for(var h=c.length-1;h>=0;h--)(l=c[h])&&(n=(r<3?l(n):r>3?l(e,t,n):l(e,t))||n);return r>3&&n&&Object.defineProperty(e,t,n),n};let o=class extends u{constructor(){super(...arguments),this.activeColorScheme=null,this.colorSchemes=null,this.advancedOptionsExpanded=!1,this.autoDetect=null,this.enabled=null,this.colorSchemeMql=null,this.forcedColorsMql=null,this.colorSchemeMediaQueryListener=e=>this.autoDetect=e.matches?"dark":"light",this.forcedColorsMediaQueryListener=e=>this.enabled=!e.matches}connectedCallback(){super.connectedCallback(),this.colorSchemeMql=window.matchMedia("(prefers-color-scheme: dark)"),this.forcedColorsMql=window.matchMedia("(forced-colors: active)"),this.colorSchemeMediaQueryListener(this.colorSchemeMql),this.forcedColorsMediaQueryListener(this.forcedColorsMql),this.colorSchemeMql.addEventListener("change",this.colorSchemeMediaQueryListener),this.forcedColorsMql.addEventListener("change",this.forcedColorsMediaQueryListener)}disconnectedCallback(){super.disconnectedCallback(),this.colorSchemeMql.removeEventListener("change",this.colorSchemeMediaQueryListener),this.forcedColorsMql.removeEventListener("change",this.forcedColorsMediaQueryListener),this.colorSchemeMql=null,this.forcedColorsMql=null}createRenderRoot(){return this}getRealColorScheme(){return this.activeColorScheme==="auto"?this.autoDetect??"light":this.activeColorScheme??"light"}render(){return s`<div class=btn-group><button type=button class="btn btn-default" title=${this.enabled?this.toggleLabel:this.disabledLabel} ?disabled=${!this.enabled} @click=${e=>this.toggle(e)}><typo3-backend-icon identifier=${this.getIcon(this.activeColorScheme??"auto")} size=small></typo3-backend-icon>${this.getLabel(this.getRealColorScheme())}<typo3-backend-icon identifier=actions-exchange size=small style=margin-left:auto></typo3-backend-icon></button> <button type=button class="btn btn-default ${this.advancedOptionsExpanded?"active":""}" aria-haspopup=true aria-expanded=${this.advancedOptionsExpanded?"true":"false"} ?disabled=${!this.enabled} @click=${e=>{e.stopPropagation(),this.advancedOptionsExpanded=!this.advancedOptionsExpanded}}><span class=visually-hidden>Show more options</span><typo3-backend-icon identifier=${this.advancedOptionsExpanded?"actions-chevron-up":"actions-chevron-down"} size=small></typo3-backend-icon></button></div>${this.advancedOptionsExpanded===!1?m:s`<ul class=dropdown-list>${this.colorSchemes.map(e=>this.renderItem(e))}</ul>`}`}getIcon(e){return this.colorSchemes.find(t=>t.value===e)?.icon??"auto"}getLabel(e){return this.colorSchemes.find(t=>t.value===e)?.label??""}renderItem(e){return s`<li><button class=dropdown-item @click=${t=>this.handleClick(t,e.value)} aria-current=${this.activeColorScheme===e.value?"true":"false"}><span class=dropdown-item-columns> <span class="dropdown-item-column dropdown-item-column-icon" aria-hidden=true><typo3-backend-icon identifier=${e.icon} size=small></typo3-backend-icon> </span> <span class="dropdown-item-column dropdown-item-column-title">${e.label} ${e.value==="auto"?s`<span class=dropdown-item-column-title-info>${this.getLabel(this.autoDetect)}</span>`:""} </span> ${this.activeColorScheme===e.value?s`<span class=text-primary> <typo3-backend-icon identifier=actions-dot size=small></typo3-backend-icon> </span>`:s`<typo3-backend-icon identifier=empty-empty size=small></typo3-backend-icon>`} </span></button></li>`}async toggle(e){e.preventDefault(),e.stopPropagation();let i=this.getRealColorScheme()==="dark"?"light":"dark";i===this.autoDetect&&(i="auto"),this.triggerSchemeUpdate(i),await this.persistSchemeUpdate(i)}async handleClick(e,t){e.preventDefault(),e.stopPropagation(),this.triggerSchemeUpdate(t),await this.persistSchemeUpdate(t),this.advancedOptionsExpanded=!1}async persistSchemeUpdate(e){const t=new URL(TYPO3.settings.ajaxUrls.color_scheme_update,window.location.origin);return await new v(t).post({colorScheme:e})}triggerSchemeUpdate(e){document.dispatchEvent(new CustomEvent("typo3:color-scheme:update",{detail:{colorScheme:e}}))}};a([d({type:String})],o.prototype,"activeColorScheme",void 0),a([d({type:Array})],o.prototype,"colorSchemes",void 0),a([d({type:String})],o.prototype,"toggleLabel",void 0),a([d({type:String})],o.prototype,"disabledLabel",void 0),a([p()],o.prototype,"advancedOptionsExpanded",void 0),a([p()],o.prototype,"autoDetect",void 0),a([p()],o.prototype,"enabled",void 0),o=a([b("typo3-backend-color-scheme-switch")],o);export{o as ColorSchemeSwitchElement};
