# Contributing to Tekton Triggers

Welcome to the Tekton Triggers project! Thanks for considering contributing to
our project and we hope you'll enjoy it :D

**All contributors must comply with
[the code of conduct](./code-of-conduct.md).**

To get started developing, see our [DEVELOPMENT.md](./DEVELOPMENT.md).

In [the community repo](https://github.com/tektoncd/community) you'll find info
on:

- [Contacting other contributors](https://github.com/tektoncd/community/blob/master/contact.md)
- [Development standards](https://github.com/tektoncd/community/blob/master/standards.md)
  around
  [principles](https://github.com/tektoncd/community/blob/master/standards.md#principles),
  [commit messages](https://github.com/tektoncd/community/blob/master/standards.md#commit-messages)
  and
  [code](https://github.com/tektoncd/community/blob/master/standards.md#coding-standards)
- [Processes](https://github.com/tektoncd/community/blob/master/process.md) like
  [finding something to work on](https://github.com/tektoncd/community/blob/master/process.md#finding-something-to-work-on),
  [proposing features](https://github.com/tektoncd/community/blob/master/process.md#proposing-features),
  [reviews](https://github.com/tektoncd/community/blob/master/process.md#reviews)
  and
  [becoming an OWNER](https://github.com/tektoncd/community/blob/master/process.md#owners)

You can find details on our automation infrastructure in
[the plumbing repo](https://github.com/tektoncd/plumbing).

For more Triggers specific guidelines, see:

- [The Tekton Triggers ZenHub project](#zenhub-project)

See also
[the Tekton Pipelines roadmap](http://github.com/tektoncd/pipeline/blob/master/roadmap-2019.md)

## ZenHub project

You can see project details (including a burndown, issues in epics, etc.) on
[our ZenHub board](https://app.zenhub.com/workspaces/triggers-5d0ebce343e42a09a0a4a826).

To see this board, you must:

- Ask [an OWNER](OWNERS) via
  [slack](https://github.com/tektoncd/community/blob/master/contact.md#slack)
  for an invitation
- Add [the ZenHub browser extension](https://www.zenhub.com/extension) to see
  new info via GitHub (or just use zenhub.com directly)
