This program is an implementation of the [Skein cryptographic hash
algorithm](http://www.skein-hash.info/). This implementation is readable,
completely portable to a wide-variety of machines of differing word-sizes and
endianness. This program was originally written in SPARK 2005 by Rod Chapman as
a case study for the applicability of SPARK to cryptographic code. For details
on this case study, see the article ["SPARKSkein: A Formal and Fast Reference
Implementation of
Skein"](http://www.adacore.com/knowledge/technical-papers/sparkskein/). The
program in the toolset distribution is the SPARK 2014 version of this case
study.

Compared to the original version written for the previous generation of the
SPARK toolset, this version requires much less work to obtain complete
assurance of the absence of run-time errors. In the following, we call a
`precondition element` a conjunct in a precondition, `postcondition element` a
conjunct in a postcondition and `loop invariant element` a conjunct in a loop
invariant. The number of such elements in a verified program is directly
related (usually proportional) to the verification effort, as each such element
requires the user to write it, to debug it, and finally to prove it.

* Contrary to GNATprove, the previous toolset did not include
  Generation of Dependency Contracts. This required writing 17 non-trivial
  `global` contracts and 24 non-trivial `derives` contracts. With GNATprove,
  no data dependency or flow dependency is needed at all. We have kept 17 trivial
  null data dependency contracts and a single non-trivial data dependency contract
  for documentation purposes. Similarly, we have kept 11 trivial null flow
  dependency contracts for documentation purposes.

* SPARK naturally supports nesting of subprograms, which allows a natural
  top-down decomposition of the main operations into local procedures. This
  decomposition aids readability and has a negligible impact on performance,
  assuming the compiler is able to inline the local procedures, but it
  previously had a very costly impact on formal verification. The previous
  toolset required the user to write functional contracts on all local
  subprograms to be able to prove absence of run-time errors in these
  subprograms. On the contrary, GNATprove performs Contextual Analysis
  of Subprograms Without Contracts, which allows us to save the effort of
  writing 19 precondition elements and 12 postcondition elements that were
  needed in the original version.

* The previous toolset required the insertion of lengthy Loop
  Invariants, totalling 43 loop invariant elements (some of them quite
  complex), while GNATprove currently requires only 1 simple loop invariant
  stating which components of a record are not modified in the loop.
  This is partly due to GNATprove now being able to generate loop invariants
  for unmodified record components.

* The previous toolset generated a logical formula to prove for each path leading
  to a run-time check or an assertion. This lead to the generation of 367 formulas
  overall on the original version, almost 5 times more than the 78 checks
  generated by GNATprove on the new version. This difference is impressive,
  given that everything was done in the original version to control the
  explosion of the number of formulas, with the insertion of 24 special annotations
  in the source code similar to Pragma `Assert_And_Cut` in SPARK 2014,
  while no such work was needed in the new version. Despite this and other
  differences in efficiency between the two toolsets, the analysis time to
  ensure complete absence of run-time errors is similar between the two
  toolsets: 5 min with the previous toolset, half of that with GNATprove.

* Out of the 367 generated formulas, 29 were not proved automatically with the
  previous toolset: 6 formulas required the insertion of user-defined lemmas in the
  theorem prover, and 23 formulas required manual proof in a proof assistant. With
  GNATprove and provers CVC4, Z3 and Alt-Ergo, all checks are proved
  automatically.
