Example of illegal code:

```ada
package P
  with Abstract_State => A
is
private
   X : Integer; -- error: missing Part_Of aspect
end P;
```

This error is issued on variables declared in the private part of a package
with an aspect `Abstract_State`, when the variable does not have an aspect
`Part_Of` to relate it to one of the declared abstract states. Such a
declaration violates legality rule 2 of [section 7.2.6 of SPARK Reference
Manual].

While the corresponding information will be contained in the `Refined_State`
aspect attached to the package body, it should be possible to analyze the spec
in isolation, in particular in the context of the analysis of client
units. This is the purpose of the `Part_Of` aspect.

The fix is to add an aspect `Part_Of` to such variables, as follows:

```ada
package P
  with Abstract_State => A
is
private
   X : Integer with Part_Of => A;
end P;
```

[section 7.2.6 of SPARK Reference Manual]:
https://docs.adacore.com/live/wave/spark2014/html/spark2014_rm/packages.html#abstract-state-package-hierarchy-and-part-of
