(* This file is generated by Why3's Coq-realize driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require Reals.Rbasic_fun.
Require Reals.Rfunctions.
Require BuiltIn.
Require bool.Bool.
Require int.Int.
Require real.Real.
Require real.RealInfix.
Require real.Abs.
Require real.MinMax.
Require real.FromInt.
Require real.PowerInt.
Require floating_point.Rounding.
Require floating_point.SingleFormat.
Require floating_point.DoubleFormat.
Require floating_point.Single.
Require floating_point.Double.

Require Import Fourier.
Require Import Psatz.

(* Why3 assumption *)
Definition unit := unit.

(* Why3 goal *)
Definition qtmark : Type.
exact unit.
Defined.

(* Why3 goal *)
Definition truncate: R -> Z.
intro x.
pose proof (archimed x) as [_ Hup].
apply Rle_lt_or_eq_dec in Hup; destruct Hup as [Hup | Hup].
destruct (Rle_lt_dec x 0) as [Hx | Hx].
exact (up x)%Z.
exact (up x - 1)%Z.
exact (up x - 1)%Z.
Defined.

(* Why3 goal *)
Lemma Truncate_int :
forall (i:Z), ((truncate (Reals.Raxioms.IZR i)) = i).
intro i.
unfold truncate; case (archimed (IZR i)); intros H1 H2.
case (Rle_lt_or_eq_dec (IZR (up (IZR i)) - IZR i) 1 H2).
intro Wrong; contradict Wrong; apply Rle_not_gt.
apply Rgt_minus in H1.
rewrite Z_R_minus.
rewrite Z_R_minus in H2; apply le_IZR_R1 in H2.
rewrite Z_R_minus in H1; apply lt_0_IZR in H1;
apply Zlt_le_succ in H1; rewrite <- Z.one_succ in H1.
rewrite (Z.le_antisymm _ _ H2 H1); simpl; apply Rle_refl.
clear H1 H2; intro H.
apply eq_IZR.
rewrite <- Z_R_minus; simpl.
rewrite <- H.
ring.
Qed.

(* Why3 goal *)
Lemma Truncate_down_pos :
forall (x:R),
 (0%R <= x)%R ->
 (((Reals.Raxioms.IZR (truncate x)) <= x)%R
  /\ (x < (Reals.Raxioms.IZR ((truncate x) + 1%Z)%Z))%R).
intros x Hx1.
unfold truncate; case (archimed x); intros H1 H2.
case (Rle_lt_or_eq_dec (IZR (up x) - x) 1 H2);
clear H2; intro H2.
case Rle_lt_dec; intro Hx2.
contradict H1; apply Rle_not_gt.
apply (Rle_antisym x 0 Hx2) in Hx1.
revert H2; rewrite ?Hx1; rewrite Rminus_0_r;
intro H2.
change 0%R with (IZR 0) at 2; apply IZR_le.
change 1%R with (IZR 1) in H2; apply lt_IZR in H2.
lia.
split; [rewrite minus_IZR | rewrite Z.sub_simpl_r];
simpl; fourier.
split; [rewrite minus_IZR | rewrite Z.sub_simpl_r];
simpl; fourier.
Qed.

(* Why3 goal *)
Lemma Truncate_up_neg :
forall (x:R),
 (x <= 0%R)%R ->
 (((Reals.Raxioms.IZR ((truncate x) - 1%Z)%Z) < x)%R
  /\ (x <= (Reals.Raxioms.IZR (truncate x)))%R).
intros x Hx1.
unfold truncate; case (archimed x); intros H1 H2.
case (Rle_lt_or_eq_dec (IZR (up x) - x) 1 H2);
clear H2; intro H2.
case Rle_lt_dec; intro Hx2.
split; [rewrite minus_IZR |];
simpl; fourier.
contradict Hx1; apply Rlt_not_le; exact Hx2.
rewrite ?minus_IZR; simpl; split; fourier.
Qed.

(* Why3 goal *)
Lemma Real_of_truncate :
forall (x:R),
 ((x - 1%R)%R <= (Reals.Raxioms.IZR (truncate x)))%R
 /\ ((Reals.Raxioms.IZR (truncate x)) <= (x + 1%R)%R)%R.
intros x; case (Rle_dec x 0); intro H.
pose proof (Truncate_up_neg x H) as [Hx1 Hx2].
rewrite minus_IZR in Hx1; simpl in Hx1; split; fourier.
pose proof (Truncate_down_pos x (Rlt_le _ _ (Rnot_le_gt _ _ H))) as [Hx1 Hx2].
rewrite plus_IZR in Hx2; simpl in Hx2; split; fourier.
Qed.

(* Why3 goal *)
Lemma Truncate_monotonic :
forall (x:R) (y:R), (x <= y)%R -> ((truncate x) <= (truncate y))%Z.
intros x y Hxy.
case (Rle_dec y 0); intro Hy.
pose proof (Truncate_up_neg y Hy) as [_ Hty].
pose proof (Truncate_up_neg x (Rle_trans _ _ _ Hxy Hy)) as [Htx _].
apply (Rle_trans _ _ _ Hxy) in Hty.
apply (Rlt_le_trans _ _ _ Htx) in Hty.
apply lt_IZR in Hty; lia.
case (Rle_dec 0 x); intro Hx.
pose proof (Truncate_down_pos x Hx) as [Htx _].
pose proof (Truncate_down_pos y (Rle_trans _ _ _ Hx Hxy)) as [_ Hty].
apply (Rle_trans _ _ _ Htx) in Hxy.
apply (Rle_lt_trans _ _ _ Hxy) in Hty.
apply lt_IZR in Hty; lia.
apply Rnot_le_lt in Hy.
apply Rnot_le_lt in Hx.
pose proof (Truncate_up_neg x (Rlt_le _ _ Hx)) as [Htx _].
pose proof (Truncate_down_pos y (Rlt_le _ _ Hy)) as [_ Hty].
apply (Rlt_trans _ _ _ Htx) in Hx.
apply (Rlt_trans _ _ _ Hy) in Hty.
change 0 with (IZR 0) in Hx; apply lt_IZR in Hx;
change 0 with (IZR 0) in Hty; apply lt_IZR in Hty; lia.
Qed.

(* Why3 goal *)
Lemma Truncate_monotonic_int1 :
forall (x:R) (i:Z), (x <= (Reals.Raxioms.IZR i))%R -> ((truncate x) <= i)%Z.
intros x i Hxi.
rewrite <- Truncate_int.
apply (Truncate_monotonic _ _ Hxi).
Qed.

(* Why3 goal *)
Lemma Truncate_monotonic_int2 :
forall (x:R) (i:Z), ((Reals.Raxioms.IZR i) <= x)%R -> (i <= (truncate x))%Z.
intros x i Hxi.
rewrite <- (Truncate_int i).
apply (Truncate_monotonic _ _ Hxi).
Qed.

(* Why3 goal *)
Definition floor: R -> Z.
intro x; exact (up x - 1)%Z.
Defined.

(* Why3 goal *)
Definition ceil: R -> Z.
intro x.
pose proof (archimed x) as [_ Hup].
apply Rle_lt_or_eq_dec in Hup; destruct Hup as [Hup | Hup].
exact (up x).
exact (up x - 1)%Z.
Defined.

(* Why3 goal *)
Lemma Floor_int :
forall (i:Z), ((floor (Reals.Raxioms.IZR i)) = i).
intros i.
unfold floor; case (archimed (IZR i)); intros H1 H2.
rewrite <- minus_IZR in H2; change 1 with (IZR 1) in H2.
apply lt_IZR in H1; apply le_IZR in H2.
lia.
Qed.

(* Why3 goal *)
Lemma Ceil_int :
forall (i:Z), ((ceil (Reals.Raxioms.IZR i)) = i).
intros i.
unfold ceil; case (archimed (IZR i)); intros H1 H2.
case (Rle_lt_or_eq_dec (IZR (up (IZR i)) - IZR i) 1 H2);
clear H2.
intro Wrong; contradict Wrong; apply Rle_not_gt.
rewrite <- minus_IZR; change 1 with (IZR 1); apply IZR_le.
apply lt_IZR in H1; lia.
rewrite <- minus_IZR; change 1 with (IZR 1).
clear H1; intro H; apply eq_IZR in H.
lia.
Qed.

(* Why3 goal *)
Lemma Floor_down :
forall (x:R),
 ((Reals.Raxioms.IZR (floor x)) <= x)%R
 /\ (x < (Reals.Raxioms.IZR ((floor x) + 1%Z)%Z))%R.
intros x.
unfold floor; case (archimed x); intros H1 H2.
rewrite plus_IZR; rewrite ?minus_IZR; simpl.
split; fourier.
Qed.

(* Why3 goal *)
Lemma Ceil_up :
forall (x:R),
 ((Reals.Raxioms.IZR ((ceil x) - 1%Z)%Z) < x)%R
 /\ (x <= (Reals.Raxioms.IZR (ceil x)))%R.
intros x.
unfold ceil; case (archimed x); intros H1 H2.
case (Rle_lt_or_eq_dec (IZR (up x) - x) 1 H2);
clear H2; intro H2; rewrite ?minus_IZR; simpl;
split; fourier.
Qed.

(* Why3 goal *)
Lemma Floor_monotonic :
forall (x:R) (y:R), (x <= y)%R -> ((floor x) <= (floor y))%Z.
intros x y Hxy.
pose proof (Floor_down x) as [Hfx _].
pose proof (Floor_down y) as [_ Hfy].
apply (Rle_trans _ _ _ Hfx) in Hxy; apply (Rle_lt_trans _ _ _ Hxy) in Hfy.
apply lt_IZR in Hfy; lia.
Qed.

(* Why3 goal *)
Lemma Ceil_monotonic :
forall (x:R) (y:R), (x <= y)%R -> ((ceil x) <= (ceil y))%Z.
intros x y Hxy.
pose proof (Ceil_up x) as [Hfx _].
pose proof (Ceil_up y) as [_ Hfy].
apply (Rlt_le_trans _ _ _ Hfx) in Hxy; apply (Rlt_le_trans _ _ _ Hxy) in Hfy.
apply lt_IZR in Hfy; lia.
Qed.

(* Why3 goal *)
Lemma round_single_bound :
forall (x:R),
 (((x - ((1 / 16777216)%R * (Reals.Rbasic_fun.Rabs x))%R)%R - (1 / 1427247692705959881058285969449495136382746624)%R)%R <=
 (floating_point.Single.round floating_point.Rounding.NearestTiesToEven x))%R
 /\ ((floating_point.Single.round floating_point.Rounding.NearestTiesToEven x) <= ((x + ((1 / 16777216)%R * (Reals.Rbasic_fun.Rabs x))%R)%R + (1 / 1427247692705959881058285969449495136382746624)%R)%R)%R.
intros x.
Qed.

(* Why3 goal *)
Lemma round_double_bound :
forall (x:R),
 (((x - ((1 / 9007199254740992)%R * (Reals.Rbasic_fun.Rabs x))%R)%R - (1 / 404804506614621236704990693437834614099113299528284236713802716054860679135990693783920767402874248990374155728633623822779617474771586953734026799881477019843034848553132722728933815484186432682479535356945490137124014966849385397236206711298319112681620113024717539104666829230461005064372655017292012526615415482186989568)%R)%R <=
 (floating_point.Double.round floating_point.Rounding.NearestTiesToEven x))%R
 /\ ((floating_point.Double.round floating_point.Rounding.NearestTiesToEven x) <= ((x + ((1 / 9007199254740992)%R * (Reals.Rbasic_fun.Rabs x))%R)%R + (1 / 404804506614621236704990693437834614099113299528284236713802716054860679135990693783920767402874248990374155728633623822779617474771586953734026799881477019843034848553132722728933815484186432682479535356945490137124014966849385397236206711298319112681620113024717539104666829230461005064372655017292012526615415482186989568)%R)%R)%R.
intros x.

Qed.

(* Why3 goal *)
Lemma round_double_single :
forall (x:R),
 ((floating_point.Double.round floating_point.Rounding.NearestTiesToEven
    (floating_point.Single.round floating_point.Rounding.NearestTiesToEven x)) =
 (floating_point.Single.round floating_point.Rounding.NearestTiesToEven x)).
intros x.

Qed.

(* Why3 goal *)
Definition bool_lt: R -> R -> bool.

Defined.

(* Why3 goal *)
Definition bool_le: R -> R -> bool.

Defined.

(* Why3 goal *)
Definition bool_gt: R -> R -> bool.

Defined.

(* Why3 goal *)
Definition bool_ge: R -> R -> bool.

Defined.

(* Why3 goal *)
Definition bool_eq: R -> R -> bool.

Defined.

(* Why3 goal *)
Definition bool_neq: R -> R -> bool.

Defined.

(* Why3 goal *)
Lemma Bool_real__lt_axiom :
forall (x:R), forall (y:R), ((bool_lt x y) = true) <-> (x < y)%R.
intros x y.

Qed.

(* Why3 goal *)
Lemma Bool_real__le_axiom :
forall (x:R), forall (y:R), ((bool_le x y) = true) <-> (x <= y)%R.
intros x y.

Qed.

(* Why3 goal *)
Lemma Bool_real__gt_axiom :
forall (x:R), forall (y:R), ((bool_gt x y) = true) <-> (y < x)%R.
intros x y.

Qed.

(* Why3 goal *)
Lemma Bool_real__ge_axiom :
forall (x:R), forall (y:R), ((bool_ge x y) = true) <-> (y <= x)%R.
intros x y.

Qed.

(* Why3 goal *)
Lemma Bool_real__eq_axiom :
forall (x:R), forall (y:R), ((bool_eq x y) = true) <-> (x = y).
intros x y.

Qed.

(* Why3 goal *)
Lemma Bool_real__neq_axiom :
forall (x:R), forall (y:R), ((bool_neq x y) = true) <-> ~ (x = y).
intros x y.

Qed.

(* Why3 goal *)
Definition round: R -> Z.

Defined.

(* Why3 goal *)
Lemma Round_down :
forall (x:R),
 ((x - (Reals.Raxioms.IZR (floor x)))%R < (05 / 10)%R)%R ->
 ((round x) = (floor x)).
intros x h1.

Qed.

(* Why3 goal *)
Lemma Round_up :
forall (x:R),
 (((Reals.Raxioms.IZR (ceil x)) - x)%R < (05 / 10)%R)%R ->
 ((round x) = (ceil x)).
intros x h1.

Qed.

(* Why3 goal *)
Lemma Round_neg_tie :
forall (x:R),
 (((x - (Reals.Raxioms.IZR (floor x)))%R = (05 / 10)%R) /\ (x < 0%R)%R) ->
 ((round x) = (floor x)).
intros x (h1,h2).

Qed.

(* Why3 goal *)
Lemma Round_pos_tie :
forall (x:R),
 ((((Reals.Raxioms.IZR (ceil x)) - x)%R = (05 / 10)%R) /\ (0%R < x)%R) ->
 ((round x) = (ceil x)).
intros x (h1,h2).

Qed.

(* Why3 goal *)
Lemma Round_int :
forall (i:Z), ((round (Reals.Raxioms.IZR i)) = i).
intros i.

Qed.

(* Why3 goal *)
Lemma Round_near_int :
forall (i:Z),
 forall (x:R),
  (((-(05 / 10)%R)%R < x)%R /\ (x < (05 / 10)%R)%R) ->
  ((round ((Reals.Raxioms.IZR i) + x)%R) = i).
intros i x (h1,h2).

Qed.

(* Why3 goal *)
Lemma Round_monotonic :
forall (x:R) (y:R), (x <= y)%R -> ((round x) <= (round y))%Z.
intros x y h1.

Qed.

(* Why3 goal *)
Lemma Round_monotonic_int1 :
forall (x:R) (i:Z), (x <= (Reals.Raxioms.IZR i))%R -> ((round x) <= i)%Z.
intros x i h1.

Qed.

(* Why3 goal *)
Lemma Round_monotonic_int2 :
forall (x:R) (i:Z), ((Reals.Raxioms.IZR i) <= x)%R -> (i <= (round x))%Z.
intros x i h1.

Qed.

(* Why3 goal *)
Lemma Round_bound :
forall (x:R),
 ((x - (05 / 10)%R)%R <= (Reals.Raxioms.IZR (round x)))%R
 /\ ((Reals.Raxioms.IZR (round x)) <= (x + (05 / 10)%R)%R)%R.
intros x.

Qed.
