/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.maven.plugin.surefire.report.ReporterUtils;
import org.apache.maven.plugin.surefire.report.WrappedReportEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSetStats {
    private final Queue<WrappedReportEntry> reportEntries = new ConcurrentLinkedQueue<WrappedReportEntry>();
    private final boolean trimStackTrace;
    private final boolean plainFormat;
    private long testSetStartAt;
    private long testStartAt;
    private int completedCount;
    private int errors;
    private int failures;
    private int skipped;
    private long lastStartAt;

    public TestSetStats(boolean trimStackTrace, boolean plainFormat) {
        this.trimStackTrace = trimStackTrace;
        this.plainFormat = plainFormat;
    }

    public int getElapsedSinceTestSetStart() {
        return this.testSetStartAt > 0L ? (int)(System.currentTimeMillis() - this.testSetStartAt) : 0;
    }

    public int getElapsedSinceLastStart() {
        return this.lastStartAt > 0L ? (int)(System.currentTimeMillis() - this.lastStartAt) : 0;
    }

    public void testSetStart() {
        this.lastStartAt = this.testSetStartAt = System.currentTimeMillis();
    }

    public void testStart() {
        this.lastStartAt = this.testStartAt = System.currentTimeMillis();
    }

    private long finishTest(WrappedReportEntry reportEntry) {
        this.reportEntries.add(reportEntry);
        this.incrementCompletedCount();
        long testEndAt = System.currentTimeMillis();
        if (this.testStartAt == 0L) {
            this.testStartAt = testEndAt;
        }
        return reportEntry.getElapsed() != null ? (long)reportEntry.getElapsed().intValue() : testEndAt - this.testStartAt;
    }

    public void testSucceeded(WrappedReportEntry reportEntry) {
        this.finishTest(reportEntry);
    }

    public void testError(WrappedReportEntry reportEntry) {
        ++this.errors;
        this.finishTest(reportEntry);
    }

    public void testFailure(WrappedReportEntry reportEntry) {
        ++this.failures;
        this.finishTest(reportEntry);
    }

    public void testSkipped(WrappedReportEntry reportEntry) {
        ++this.skipped;
        this.finishTest(reportEntry);
    }

    public void reset() {
        this.completedCount = 0;
        this.errors = 0;
        this.failures = 0;
        this.skipped = 0;
        for (WrappedReportEntry entry : this.reportEntries) {
            entry.getStdout().free();
            entry.getStdErr().free();
        }
        this.reportEntries.clear();
    }

    public int getCompletedCount() {
        return this.completedCount;
    }

    public int getErrors() {
        return this.errors;
    }

    public int getFailures() {
        return this.failures;
    }

    public int getSkipped() {
        return this.skipped;
    }

    public String elapsedTimeAsString(long runTime) {
        return ReporterUtils.formatElapsedTime(runTime);
    }

    private void incrementCompletedCount() {
        ++this.completedCount;
    }

    public String getTestSetSummary(WrappedReportEntry reportEntry) {
        String summary = "Tests run: ";
        summary = summary + this.completedCount;
        summary = summary + ", Failures: ";
        summary = summary + this.failures;
        summary = summary + ", Errors: ";
        summary = summary + this.errors;
        summary = summary + ", Skipped: ";
        summary = summary + this.skipped;
        summary = summary + ", ";
        summary = summary + reportEntry.getElapsedTimeVerbose();
        if (this.failures > 0 || this.errors > 0) {
            summary = summary + " <<< FAILURE!";
        }
        summary = summary + " - in ";
        summary = summary + reportEntry.getNameWithGroup();
        summary = summary + "\n";
        return summary;
    }

    public List<String> getTestResults() {
        ArrayList<String> result = new ArrayList<String>();
        for (WrappedReportEntry testResult : this.reportEntries) {
            if (testResult.isErrorOrFailure()) {
                result.add(testResult.getOutput(this.trimStackTrace));
                continue;
            }
            if (this.plainFormat && testResult.isSkipped()) {
                result.add(testResult.getName() + " skipped");
                continue;
            }
            if (!this.plainFormat || !testResult.isSucceeded()) continue;
            result.add(testResult.getElapsedTimeSummary());
        }
        return result;
    }

    public Collection<WrappedReportEntry> getReportEntries() {
        return this.reportEntries;
    }
}

