# This file is auto-generated by /codegen/x86_64.py
# Instruction data is based on package opcodes 0.3.14

import inspect

import peachpy.stream
import peachpy.x86_64.options
import peachpy.x86_64.isa
from peachpy.util import is_sint8, is_sint32
from peachpy.x86_64.encoding import rex, optional_rex, vex2, vex3, evex, modrm_sib_disp
from peachpy.x86_64.instructions import Instruction, BranchInstruction
from peachpy.x86_64.operand import is_al, is_ax, is_eax, is_rax, is_cl, is_xmm0, is_r8, is_r8rex, is_r16, is_r32, is_r64, \
    is_mm, is_xmm, is_ymm, is_m, is_m8, is_m16, is_m32, is_m64, is_m80, is_m128, is_m256, is_m512, \
    is_evex_xmm, is_xmmk, is_xmmkz, is_evex_ymm, is_ymmk, is_ymmkz, is_zmm, is_zmmk, is_zmmkz, is_k, is_kk, \
    is_m32k, is_m64k, is_m16kz, is_m32kz, is_m64kz, is_m128kz, is_m256kz, is_m512kz, \
    is_m64_m32bcst, is_m128_m32bcst, is_m256_m32bcst, is_m512_m32bcst, \
    is_m128_m64bcst, is_m256_m64bcst, is_m512_m64bcst, \
    is_vmx, is_vmy, is_evex_vmx, is_evex_vmy, is_vmz, is_vmxk, is_vmyk, is_vmzk, \
    is_imm, is_imm4, is_imm8, is_imm16, is_imm32, is_imm64, \
    is_rel8, is_rel32, is_label, is_er, is_sae, check_operand, format_operand_type


class VFMADD132SS(Instruction):
    """Fused Multiply-Add of Scalar Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMADD132SS(xmm, xmm, xmm/m32)            [FMA3]
            * VFMADD132SS(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
            * VFMADD132SS(xmm{k}{z}, xmm, xmm/m32)      [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMADD132SS, self).__init__("VFMADD132SS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x99, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x99]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x99]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x99, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADD132SS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x99, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADD132SS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMADD132SS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMADD213SS(Instruction):
    """Fused Multiply-Add of Scalar Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMADD213SS(xmm, xmm, xmm/m32)            [FMA3]
            * VFMADD213SS(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
            * VFMADD213SS(xmm{k}{z}, xmm, xmm/m32)      [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMADD213SS, self).__init__("VFMADD213SS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0xA9, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xA9]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0xA9]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xA9, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADD213SS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xA9, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADD213SS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMADD213SS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMADD231SS(Instruction):
    """Fused Multiply-Add of Scalar Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMADD231SS(xmm, xmm, xmm/m32)            [FMA3]
            * VFMADD231SS(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
            * VFMADD231SS(xmm{k}{z}, xmm, xmm/m32)      [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMADD231SS, self).__init__("VFMADD231SS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0xB9, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xB9]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0xB9]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xB9, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADD231SS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xB9, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADD231SS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMADD231SS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMADDSS(Instruction):
    """Fused Multiply-Add of Scalar Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMADDSS(xmm, xmm, xmm, xmm/m32)    [FMA4]
            * VFMADDSS(xmm, xmm, xmm/m32, xmm)    [FMA4]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMADDSS, self).__init__("VFMADDSS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VFMADDSS\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.fma4])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x6A, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x6A, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_m32(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x81, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x6A]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m32(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x6A]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VFMADDSS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMSUB132SS(Instruction):
    """Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMSUB132SS(xmm, xmm, xmm/m32)            [FMA3]
            * VFMSUB132SS(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
            * VFMSUB132SS(xmm{k}{z}, xmm, xmm/m32)      [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMSUB132SS, self).__init__("VFMSUB132SS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x9B, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x9B]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x9B]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x9B, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUB132SS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x9B, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUB132SS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMSUB132SS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMSUB213SS(Instruction):
    """Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMSUB213SS(xmm, xmm, xmm/m32)            [FMA3]
            * VFMSUB213SS(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
            * VFMSUB213SS(xmm{k}{z}, xmm, xmm/m32)      [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMSUB213SS, self).__init__("VFMSUB213SS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0xAB, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xAB]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0xAB]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xAB, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUB213SS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xAB, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUB213SS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMSUB213SS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMSUB231SS(Instruction):
    """Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMSUB231SS(xmm, xmm, xmm/m32)            [FMA3]
            * VFMSUB231SS(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
            * VFMSUB231SS(xmm{k}{z}, xmm, xmm/m32)      [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMSUB231SS, self).__init__("VFMSUB231SS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0xBB, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xBB]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0xBB]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xBB, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUB231SS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xBB, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUB231SS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMSUB231SS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMSUBSS(Instruction):
    """Fused Multiply-Subtract of Scalar Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMSUBSS(xmm, xmm, xmm, xmm/m32)    [FMA4]
            * VFMSUBSS(xmm, xmm, xmm/m32, xmm)    [FMA4]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMSUBSS, self).__init__("VFMSUBSS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VFMSUBSS\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.fma4])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x6E, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x6E, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_m32(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x81, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x6E]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m32(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x6E]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VFMSUBSS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMADD132SS(Instruction):
    """Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMADD132SS(xmm, xmm, xmm/m32)            [FMA3]
            * VFNMADD132SS(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
            * VFNMADD132SS(xmm{k}{z}, xmm, xmm/m32)      [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMADD132SS, self).__init__("VFNMADD132SS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x9D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x9D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x9D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x9D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMADD132SS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x9D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMADD132SS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFNMADD132SS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMADD213SS(Instruction):
    """Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMADD213SS(xmm, xmm, xmm/m32)            [FMA3]
            * VFNMADD213SS(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
            * VFNMADD213SS(xmm{k}{z}, xmm, xmm/m32)      [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMADD213SS, self).__init__("VFNMADD213SS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0xAD, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xAD]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0xAD]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xAD, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMADD213SS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xAD, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMADD213SS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFNMADD213SS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMADD231SS(Instruction):
    """Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMADD231SS(xmm, xmm, xmm/m32)            [FMA3]
            * VFNMADD231SS(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
            * VFNMADD231SS(xmm{k}{z}, xmm, xmm/m32)      [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMADD231SS, self).__init__("VFNMADD231SS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0xBD, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xBD]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0xBD]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xBD, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMADD231SS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xBD, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMADD231SS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFNMADD231SS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMADDSS(Instruction):
    """Fused Negative Multiply-Add of Scalar Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMADDSS(xmm, xmm, xmm, xmm/m32)    [FMA4]
            * VFNMADDSS(xmm, xmm, xmm/m32, xmm)    [FMA4]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMADDSS, self).__init__("VFNMADDSS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VFNMADDSS\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.fma4])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x7A, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x7A, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_m32(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x81, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x7A]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m32(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x7A]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VFNMADDSS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMSUB132SS(Instruction):
    """Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMSUB132SS(xmm, xmm, xmm/m32)            [FMA3]
            * VFNMSUB132SS(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
            * VFNMSUB132SS(xmm{k}{z}, xmm, xmm/m32)      [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMSUB132SS, self).__init__("VFNMSUB132SS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x9F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x9F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x9F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x9F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMSUB132SS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x9F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMSUB132SS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFNMSUB132SS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMSUB213SS(Instruction):
    """Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMSUB213SS(xmm, xmm, xmm/m32)            [FMA3]
            * VFNMSUB213SS(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
            * VFNMSUB213SS(xmm{k}{z}, xmm, xmm/m32)      [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMSUB213SS, self).__init__("VFNMSUB213SS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0xAF, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xAF]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0xAF]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xAF, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMSUB213SS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xAF, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMSUB213SS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFNMSUB213SS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMSUB231SS(Instruction):
    """Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMSUB231SS(xmm, xmm, xmm/m32)            [FMA3]
            * VFNMSUB231SS(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
            * VFNMSUB231SS(xmm{k}{z}, xmm, xmm/m32)      [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMSUB231SS, self).__init__("VFNMSUB231SS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0xBF, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xBF]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0xBF]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xBF, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMSUB231SS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xBF, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMSUB231SS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFNMSUB231SS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMSUBSS(Instruction):
    """Fused Negative Multiply-Subtract of Scalar Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMSUBSS(xmm, xmm, xmm, xmm/m32)    [FMA4]
            * VFNMSUBSS(xmm, xmm, xmm/m32, xmm)    [FMA4]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMSUBSS, self).__init__("VFNMSUBSS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VFNMSUBSS\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.fma4])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x7E, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x7E, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_m32(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x81, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x7E]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m32(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x7E]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VFNMSUBSS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMADD132SD(Instruction):
    """Fused Multiply-Add of Scalar Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMADD132SD(xmm, xmm, xmm/m64)            [FMA3]
            * VFMADD132SD(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
            * VFMADD132SD(xmm{k}{z}, xmm, xmm/m64)      [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMADD132SD, self).__init__("VFMADD132SD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x99, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x99]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x99]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x99, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADD132SD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x99, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADD132SD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMADD132SD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMADD213SD(Instruction):
    """Fused Multiply-Add of Scalar Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMADD213SD(xmm, xmm, xmm/m64)            [FMA3]
            * VFMADD213SD(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
            * VFMADD213SD(xmm{k}{z}, xmm, xmm/m64)      [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMADD213SD, self).__init__("VFMADD213SD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0xA9, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xA9]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0xA9]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xA9, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADD213SD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xA9, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADD213SD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMADD213SD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMADD231SD(Instruction):
    """Fused Multiply-Add of Scalar Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMADD231SD(xmm, xmm, xmm/m64)            [FMA3]
            * VFMADD231SD(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
            * VFMADD231SD(xmm{k}{z}, xmm, xmm/m64)      [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMADD231SD, self).__init__("VFMADD231SD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0xB9, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xB9]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0xB9]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xB9, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADD231SD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xB9, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADD231SD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMADD231SD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMADDSD(Instruction):
    """Fused Multiply-Add of Scalar Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMADDSD(xmm, xmm, xmm, xmm/m64)    [FMA4]
            * VFMADDSD(xmm, xmm, xmm/m64, xmm)    [FMA4]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMADDSD, self).__init__("VFMADDSD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VFMADDSD\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.fma4])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x6B, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x6B, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_m64(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x81, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x6B]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m64(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x6B]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VFMADDSD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMSUB132SD(Instruction):
    """Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMSUB132SD(xmm, xmm, xmm/m64)            [FMA3]
            * VFMSUB132SD(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
            * VFMSUB132SD(xmm{k}{z}, xmm, xmm/m64)      [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMSUB132SD, self).__init__("VFMSUB132SD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x9B, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x9B]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x9B]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x9B, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUB132SD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x9B, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUB132SD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMSUB132SD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMSUB213SD(Instruction):
    """Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMSUB213SD(xmm, xmm, xmm/m64)            [FMA3]
            * VFMSUB213SD(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
            * VFMSUB213SD(xmm{k}{z}, xmm, xmm/m64)      [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMSUB213SD, self).__init__("VFMSUB213SD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0xAB, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xAB]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0xAB]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xAB, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUB213SD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xAB, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUB213SD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMSUB213SD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMSUB231SD(Instruction):
    """Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMSUB231SD(xmm, xmm, xmm/m64)            [FMA3]
            * VFMSUB231SD(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
            * VFMSUB231SD(xmm{k}{z}, xmm, xmm/m64)      [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMSUB231SD, self).__init__("VFMSUB231SD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0xBB, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xBB]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0xBB]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xBB, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUB231SD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xBB, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUB231SD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMSUB231SD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMSUBSD(Instruction):
    """Fused Multiply-Subtract of Scalar Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMSUBSD(xmm, xmm, xmm, xmm/m64)    [FMA4]
            * VFMSUBSD(xmm, xmm, xmm/m64, xmm)    [FMA4]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMSUBSD, self).__init__("VFMSUBSD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VFMSUBSD\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.fma4])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x6F, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x6F, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_m64(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x81, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x6F]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m64(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x6F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VFMSUBSD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMADD132SD(Instruction):
    """Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMADD132SD(xmm, xmm, xmm/m64)            [FMA3]
            * VFNMADD132SD(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
            * VFNMADD132SD(xmm{k}{z}, xmm, xmm/m64)      [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMADD132SD, self).__init__("VFNMADD132SD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x9D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x9D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x9D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x9D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMADD132SD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x9D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMADD132SD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFNMADD132SD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMADD213SD(Instruction):
    """Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMADD213SD(xmm, xmm, xmm/m64)            [FMA3]
            * VFNMADD213SD(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
            * VFNMADD213SD(xmm{k}{z}, xmm, xmm/m64)      [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMADD213SD, self).__init__("VFNMADD213SD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0xAD, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xAD]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0xAD]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xAD, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMADD213SD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xAD, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMADD213SD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFNMADD213SD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMADD231SD(Instruction):
    """Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMADD231SD(xmm, xmm, xmm/m64)            [FMA3]
            * VFNMADD231SD(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
            * VFNMADD231SD(xmm{k}{z}, xmm, xmm/m64)      [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMADD231SD, self).__init__("VFNMADD231SD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0xBD, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xBD]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0xBD]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xBD, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMADD231SD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xBD, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMADD231SD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFNMADD231SD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMADDSD(Instruction):
    """Fused Negative Multiply-Add of Scalar Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMADDSD(xmm, xmm, xmm, xmm/m64)    [FMA4]
            * VFNMADDSD(xmm, xmm, xmm/m64, xmm)    [FMA4]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMADDSD, self).__init__("VFNMADDSD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VFNMADDSD\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.fma4])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x7B, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x7B, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_m64(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x81, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x7B]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m64(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x7B]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VFNMADDSD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMSUB132SD(Instruction):
    """Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMSUB132SD(xmm, xmm, xmm/m64)            [FMA3]
            * VFNMSUB132SD(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
            * VFNMSUB132SD(xmm{k}{z}, xmm, xmm/m64)      [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMSUB132SD, self).__init__("VFNMSUB132SD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x9F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x9F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x9F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x9F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMSUB132SD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x9F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMSUB132SD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFNMSUB132SD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMSUB213SD(Instruction):
    """Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMSUB213SD(xmm, xmm, xmm/m64)            [FMA3]
            * VFNMSUB213SD(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
            * VFNMSUB213SD(xmm{k}{z}, xmm, xmm/m64)      [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMSUB213SD, self).__init__("VFNMSUB213SD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0xAF, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xAF]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0xAF]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xAF, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMSUB213SD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xAF, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMSUB213SD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFNMSUB213SD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMSUB231SD(Instruction):
    """Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMSUB231SD(xmm, xmm, xmm/m64)            [FMA3]
            * VFNMSUB231SD(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
            * VFNMSUB231SD(xmm{k}{z}, xmm, xmm/m64)      [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMSUB231SD, self).__init__("VFNMSUB231SD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0xBF, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xBF]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0xBF]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xBF, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMSUB231SD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xBF, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMSUB231SD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFNMSUB231SD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMSUBSD(Instruction):
    """Fused Negative Multiply-Subtract of Scalar Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMSUBSD(xmm, xmm, xmm, xmm/m64)    [FMA4]
            * VFNMSUBSD(xmm, xmm, xmm/m64, xmm)    [FMA4]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMSUBSD, self).__init__("VFNMSUBSD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VFNMSUBSD\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.fma4])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x7F, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x7F, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_m64(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x81, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x7F]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m64(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x7F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VFNMSUBSD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMADD132PS(Instruction):
    """Fused Multiply-Add of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMADD132PS(xmm, xmm, xmm/m128)              [FMA3]
            * VFMADD132PS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512F and AVX512VL]
            * VFMADD132PS(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFMADD132PS(ymm, ymm, ymm/m256)              [FMA3]
            * VFMADD132PS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VFMADD132PS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFMADD132PS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VFMADD132PS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFMADD132PS(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMADD132PS, self).__init__("VFMADD132PS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x98, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x98]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0x98, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x98]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x98]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x98, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x98]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x98, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x98]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x98, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADD132PS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x98, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADD132PS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMADD132PS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMADD213PS(Instruction):
    """Fused Multiply-Add of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMADD213PS(xmm, xmm, xmm/m128)              [FMA3]
            * VFMADD213PS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512F and AVX512VL]
            * VFMADD213PS(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFMADD213PS(ymm, ymm, ymm/m256)              [FMA3]
            * VFMADD213PS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VFMADD213PS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFMADD213PS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VFMADD213PS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFMADD213PS(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMADD213PS, self).__init__("VFMADD213PS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0xA8, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xA8]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0xA8, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xA8]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xA8]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xA8, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xA8]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0xA8, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xA8]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0xA8, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADD213PS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xA8, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADD213PS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMADD213PS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMADD231PS(Instruction):
    """Fused Multiply-Add of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMADD231PS(xmm, xmm, xmm/m128)              [FMA3]
            * VFMADD231PS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512F and AVX512VL]
            * VFMADD231PS(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFMADD231PS(ymm, ymm, ymm/m256)              [FMA3]
            * VFMADD231PS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VFMADD231PS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFMADD231PS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VFMADD231PS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFMADD231PS(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMADD231PS, self).__init__("VFMADD231PS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0xB8, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xB8]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0xB8, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xB8]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xB8]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xB8, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xB8]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0xB8, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xB8]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0xB8, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADD231PS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xB8, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADD231PS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMADD231PS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMADDPS(Instruction):
    """Fused Multiply-Add of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMADDPS(xmm, xmm, xmm, xmm/m128)    [FMA4]
            * VFMADDPS(xmm, xmm, xmm/m128, xmm)    [FMA4]
            * VFMADDPS(ymm, ymm, ymm, ymm/m256)    [FMA4]
            * VFMADDPS(ymm, ymm, ymm/m256, ymm)    [FMA4]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMADDPS, self).__init__("VFMADDPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VFMADDPS\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.fma4])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x68, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x68, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_m128(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x81, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x68]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x68]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_ymm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0x68, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0x68, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_m256(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x85, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x68]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]) and is_ymm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x68]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VFMADDPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMSUB132PS(Instruction):
    """Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMSUB132PS(xmm, xmm, xmm/m128)              [FMA3]
            * VFMSUB132PS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512F and AVX512VL]
            * VFMSUB132PS(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFMSUB132PS(ymm, ymm, ymm/m256)              [FMA3]
            * VFMSUB132PS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VFMSUB132PS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFMSUB132PS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VFMSUB132PS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFMSUB132PS(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMSUB132PS, self).__init__("VFMSUB132PS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x9A, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x9A]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0x9A, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x9A]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x9A]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x9A, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x9A]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x9A, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x9A]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x9A, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUB132PS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x9A, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUB132PS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMSUB132PS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMSUB213PS(Instruction):
    """Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMSUB213PS(xmm, xmm, xmm/m128)              [FMA3]
            * VFMSUB213PS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512F and AVX512VL]
            * VFMSUB213PS(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFMSUB213PS(ymm, ymm, ymm/m256)              [FMA3]
            * VFMSUB213PS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VFMSUB213PS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFMSUB213PS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VFMSUB213PS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFMSUB213PS(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMSUB213PS, self).__init__("VFMSUB213PS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0xAA, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xAA]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0xAA, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xAA]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xAA]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xAA, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xAA]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0xAA, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xAA]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0xAA, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUB213PS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xAA, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUB213PS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMSUB213PS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMSUB231PS(Instruction):
    """Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMSUB231PS(xmm, xmm, xmm/m128)              [FMA3]
            * VFMSUB231PS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512F and AVX512VL]
            * VFMSUB231PS(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFMSUB231PS(ymm, ymm, ymm/m256)              [FMA3]
            * VFMSUB231PS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VFMSUB231PS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFMSUB231PS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VFMSUB231PS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFMSUB231PS(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMSUB231PS, self).__init__("VFMSUB231PS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0xBA, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xBA]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0xBA, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xBA]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xBA]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xBA, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xBA]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0xBA, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xBA]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0xBA, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUB231PS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xBA, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUB231PS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMSUB231PS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMSUBPS(Instruction):
    """Fused Multiply-Subtract of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMSUBPS(xmm, xmm, xmm, xmm/m128)    [FMA4]
            * VFMSUBPS(xmm, xmm, xmm/m128, xmm)    [FMA4]
            * VFMSUBPS(ymm, ymm, ymm, ymm/m256)    [FMA4]
            * VFMSUBPS(ymm, ymm, ymm/m256, ymm)    [FMA4]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMSUBPS, self).__init__("VFMSUBPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VFMSUBPS\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.fma4])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x6C, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x6C, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_m128(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x81, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x6C]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x6C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_ymm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0x6C, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0x6C, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_m256(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x85, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x6C]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]) and is_ymm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x6C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VFMSUBPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMADD132PS(Instruction):
    """Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMADD132PS(xmm, xmm, xmm/m128)              [FMA3]
            * VFNMADD132PS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512F and AVX512VL]
            * VFNMADD132PS(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFNMADD132PS(ymm, ymm, ymm/m256)              [FMA3]
            * VFNMADD132PS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VFNMADD132PS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFNMADD132PS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VFNMADD132PS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFNMADD132PS(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMADD132PS, self).__init__("VFNMADD132PS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x9C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x9C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0x9C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x9C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x9C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x9C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x9C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x9C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x9C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x9C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMADD132PS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x9C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMADD132PS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFNMADD132PS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMADD213PS(Instruction):
    """Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMADD213PS(xmm, xmm, xmm/m128)              [FMA3]
            * VFNMADD213PS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512F and AVX512VL]
            * VFNMADD213PS(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFNMADD213PS(ymm, ymm, ymm/m256)              [FMA3]
            * VFNMADD213PS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VFNMADD213PS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFNMADD213PS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VFNMADD213PS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFNMADD213PS(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMADD213PS, self).__init__("VFNMADD213PS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0xAC, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xAC]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0xAC, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xAC]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xAC]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xAC, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xAC]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0xAC, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xAC]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0xAC, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMADD213PS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xAC, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMADD213PS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFNMADD213PS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMADD231PS(Instruction):
    """Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMADD231PS(xmm, xmm, xmm/m128)              [FMA3]
            * VFNMADD231PS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512F and AVX512VL]
            * VFNMADD231PS(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFNMADD231PS(ymm, ymm, ymm/m256)              [FMA3]
            * VFNMADD231PS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VFNMADD231PS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFNMADD231PS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VFNMADD231PS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFNMADD231PS(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMADD231PS, self).__init__("VFNMADD231PS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0xBC, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xBC]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0xBC, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xBC]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xBC]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xBC, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xBC]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0xBC, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xBC]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0xBC, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMADD231PS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xBC, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMADD231PS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFNMADD231PS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMADDPS(Instruction):
    """Fused Negative Multiply-Add of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMADDPS(xmm, xmm, xmm, xmm/m128)    [FMA4]
            * VFNMADDPS(xmm, xmm, xmm/m128, xmm)    [FMA4]
            * VFNMADDPS(ymm, ymm, ymm, ymm/m256)    [FMA4]
            * VFNMADDPS(ymm, ymm, ymm/m256, ymm)    [FMA4]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMADDPS, self).__init__("VFNMADDPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VFNMADDPS\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.fma4])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x78, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x78, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_m128(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x81, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x78]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x78]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_ymm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0x78, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0x78, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_m256(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x85, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x78]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]) and is_ymm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x78]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VFNMADDPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMSUB132PS(Instruction):
    """Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMSUB132PS(xmm, xmm, xmm/m128)              [FMA3]
            * VFNMSUB132PS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512F and AVX512VL]
            * VFNMSUB132PS(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFNMSUB132PS(ymm, ymm, ymm/m256)              [FMA3]
            * VFNMSUB132PS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VFNMSUB132PS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFNMSUB132PS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VFNMSUB132PS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFNMSUB132PS(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMSUB132PS, self).__init__("VFNMSUB132PS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x9E, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x9E]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0x9E, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x9E]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x9E]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x9E, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x9E]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x9E, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x9E]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x9E, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMSUB132PS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x9E, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMSUB132PS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFNMSUB132PS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMSUB213PS(Instruction):
    """Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMSUB213PS(xmm, xmm, xmm/m128)              [FMA3]
            * VFNMSUB213PS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512F and AVX512VL]
            * VFNMSUB213PS(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFNMSUB213PS(ymm, ymm, ymm/m256)              [FMA3]
            * VFNMSUB213PS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VFNMSUB213PS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFNMSUB213PS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VFNMSUB213PS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFNMSUB213PS(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMSUB213PS, self).__init__("VFNMSUB213PS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0xAE, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xAE]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0xAE, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xAE]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xAE]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xAE, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xAE]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0xAE, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xAE]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0xAE, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMSUB213PS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xAE, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMSUB213PS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFNMSUB213PS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMSUB231PS(Instruction):
    """Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMSUB231PS(xmm, xmm, xmm/m128)              [FMA3]
            * VFNMSUB231PS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512F and AVX512VL]
            * VFNMSUB231PS(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFNMSUB231PS(ymm, ymm, ymm/m256)              [FMA3]
            * VFNMSUB231PS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VFNMSUB231PS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFNMSUB231PS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VFNMSUB231PS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFNMSUB231PS(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMSUB231PS, self).__init__("VFNMSUB231PS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0xBE, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xBE]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0xBE, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xBE]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xBE]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xBE, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xBE]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0xBE, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xBE]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0xBE, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMSUB231PS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xBE, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMSUB231PS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFNMSUB231PS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMSUBPS(Instruction):
    """Fused Negative Multiply-Subtract of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMSUBPS(xmm, xmm, xmm, xmm/m128)    [FMA4]
            * VFNMSUBPS(xmm, xmm, xmm/m128, xmm)    [FMA4]
            * VFNMSUBPS(ymm, ymm, ymm, ymm/m256)    [FMA4]
            * VFNMSUBPS(ymm, ymm, ymm/m256, ymm)    [FMA4]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMSUBPS, self).__init__("VFNMSUBPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VFNMSUBPS\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.fma4])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x7C, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x7C, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_m128(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x81, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x7C]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x7C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_ymm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0x7C, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0x7C, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_m256(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x85, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x7C]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]) and is_ymm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x7C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VFNMSUBPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMADD132PD(Instruction):
    """Fused Multiply-Add of Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMADD132PD(xmm, xmm, xmm/m128)              [FMA3]
            * VFMADD132PD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512F and AVX512VL]
            * VFMADD132PD(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFMADD132PD(ymm, ymm, ymm/m256)              [FMA3]
            * VFMADD132PD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512F and AVX512VL]
            * VFMADD132PD(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFMADD132PD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512F]
            * VFMADD132PD(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFMADD132PD(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMADD132PD, self).__init__("VFMADD132PD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x98, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x98]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0x98, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x85, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x98]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x98]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x98, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x98]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x98, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x98]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x98, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADD132PD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x98, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADD132PD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMADD132PD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMADD213PD(Instruction):
    """Fused Multiply-Add of Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMADD213PD(xmm, xmm, xmm/m128)              [FMA3]
            * VFMADD213PD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512F and AVX512VL]
            * VFMADD213PD(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFMADD213PD(ymm, ymm, ymm/m256)              [FMA3]
            * VFMADD213PD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512F and AVX512VL]
            * VFMADD213PD(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFMADD213PD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512F]
            * VFMADD213PD(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFMADD213PD(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMADD213PD, self).__init__("VFMADD213PD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0xA8, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xA8]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0xA8, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x85, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xA8]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xA8]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xA8, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xA8]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0xA8, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xA8]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0xA8, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADD213PD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xA8, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADD213PD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMADD213PD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMADD231PD(Instruction):
    """Fused Multiply-Add of Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMADD231PD(xmm, xmm, xmm/m128)              [FMA3]
            * VFMADD231PD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512F and AVX512VL]
            * VFMADD231PD(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFMADD231PD(ymm, ymm, ymm/m256)              [FMA3]
            * VFMADD231PD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512F and AVX512VL]
            * VFMADD231PD(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFMADD231PD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512F]
            * VFMADD231PD(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFMADD231PD(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMADD231PD, self).__init__("VFMADD231PD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0xB8, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xB8]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0xB8, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x85, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xB8]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xB8]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xB8, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xB8]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0xB8, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xB8]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0xB8, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADD231PD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xB8, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADD231PD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMADD231PD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMADDPD(Instruction):
    """Fused Multiply-Add of Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMADDPD(xmm, xmm, xmm, xmm/m128)    [FMA4]
            * VFMADDPD(xmm, xmm, xmm/m128, xmm)    [FMA4]
            * VFMADDPD(ymm, ymm, ymm, ymm/m256)    [FMA4]
            * VFMADDPD(ymm, ymm, ymm/m256, ymm)    [FMA4]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMADDPD, self).__init__("VFMADDPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VFMADDPD\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.fma4])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x69, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x69, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_m128(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x81, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x69]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x69]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_ymm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0x69, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0x69, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_m256(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x85, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x69]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]) and is_ymm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x69]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VFMADDPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMSUB132PD(Instruction):
    """Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMSUB132PD(xmm, xmm, xmm/m128)              [FMA3]
            * VFMSUB132PD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512F and AVX512VL]
            * VFMSUB132PD(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFMSUB132PD(ymm, ymm, ymm/m256)              [FMA3]
            * VFMSUB132PD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512F and AVX512VL]
            * VFMSUB132PD(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFMSUB132PD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512F]
            * VFMSUB132PD(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFMSUB132PD(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMSUB132PD, self).__init__("VFMSUB132PD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x9A, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x9A]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0x9A, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x85, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x9A]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x9A]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x9A, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x9A]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x9A, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x9A]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x9A, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUB132PD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x9A, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUB132PD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMSUB132PD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMSUB213PD(Instruction):
    """Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMSUB213PD(xmm, xmm, xmm/m128)              [FMA3]
            * VFMSUB213PD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512F and AVX512VL]
            * VFMSUB213PD(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFMSUB213PD(ymm, ymm, ymm/m256)              [FMA3]
            * VFMSUB213PD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512F and AVX512VL]
            * VFMSUB213PD(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFMSUB213PD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512F]
            * VFMSUB213PD(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFMSUB213PD(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMSUB213PD, self).__init__("VFMSUB213PD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0xAA, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xAA]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0xAA, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x85, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xAA]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xAA]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xAA, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xAA]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0xAA, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xAA]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0xAA, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUB213PD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xAA, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUB213PD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMSUB213PD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMSUB231PD(Instruction):
    """Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMSUB231PD(xmm, xmm, xmm/m128)              [FMA3]
            * VFMSUB231PD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512F and AVX512VL]
            * VFMSUB231PD(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFMSUB231PD(ymm, ymm, ymm/m256)              [FMA3]
            * VFMSUB231PD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512F and AVX512VL]
            * VFMSUB231PD(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFMSUB231PD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512F]
            * VFMSUB231PD(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFMSUB231PD(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMSUB231PD, self).__init__("VFMSUB231PD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0xBA, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xBA]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0xBA, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x85, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xBA]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xBA]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xBA, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xBA]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0xBA, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xBA]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0xBA, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUB231PD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xBA, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUB231PD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMSUB231PD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMSUBPD(Instruction):
    """Fused Multiply-Subtract of Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMSUBPD(xmm, xmm, xmm, xmm/m128)    [FMA4]
            * VFMSUBPD(xmm, xmm, xmm/m128, xmm)    [FMA4]
            * VFMSUBPD(ymm, ymm, ymm, ymm/m256)    [FMA4]
            * VFMSUBPD(ymm, ymm, ymm/m256, ymm)    [FMA4]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMSUBPD, self).__init__("VFMSUBPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VFMSUBPD\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.fma4])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x6D, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x6D, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_m128(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x81, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x6D]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x6D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_ymm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0x6D, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0x6D, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_m256(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x85, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x6D]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]) and is_ymm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x6D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VFMSUBPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMADD132PD(Instruction):
    """Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMADD132PD(xmm, xmm, xmm/m128)              [FMA3]
            * VFNMADD132PD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512F and AVX512VL]
            * VFNMADD132PD(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFNMADD132PD(ymm, ymm, ymm/m256)              [FMA3]
            * VFNMADD132PD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512F and AVX512VL]
            * VFNMADD132PD(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFNMADD132PD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512F]
            * VFNMADD132PD(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFNMADD132PD(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMADD132PD, self).__init__("VFNMADD132PD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x9C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x9C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0x9C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x85, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x9C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x9C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x9C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x9C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x9C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x9C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x9C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMADD132PD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x9C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMADD132PD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFNMADD132PD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMADD213PD(Instruction):
    """Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMADD213PD(xmm, xmm, xmm/m128)              [FMA3]
            * VFNMADD213PD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512F and AVX512VL]
            * VFNMADD213PD(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFNMADD213PD(ymm, ymm, ymm/m256)              [FMA3]
            * VFNMADD213PD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512F and AVX512VL]
            * VFNMADD213PD(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFNMADD213PD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512F]
            * VFNMADD213PD(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFNMADD213PD(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMADD213PD, self).__init__("VFNMADD213PD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0xAC, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xAC]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0xAC, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x85, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xAC]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xAC]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xAC, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xAC]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0xAC, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xAC]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0xAC, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMADD213PD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xAC, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMADD213PD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFNMADD213PD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMADD231PD(Instruction):
    """Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMADD231PD(xmm, xmm, xmm/m128)              [FMA3]
            * VFNMADD231PD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512F and AVX512VL]
            * VFNMADD231PD(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFNMADD231PD(ymm, ymm, ymm/m256)              [FMA3]
            * VFNMADD231PD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512F and AVX512VL]
            * VFNMADD231PD(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFNMADD231PD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512F]
            * VFNMADD231PD(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFNMADD231PD(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMADD231PD, self).__init__("VFNMADD231PD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0xBC, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xBC]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0xBC, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x85, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xBC]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xBC]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xBC, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xBC]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0xBC, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xBC]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0xBC, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMADD231PD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xBC, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMADD231PD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFNMADD231PD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMADDPD(Instruction):
    """Fused Negative Multiply-Add of Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMADDPD(xmm, xmm, xmm, xmm/m128)    [FMA4]
            * VFNMADDPD(xmm, xmm, xmm/m128, xmm)    [FMA4]
            * VFNMADDPD(ymm, ymm, ymm, ymm/m256)    [FMA4]
            * VFNMADDPD(ymm, ymm, ymm/m256, ymm)    [FMA4]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMADDPD, self).__init__("VFNMADDPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VFNMADDPD\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.fma4])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x79, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x79, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_m128(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x81, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x79]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x79]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_ymm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0x79, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0x79, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_m256(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x85, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x79]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]) and is_ymm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x79]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VFNMADDPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMSUB132PD(Instruction):
    """Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMSUB132PD(xmm, xmm, xmm/m128)              [FMA3]
            * VFNMSUB132PD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512F and AVX512VL]
            * VFNMSUB132PD(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFNMSUB132PD(ymm, ymm, ymm/m256)              [FMA3]
            * VFNMSUB132PD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512F and AVX512VL]
            * VFNMSUB132PD(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFNMSUB132PD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512F]
            * VFNMSUB132PD(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFNMSUB132PD(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMSUB132PD, self).__init__("VFNMSUB132PD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x9E, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x9E]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0x9E, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x85, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x9E]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x9E]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x9E, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x9E]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x9E, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x9E]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x9E, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMSUB132PD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x9E, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMSUB132PD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFNMSUB132PD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMSUB213PD(Instruction):
    """Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMSUB213PD(xmm, xmm, xmm/m128)              [FMA3]
            * VFNMSUB213PD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512F and AVX512VL]
            * VFNMSUB213PD(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFNMSUB213PD(ymm, ymm, ymm/m256)              [FMA3]
            * VFNMSUB213PD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512F and AVX512VL]
            * VFNMSUB213PD(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFNMSUB213PD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512F]
            * VFNMSUB213PD(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFNMSUB213PD(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMSUB213PD, self).__init__("VFNMSUB213PD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0xAE, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xAE]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0xAE, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x85, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xAE]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xAE]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xAE, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xAE]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0xAE, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xAE]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0xAE, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMSUB213PD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xAE, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMSUB213PD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFNMSUB213PD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMSUB231PD(Instruction):
    """Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMSUB231PD(xmm, xmm, xmm/m128)              [FMA3]
            * VFNMSUB231PD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512F and AVX512VL]
            * VFNMSUB231PD(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFNMSUB231PD(ymm, ymm, ymm/m256)              [FMA3]
            * VFNMSUB231PD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512F and AVX512VL]
            * VFNMSUB231PD(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFNMSUB231PD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512F]
            * VFNMSUB231PD(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFNMSUB231PD(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMSUB231PD, self).__init__("VFNMSUB231PD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0xBE, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xBE]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0xBE, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x85, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xBE]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xBE]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xBE, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xBE]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0xBE, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xBE]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0xBE, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMSUB231PD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xBE, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFNMSUB231PD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFNMSUB231PD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFNMSUBPD(Instruction):
    """Fused Negative Multiply-Subtract of Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFNMSUBPD(xmm, xmm, xmm, xmm/m128)    [FMA4]
            * VFNMSUBPD(xmm, xmm, xmm/m128, xmm)    [FMA4]
            * VFNMSUBPD(ymm, ymm, ymm, ymm/m256)    [FMA4]
            * VFNMSUBPD(ymm, ymm, ymm/m256, ymm)    [FMA4]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFNMSUBPD, self).__init__("VFNMSUBPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VFNMSUBPD\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.fma4])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x7D, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x7D, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_m128(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x81, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x7D]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x7D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_ymm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0x7D, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0x7D, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_m256(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x85, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x7D]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]) and is_ymm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x7D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VFNMSUBPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMADDSUB132PS(Instruction):
    """Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMADDSUB132PS(xmm, xmm, xmm/m128)              [FMA3]
            * VFMADDSUB132PS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512F and AVX512VL]
            * VFMADDSUB132PS(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFMADDSUB132PS(ymm, ymm, ymm/m256)              [FMA3]
            * VFMADDSUB132PS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VFMADDSUB132PS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFMADDSUB132PS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VFMADDSUB132PS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFMADDSUB132PS(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMADDSUB132PS, self).__init__("VFMADDSUB132PS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x96, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x96]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0x96, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x96]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x96]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x96, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x96]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x96, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x96]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x96, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADDSUB132PS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x96, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADDSUB132PS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMADDSUB132PS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMADDSUB213PS(Instruction):
    """Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMADDSUB213PS(xmm, xmm, xmm/m128)              [FMA3]
            * VFMADDSUB213PS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512F and AVX512VL]
            * VFMADDSUB213PS(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFMADDSUB213PS(ymm, ymm, ymm/m256)              [FMA3]
            * VFMADDSUB213PS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VFMADDSUB213PS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFMADDSUB213PS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VFMADDSUB213PS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFMADDSUB213PS(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMADDSUB213PS, self).__init__("VFMADDSUB213PS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0xA6, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xA6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0xA6, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xA6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xA6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xA6, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xA6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0xA6, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xA6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0xA6, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADDSUB213PS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xA6, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADDSUB213PS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMADDSUB213PS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMADDSUB231PS(Instruction):
    """Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMADDSUB231PS(xmm, xmm, xmm/m128)              [FMA3]
            * VFMADDSUB231PS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512F and AVX512VL]
            * VFMADDSUB231PS(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFMADDSUB231PS(ymm, ymm, ymm/m256)              [FMA3]
            * VFMADDSUB231PS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VFMADDSUB231PS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFMADDSUB231PS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VFMADDSUB231PS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFMADDSUB231PS(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMADDSUB231PS, self).__init__("VFMADDSUB231PS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0xB6, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xB6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0xB6, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xB6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xB6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xB6, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xB6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0xB6, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xB6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0xB6, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADDSUB231PS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xB6, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADDSUB231PS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMADDSUB231PS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMADDSUBPS(Instruction):
    """Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMADDSUBPS(xmm, xmm, xmm, xmm/m128)    [FMA4]
            * VFMADDSUBPS(xmm, xmm, xmm/m128, xmm)    [FMA4]
            * VFMADDSUBPS(ymm, ymm, ymm, ymm/m256)    [FMA4]
            * VFMADDSUBPS(ymm, ymm, ymm/m256, ymm)    [FMA4]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMADDSUBPS, self).__init__("VFMADDSUBPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VFMADDSUBPS\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.fma4])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x5C, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x5C, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_m128(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x81, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x5C]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x5C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_ymm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0x5C, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0x5C, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_m256(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x85, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x5C]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]) and is_ymm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x5C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VFMADDSUBPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMSUBADD132PS(Instruction):
    """Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMSUBADD132PS(xmm, xmm, xmm/m128)              [FMA3]
            * VFMSUBADD132PS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512F and AVX512VL]
            * VFMSUBADD132PS(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFMSUBADD132PS(ymm, ymm, ymm/m256)              [FMA3]
            * VFMSUBADD132PS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VFMSUBADD132PS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFMSUBADD132PS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VFMSUBADD132PS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFMSUBADD132PS(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMSUBADD132PS, self).__init__("VFMSUBADD132PS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x97, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x97]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0x97, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x97]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x97]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x97, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x97]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x97, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x97]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x97, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUBADD132PS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x97, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUBADD132PS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMSUBADD132PS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMSUBADD213PS(Instruction):
    """Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMSUBADD213PS(xmm, xmm, xmm/m128)              [FMA3]
            * VFMSUBADD213PS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512F and AVX512VL]
            * VFMSUBADD213PS(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFMSUBADD213PS(ymm, ymm, ymm/m256)              [FMA3]
            * VFMSUBADD213PS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VFMSUBADD213PS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFMSUBADD213PS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VFMSUBADD213PS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFMSUBADD213PS(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMSUBADD213PS, self).__init__("VFMSUBADD213PS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0xA7, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xA7]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0xA7, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xA7]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xA7]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xA7, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xA7]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0xA7, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xA7]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0xA7, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUBADD213PS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xA7, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUBADD213PS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMSUBADD213PS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMSUBADD231PS(Instruction):
    """Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMSUBADD231PS(xmm, xmm, xmm/m128)              [FMA3]
            * VFMSUBADD231PS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512F and AVX512VL]
            * VFMSUBADD231PS(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFMSUBADD231PS(ymm, ymm, ymm/m256)              [FMA3]
            * VFMSUBADD231PS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VFMSUBADD231PS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFMSUBADD231PS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VFMSUBADD231PS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFMSUBADD231PS(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMSUBADD231PS, self).__init__("VFMSUBADD231PS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0xB7, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xB7]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0xB7, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xB7]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xB7]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xB7, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xB7]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0xB7, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xB7]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0xB7, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUBADD231PS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xB7, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUBADD231PS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMSUBADD231PS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMSUBADDPS(Instruction):
    """Fused Multiply-Alternating Subtract/Add of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMSUBADDPS(xmm, xmm, xmm, xmm/m128)    [FMA4]
            * VFMSUBADDPS(xmm, xmm, xmm/m128, xmm)    [FMA4]
            * VFMSUBADDPS(ymm, ymm, ymm, ymm/m256)    [FMA4]
            * VFMSUBADDPS(ymm, ymm, ymm/m256, ymm)    [FMA4]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMSUBADDPS, self).__init__("VFMSUBADDPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VFMSUBADDPS\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.fma4])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x5E, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x5E, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_m128(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x81, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x5E]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x5E]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_ymm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0x5E, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0x5E, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_m256(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x85, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x5E]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]) and is_ymm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x5E]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VFMSUBADDPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMADDSUB132PD(Instruction):
    """Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMADDSUB132PD(xmm, xmm, xmm/m128)              [FMA3]
            * VFMADDSUB132PD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512F and AVX512VL]
            * VFMADDSUB132PD(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFMADDSUB132PD(ymm, ymm, ymm/m256)              [FMA3]
            * VFMADDSUB132PD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512F and AVX512VL]
            * VFMADDSUB132PD(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFMADDSUB132PD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512F]
            * VFMADDSUB132PD(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFMADDSUB132PD(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMADDSUB132PD, self).__init__("VFMADDSUB132PD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x96, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x96]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0x96, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x85, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x96]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x96]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x96, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x96]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x96, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x96]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x96, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADDSUB132PD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x96, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADDSUB132PD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMADDSUB132PD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMADDSUB213PD(Instruction):
    """Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMADDSUB213PD(xmm, xmm, xmm/m128)              [FMA3]
            * VFMADDSUB213PD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512F and AVX512VL]
            * VFMADDSUB213PD(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFMADDSUB213PD(ymm, ymm, ymm/m256)              [FMA3]
            * VFMADDSUB213PD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512F and AVX512VL]
            * VFMADDSUB213PD(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFMADDSUB213PD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512F]
            * VFMADDSUB213PD(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFMADDSUB213PD(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMADDSUB213PD, self).__init__("VFMADDSUB213PD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0xA6, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xA6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0xA6, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x85, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xA6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xA6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xA6, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xA6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0xA6, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xA6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0xA6, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADDSUB213PD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xA6, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADDSUB213PD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMADDSUB213PD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMADDSUB231PD(Instruction):
    """Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMADDSUB231PD(xmm, xmm, xmm/m128)              [FMA3]
            * VFMADDSUB231PD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512F and AVX512VL]
            * VFMADDSUB231PD(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFMADDSUB231PD(ymm, ymm, ymm/m256)              [FMA3]
            * VFMADDSUB231PD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512F and AVX512VL]
            * VFMADDSUB231PD(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFMADDSUB231PD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512F]
            * VFMADDSUB231PD(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFMADDSUB231PD(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMADDSUB231PD, self).__init__("VFMADDSUB231PD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0xB6, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xB6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0xB6, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x85, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xB6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xB6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xB6, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xB6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0xB6, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xB6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0xB6, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADDSUB231PD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xB6, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMADDSUB231PD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMADDSUB231PD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMADDSUBPD(Instruction):
    """Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMADDSUBPD(xmm, xmm, xmm, xmm/m128)    [FMA4]
            * VFMADDSUBPD(xmm, xmm, xmm/m128, xmm)    [FMA4]
            * VFMADDSUBPD(ymm, ymm, ymm, ymm/m256)    [FMA4]
            * VFMADDSUBPD(ymm, ymm, ymm/m256, ymm)    [FMA4]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMADDSUBPD, self).__init__("VFMADDSUBPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VFMADDSUBPD\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.fma4])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x5D, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x5D, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_m128(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x81, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x5D]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x5D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_ymm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0x5D, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0x5D, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_m256(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x85, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x5D]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]) and is_ymm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x5D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VFMADDSUBPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMSUBADD132PD(Instruction):
    """Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMSUBADD132PD(xmm, xmm, xmm/m128)              [FMA3]
            * VFMSUBADD132PD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512F and AVX512VL]
            * VFMSUBADD132PD(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFMSUBADD132PD(ymm, ymm, ymm/m256)              [FMA3]
            * VFMSUBADD132PD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512F and AVX512VL]
            * VFMSUBADD132PD(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFMSUBADD132PD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512F]
            * VFMSUBADD132PD(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFMSUBADD132PD(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMSUBADD132PD, self).__init__("VFMSUBADD132PD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x97, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x97]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0x97, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x85, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x97]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x97]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x97, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x97]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x97, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x97]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x97, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUBADD132PD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x97, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUBADD132PD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMSUBADD132PD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMSUBADD213PD(Instruction):
    """Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMSUBADD213PD(xmm, xmm, xmm/m128)              [FMA3]
            * VFMSUBADD213PD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512F and AVX512VL]
            * VFMSUBADD213PD(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFMSUBADD213PD(ymm, ymm, ymm/m256)              [FMA3]
            * VFMSUBADD213PD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512F and AVX512VL]
            * VFMSUBADD213PD(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFMSUBADD213PD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512F]
            * VFMSUBADD213PD(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFMSUBADD213PD(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMSUBADD213PD, self).__init__("VFMSUBADD213PD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0xA7, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xA7]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0xA7, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x85, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xA7]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xA7]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xA7, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xA7]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0xA7, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xA7]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0xA7, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUBADD213PD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xA7, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUBADD213PD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMSUBADD213PD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMSUBADD231PD(Instruction):
    """Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMSUBADD231PD(xmm, xmm, xmm/m128)              [FMA3]
            * VFMSUBADD231PD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512F and AVX512VL]
            * VFMSUBADD231PD(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VFMSUBADD231PD(ymm, ymm, ymm/m256)              [FMA3]
            * VFMSUBADD231PD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512F and AVX512VL]
            * VFMSUBADD231PD(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
            * VFMSUBADD231PD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512F]
            * VFMSUBADD231PD(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VFMSUBADD231PD(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMSUBADD231PD, self).__init__("VFMSUBADD231PD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0xB7, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xB7]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0xB7, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x85, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xB7]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.fma3])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xB7]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xB7, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xB7]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0xB7, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xB7]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0xB7, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUBADD231PD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xB7, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (True, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFMSUBADD231PD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFMSUBADD231PD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFMSUBADDPD(Instruction):
    """Fused Multiply-Alternating Subtract/Add of Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFMSUBADDPD(xmm, xmm, xmm, xmm/m128)    [FMA4]
            * VFMSUBADDPD(xmm, xmm, xmm/m128, xmm)    [FMA4]
            * VFMSUBADDPD(ymm, ymm, ymm, ymm/m256)    [FMA4]
            * VFMSUBADDPD(ymm, ymm, ymm/m256, ymm)    [FMA4]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFMSUBADDPD, self).__init__("VFMSUBADDPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VFMSUBADDPD\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.fma4])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x5F, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x5F, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_m128(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x81, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x5F]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x5F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_ymm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0x5F, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0x5F, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_m256(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x85, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x5F]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]) and is_ymm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x5F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VFMSUBADDPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


