/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.Header;
import com.sun.jndi.dns.ResourceRecord;
import java.util.Vector;
import javax.naming.CommunicationException;
import javax.naming.NamingException;

class ResourceRecords {
    Vector question = new Vector();
    Vector answer = new Vector();
    Vector authority = new Vector();
    Vector additional = new Vector();
    boolean zoneXfer;

    ResourceRecords(byte[] byArray, int n, Header header, boolean bl) throws NamingException {
        if (bl) {
            this.answer.ensureCapacity(8192);
        }
        this.zoneXfer = bl;
        this.add(byArray, n, header);
    }

    int getFirstAnsType() {
        if (this.answer.size() == 0) {
            return -1;
        }
        return ((ResourceRecord)this.answer.firstElement()).getType();
    }

    int getLastAnsType() {
        if (this.answer.size() == 0) {
            return -1;
        }
        return ((ResourceRecord)this.answer.lastElement()).getType();
    }

    void add(byte[] byArray, int n, Header header) throws NamingException {
        int n2 = 12;
        try {
            ResourceRecord resourceRecord;
            int n3;
            for (n3 = 0; n3 < header.numQuestions; ++n3) {
                resourceRecord = new ResourceRecord(byArray, n, n2, true, false);
                if (!this.zoneXfer) {
                    this.question.addElement(resourceRecord);
                }
                n2 += resourceRecord.size();
            }
            for (n3 = 0; n3 < header.numAnswers; ++n3) {
                resourceRecord = new ResourceRecord(byArray, n, n2, false, !this.zoneXfer);
                this.answer.addElement(resourceRecord);
                n2 += resourceRecord.size();
            }
            if (this.zoneXfer) {
                return;
            }
            for (n3 = 0; n3 < header.numAuthorities; ++n3) {
                resourceRecord = new ResourceRecord(byArray, n, n2, false, true);
                this.authority.addElement(resourceRecord);
                n2 += resourceRecord.size();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new CommunicationException("DNS error: corrupted message");
        }
    }
}

