/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.x86;

import sun.jvm.hotspot.asm.Instruction;
import sun.jvm.hotspot.asm.x86.ArithmeticDecoder;
import sun.jvm.hotspot.asm.x86.CallDecoder;
import sun.jvm.hotspot.asm.x86.InstructionDecoder;
import sun.jvm.hotspot.asm.x86.JmpDecoder;
import sun.jvm.hotspot.asm.x86.LogicalDecoder;
import sun.jvm.hotspot.asm.x86.RotateDecoder;
import sun.jvm.hotspot.asm.x86.SSEInstructionDecoder;
import sun.jvm.hotspot.asm.x86.SSEShiftDecoder;
import sun.jvm.hotspot.asm.x86.ShiftDecoder;
import sun.jvm.hotspot.asm.x86.X86InstructionFactory;

public class GRPDecoder
extends InstructionDecoder {
    private final int number;
    private static final InstructionDecoder[][] grpTable = new InstructionDecoder[][]{{new ArithmeticDecoder("addb", 1, 1, 2, 1, 0), new LogicalDecoder("orb", 1, 1, 2, 1, 9), new ArithmeticDecoder("adcb", 1, 1, 2, 1, 1), new ArithmeticDecoder("sbbb", 1, 1, 2, 1, 3), new LogicalDecoder("andb", 1, 1, 2, 1, 8), new ArithmeticDecoder("subb", 1, 1, 2, 1, 2), new LogicalDecoder("xorb", 1, 1, 2, 1, 13), new InstructionDecoder("cmpb", 1, 1, 2, 1)}, {new ArithmeticDecoder("addS", 1, 2, 2, 2, 0), new LogicalDecoder("orS", 1, 2, 2, 2, 9), new ArithmeticDecoder("adcS", 1, 2, 2, 2, 1), new ArithmeticDecoder("sbbS", 1, 2, 2, 2, 3), new LogicalDecoder("andS", 1, 2, 2, 2, 8), new ArithmeticDecoder("subS", 1, 2, 2, 2, 2), new LogicalDecoder("xorS", 1, 2, 2, 2, 13), new InstructionDecoder("cmpS", 1, 2, 2, 2)}, {new ArithmeticDecoder("addS", 1, 2, 2, 1, 0), new LogicalDecoder("orS", 1, 2, 2, 1, 9), new ArithmeticDecoder("adcS", 1, 2, 2, 1, 1), new ArithmeticDecoder("sbbS", 1, 2, 2, 1, 3), new LogicalDecoder("andS", 1, 2, 2, 1, 8), new ArithmeticDecoder("subS", 1, 2, 2, 1, 2), new LogicalDecoder("xorS", 1, 2, 2, 1, 13), new InstructionDecoder("cmpS", 1, 2, 2, 1)}, {new RotateDecoder("rolb", 1, 1, 2, 1), new RotateDecoder("rorb", 1, 1, 2, 1), new RotateDecoder("rclb", 1, 1, 2, 1), new RotateDecoder("rcrb", 1, 1, 2, 1), new ShiftDecoder("shlb", 1, 1, 2, 1, 17), new ShiftDecoder("shrb", 1, 1, 2, 1, 15), null, new ShiftDecoder("sarb", 1, 1, 2, 1, 16)}, {new RotateDecoder("rolS", 1, 2, 2, 1), new RotateDecoder("rorS", 1, 2, 2, 1), new RotateDecoder("rclS", 1, 2, 2, 1), new RotateDecoder("rcrS", 1, 2, 2, 1), new ShiftDecoder("shlS", 1, 2, 2, 1, 17), new ShiftDecoder("shrS", 1, 2, 2, 1, 15), null, new ShiftDecoder("sarS", 1, 2, 2, 1, 16)}, {new RotateDecoder("rolb", 1, 1), new RotateDecoder("rorb", 1, 1), new RotateDecoder("rclb", 1, 1), new RotateDecoder("rcrb", 1, 1), new ShiftDecoder("shlb", 1, 1, 17), new ShiftDecoder("shrb", 1, 1, 15), null, new ShiftDecoder("sarb", 1, 1, 16)}, {new RotateDecoder("rolS", 1, 2), new RotateDecoder("rorS", 1, 2), new RotateDecoder("rclS", 1, 2), new RotateDecoder("rcrS", 1, 2), new ShiftDecoder("shlS", 1, 2, 17), new ShiftDecoder("shrS", 1, 2, 15), null, new ShiftDecoder("sarS", 1, 2, 16)}, {new RotateDecoder("rolb", 1, 1, 6, 17), new RotateDecoder("rorb", 1, 1, 6, 17), new RotateDecoder("rclb", 1, 1, 6, 17), new RotateDecoder("rcrb", 1, 1, 6, 17), new ShiftDecoder("shlb", 1, 1, 6, 17, 17), new ShiftDecoder("shrb", 1, 1, 6, 17, 15), null, new ShiftDecoder("sarb", 1, 1, 6, 17, 16)}, {new RotateDecoder("rolS", 1, 2, 6, 17), new RotateDecoder("rorS", 1, 2, 6, 17), new RotateDecoder("rclS", 1, 2, 6, 17), new RotateDecoder("rcrS", 1, 2, 6, 17), new ShiftDecoder("shlS", 1, 2, 6, 17, 17), new ShiftDecoder("shrS", 1, 2, 6, 17, 15), null, new ShiftDecoder("sarS", 1, 2, 6, 17, 16)}, {new InstructionDecoder("testb", 1, 1, 2, 1), null, new LogicalDecoder("notb", 1, 1, 10), new InstructionDecoder("negb", 1, 1), new ArithmeticDecoder("mulb", 6, 16, 1, 1, 5), new ArithmeticDecoder("imulb", 6, 16, 1, 1, 4), new ArithmeticDecoder("divb", 6, 16, 1, 1, 7), new ArithmeticDecoder("idivb", 6, 16, 1, 1, 6)}, {new InstructionDecoder("testS", 1, 2, 2, 2), null, new LogicalDecoder("notS", 1, 2, 10), new InstructionDecoder("negS", 1, 2), new ArithmeticDecoder("mulS", 6, 0, 1, 2, 5), new ArithmeticDecoder("imulS", 6, 0, 1, 2, 4), new ArithmeticDecoder("divS", 6, 0, 1, 2, 6), new ArithmeticDecoder("idivS", 6, 0, 1, 2, 6)}, {new ArithmeticDecoder("incb", 1, 1, 0), new ArithmeticDecoder("decb", 1, 1, 2), null, null, null, null, null, null}, {new ArithmeticDecoder("incS", 1, 2, 0), new ArithmeticDecoder("decS", 1, 2, 2), new CallDecoder("call", 1, 2), new CallDecoder("lcall", 1, 5), new JmpDecoder("jmp", 1, 2), new JmpDecoder("ljmp", 1, 5), new InstructionDecoder("pushS", 1, 2), null}, {new InstructionDecoder("sldt", 1, 3), new InstructionDecoder("str", 1, 3), new InstructionDecoder("lldt", 1, 3), new InstructionDecoder("ltr", 1, 3), new InstructionDecoder("verr", 1, 3), new InstructionDecoder("verw", 1, 3), null, null}, {new InstructionDecoder("sgdt", 1, 3), new InstructionDecoder("sidt", 1, 3), new InstructionDecoder("lgdt", 1, 3), new InstructionDecoder("lidt", 1, 3), new InstructionDecoder("smsw", 1, 3), null, new InstructionDecoder("lmsw", 1, 3), new InstructionDecoder("invlpg", 1, 3)}, {null, null, null, null, new InstructionDecoder("btS", 1, 2, 2, 1), new InstructionDecoder("btsS", 1, 2, 2, 1), new InstructionDecoder("btrS", 1, 2, 2, 1), new InstructionDecoder("btcS", 1, 2, 2, 1)}, {null, new SSEInstructionDecoder("cmpxch8b", 19, 11), null, null, null, null, null, null}, {null, null, new SSEShiftDecoder("psrlw", 22, 11, 2, 1, 15), null, new SSEShiftDecoder("psraw", 22, 11, 2, 1, 16), null, new SSEShiftDecoder("psllw", 22, 11, 2, 1, 17), null}, {null, null, new SSEShiftDecoder("psrld", 22, 11, 2, 1, 15), null, new SSEShiftDecoder("psrad", 22, 11, 2, 1, 16), null, new SSEShiftDecoder("pslld", 22, 11, 2, 1, 17), null}, {null, null, new SSEShiftDecoder("psrlq", 22, 11, 2, 1, 15), null, null, null, new SSEShiftDecoder("psllq", 22, 11, 2, 1, 17), null}, {new SSEInstructionDecoder("fxsave"), new SSEInstructionDecoder("fxrstor"), new SSEInstructionDecoder("ldmxcsr"), new SSEInstructionDecoder("stmxcsr"), null, null, null, new SSEInstructionDecoder("clflush")}, {new SSEInstructionDecoder("prefetchnta"), new SSEInstructionDecoder("prefetcht0"), new SSEInstructionDecoder("prefetcht1"), new SSEInstructionDecoder("prefetcht2"), null, null, null, null}, {null, null, new SSEShiftDecoder("psrlw", 22, 6, 2, 1, 15), null, new SSEShiftDecoder("psraw", 22, 6, 2, 1, 16), null, new SSEShiftDecoder("psllw", 22, 6, 2, 1, 17), null}, {null, null, new SSEShiftDecoder("psrld", 19, 6, 2, 1, 15), null, new SSEShiftDecoder("psrad", 19, 6, 2, 1, 16), null, new SSEShiftDecoder("pslld", 19, 6, 2, 1, 17), null}, {null, null, new SSEShiftDecoder("psrlq", 19, 6, 2, 1, 15), new SSEShiftDecoder("psrldq", 19, 6, 2, 1, 15), null, null, new SSEShiftDecoder("psllq", 19, 6, 2, 1, 17), new SSEShiftDecoder("psllq", 19, 6, 2, 1, 17)}};

    public GRPDecoder(String name, int number) {
        super(name);
        this.number = number;
    }

    @Override
    public Instruction decode(byte[] bytesArray, int index, int instrStartIndex, int segmentOverride, int prefixes, X86InstructionFactory factory) {
        this.byteIndex = index;
        this.instrStartIndex = instrStartIndex;
        this.prefixes = prefixes;
        int ModRM = GRPDecoder.readByte(bytesArray, this.byteIndex);
        int reg = ModRM >> 3 & 7;
        InstructionDecoder instrDecoder = grpTable[this.number][reg];
        Instruction instr = null;
        if (instrDecoder != null) {
            instr = instrDecoder.decode(bytesArray, this.byteIndex, instrStartIndex, segmentOverride, prefixes, factory);
            this.byteIndex = instrDecoder.getCurrentIndex();
        } else {
            instr = factory.newIllegalInstruction();
        }
        return instr;
    }
}

