#!/bin/sh

if test -f /usr/sbin/pkg; then
    # FreeBSD
    LUAC=`which luac53`
else
    #
    # IMPORTANT
    #
    # Keep the version in sync with ntopng/third-party/lua-5.4.Y
    # otherwise the generated bytecode won't be interpreted
    #
    LUAC=`which luac5.4`
fi

MV=`which mv`
TMP_FILE="/tmp/luac.out"

if [ "$#" -ne 1 ]; then    
    echo "Usage: luac.sh <filename>"
    echo ""
    echo "This tool replaces a lua file with its bytecode"
    exit
fi


$LUAC -o /tmp/luac.out $1

if test -f $TMP_FILE; then
    $MV /tmp/luac.out $1
fi


