//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// TVRAM モニタ (LUNA ではビットマップモニタ)
//

#pragma once

#include "wxscreenmonitor.h"
#include <array>

class BT45xDevice;
class PlaneVRAMDevice;
class VideoCtlrDevice;

// テキスト画面パネル
class WXTVRAMPanel : public WXScreenPanel
{
	using inherited = WXScreenPanel;

 public:
	explicit WXTVRAMPanel(wxWindow *parent);
	~WXTVRAMPanel() override;

	void EnablePlane(int plane, bool value);
	void EnablePalette(bool value);

 private:
	void Draw() override;

	void OnPaletteChanged(wxCommandEvent& event);
	void GenPalette();

	std::array<Color, 256> pal {};
	uint32 planemask {};
	bool apply_palette {};

	BT45xDevice *bt45x {};
	PlaneVRAMDevice *planevram {};
	VideoCtlrDevice *videoctlr {};
};

// テキスト画面ウィンドウ
class WXTVRAMWindow : public WXScreenWindow
{
	using inherited = WXScreenWindow;

 public:
	WXTVRAMWindow(wxWindow *parent, const wxString& name);
	~WXTVRAMWindow() override;

 private:
	void UpdateInfo(TextScreen&, int px, int py) override;

	void OnPlane(wxCommandEvent&);
	void DoPlane(int plane, bool value);
	void OnApplyPalette(wxCommandEvent&);
	void DoApplyPalette(bool value);

	PlaneVRAMDevice *planevram {};

	// イベントテーブル
	wxDECLARE_EVENT_TABLE();
};
