//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// スクリーンモニタ
//

#pragma once

#include "wxbitmappanel.h"
#include "wxsubwindow.h"

class WXScrollBar;

// スクリーンパネル (共通部)
class WXScreenPanel : public WXBitmapPanel
{
	using inherited = WXBitmapPanel;

 public:
	WXScreenPanel(wxWindow *parent);
	~WXScreenPanel() override;

	int GetVirtualWidth() const			{ return virtual_width; }
	int GetVirtualHeight() const		{ return virtual_height; }
	const wxPoint& GetCursor() const	{ return cursor; }

	void SetScale(int new_scale);

	void OnScroll(wxScrollEvent&);

	// 現在表示中のビュー (virtual_size 座標系)
	Rect view {};

 protected:
	// コンストラクタの後半。
	void Ctor(int screen_width_, int screen_height_);

	void OnMouseMove(wxMouseEvent&);
	void OnMouseWheel(wxMouseEvent&);

	// 拡大前のビットマップの大きさ (TVRAM なら 1024x1024 など)
	int plane_width {};
	int plane_height {};

	// 拡大後のビットマップの大きさ
	int virtual_width {};
	int virtual_height {};
	// 倍率
	int scale {};

	// マウスカーソルがこのパネル上にあればその座標。拡大前ビットマップ座標系。
	// マウスカーソルがパネル外なら wxDefaultPosition とする。
	wxPoint cursor {};

	// イベントテーブル
	wxDECLARE_EVENT_TABLE();
};

// スクリーンモニタウィンドウ (共通部)
class WXScreenWindow : public WXSubWindow
{
	using inherited = WXSubWindow;

 public:
	WXScreenWindow(wxWindow *parent, const wxString& name);
	~WXScreenWindow() override;

	bool Layout() override;

	// 縦スクロールバーの位置を設定する。(パネルから呼ばれる)
	void SetVScrollPosition(int);

 protected:
	// コンストラクタの共通部。
	void Ctor();

	// ステータス部の更新。
	virtual void UpdateInfo(TextScreen&, int px, int py) = 0;

	void OnScale(wxCommandEvent&);
	void DoScale(int scale_index_);
	void OnTimer(wxTimerEvent&);

	bool GetMySizeHints(wxSize *, wxSize *, wxSize *, wxSize *) override;
	void SetScroll();

	// コントロールパネル
	wxPanel *ctrlpanel {};
	// ステータスパネル
	WXTextScreen *statuspanel {};
	WXBitmapPanel *spacer {};	// ステータスパネル右の空き地用
	// グラフィックパネル
	WXScreenPanel *viewpanel {};
	WXScrollBar *vscroll {};
	WXScrollBar *hscroll {};
	WXBitmapPanel *corner {};	// 右下の空き地

	// タイマー
	wxTimer timer {};

	// イベントテーブル
	wxDECLARE_EVENT_TABLE();
};
