//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// PEDEC
//

#pragma once

#include "interrupt.h"

class PEDECDevice : public InterruptDevice
{
	using inherited = InterruptDevice;

	static const uint32 baseaddr = 0xe9c000;

 public:
	// SPC からの割り込みはここでマスク制御しないので intmap_enable には
	// IntmapSPC を常に立てておくこと。
	static const uint32 IntmapSPC	= 0x1000;
	static const uint32 IntmapFDC	= 0x0080;
	static const uint32 IntmapFDD0	= 0x0800;
	static const uint32 IntmapFDD1	= 0x0400;
	static const uint32 IntmapFDD2	= 0x0200;
	static const uint32 IntmapFDD3	= 0x0100;
	static const uint32 IntmapFDD	= 0x0f00;	// FDD(0|1|2|3)
	static const uint32 IntmapHDD	= 0x0020;
	static const uint32 IntmapPRT	= 0x0010;

 public:
	PEDECDevice();
	~PEDECDevice() override;

	bool Init() override;
	void ResetHard(bool poweron) override;

	// InterruptDevice インタフェース
	busdata InterruptAcknowledge(int lv) override;

	// 割り込みコントローラからのモニタ表示
	void MonitorScreen(TextScreen& screen, uint intr_level, int y);

 protected:
	// BusIO インタフェース
	static const uint32 NPORT = 8;
	busdata ReadPort(uint32 offset);
	busdata WritePort(uint32 offset, uint32 data);
	busdata PeekPort(uint32 offset);
	bool PokePort(uint32 offset, uint32 data);

 private:
	// 割り込みステータスレジスタの値を取得
	uint32 GetStat() const;

	// 割り込み信号線の状態を変える
	void ChangeInterrupt() override;

	uint8 vector {};

	InterruptDevice *interrupt {};
};

inline PEDECDevice *GetPEDECDevice() {
	return Object::GetObject<PEDECDevice>(OBJ_PEDEC);
}
