//
// nono
// Copyright (C) 2025 nono project
// Licensed under nono-license.txt
//

//
// サウンドの NetBSD audio(4) ドライバ
//

#pragma once

#include "sounddriver.h"
#include "autofd.h"

class SoundDriverNetBSD : public SoundDriver
{
	using inherited = SoundDriver;
 public:
	explicit SoundDriverNetBSD(HostDevice *hostdev_);
	~SoundDriverNetBSD() override;

	bool InitDriver(bool startup = true) override;

	void Write(const int16 *) override;

	void MonitorScreenMD(TextScreen&, int y) override;

 private:
	autofd fd {};

	std::string device {};		// デバイスパス
};
