//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// UI スレッドへのメッセージ機構 (GUI 側)
//

#pragma once

#include "wxnono.h"
#include "uimessage.h"

wxDECLARE_EVENT(NONO_EVT_UIMESSAGE, wxCommandEvent);

class WXUIMessage
{
 public:
	// VM からの UIMessage を wxWidgets のイベントハンドラに接続する
	static void Connect(UIMessage::ID id, wxEvtHandler *win,
		wxObjectEventFunction function);

	// イベントハンドラの接続を解除する
	static void Disconnect(UIMessage::ID id, wxEvtHandler *win,
		wxObjectEventFunction function);

	// UIMessage のコールバック。
	// (呼び出し元スレッドで実行される)
	static void Process(uint id, int arg);

	// すべてのハンドラが解除されているかチェックする (開発用)
	static void AssertAllDisconnected();
};
