//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// 独自スクロールバー
//

#pragma once

#include "wxtextpanel.h"

wxDECLARE_EVENT(NONO_EVT_SCROLL, wxScrollEvent);

class WXScrollBar : public WXTextPanel
{
	using inherited = WXTextPanel;

 public:
	WXScrollBar(wxWindow *parent, wxWindowID id, long style);
	~WXScrollBar() override;

	void FontChanged() override;
	void Fit() override;

	void SetScrollParam(int thumbsize_, int range_, int pagesize_) {
		SetScrollParam(GetThumbPosition(), thumbsize_, range_, pagesize_);
	}
	void SetScrollParam(int pos_, int thumbsize_, int range_, int pagesize_);

	bool SetThumbPosition(int pos_);

	int GetThumbPosition() const { return thumbpos; }
	int GetThumbSize() const { return thumbsize; }
	int GetRange() const { return range; }

	void Draw() override;

 private:
	void OnSize(wxSizeEvent& event);
	void OnMouse(wxMouseEvent& event);
	void OnTimer(wxTimerEvent& event);

	// つまみの位置を変更する (内部用)
	void MoveThumb(int pos_);

	int PosCmp() const;

	bool is_vertical {};
	// スクロール領域の太さというか従方向の長さ。
	// 縦スクロールバーなら横幅、横スクロールバーなら高さ。
	int subpx {};

	int thumbpos {};	// つまみの上(左)位置
	int thumbsize {};	// つまみのサイズ
	int thumbmin {};	// つまみの最小サイズ
	int range {};		// スクロール領域の高さ(幅)
	int pagesize {};	// ページアップ、ダウンの移動量

	int p1 {};			// つまみの上(左)ピクセル座標
	int p2 {};			// つまみの下(右)ピクセル座標(開区間)
	int range_px {};	// スクロール領域の高さ(幅)ピクセル

	int start_thumb;	// ドラッグ開始時のつまみの位置
	int start_px {};	// ドラッグ開始時のピクセル座標

	int mouse_px {};	// 直近のマウスカーソルのピクセル座標
	bool left_click {};	// 左クリック継続中か

	wxTimer timer {};

	wxDECLARE_EVENT_TABLE();
};
