//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// LUNA LCD パネル、モニタ
//

#pragma once

#include "wxsubwindow.h"
#include "wxbitmappanel.h"
#include "wxmonitor.h"

class LCDDevice;

// LUNA 前面 LCD パネル
class WXLCDPanel : public WXTextPanel
{
	using inherited = WXTextPanel;
 public:
	explicit WXLCDPanel(wxWindow *parent);
	~WXLCDPanel() override;

	void FontChanged() override;

 private:
	void OnLCDChanged(wxCommandEvent& event);
	void Draw() override;
	void DrawChar(int x, int y, uint8 ch);

	const uint8 *ddram {};

	int unit {};
	int u_width {};
	int u_height {};

	LCDDevice *lcd {};
};

// LUNA 前面 LCD ウィンドウ
class WXLCDWindow : public WXSubWindow
{
	using inherited = WXSubWindow;
 public:
	explicit WXLCDWindow(wxWindow *parent);
	~WXLCDWindow() override;
};

// モニタの LCD キャラクタ部パネル
class WXLCDCharPanel : public WXTextPanel
{
	using inherited = WXTextPanel;
 public:
	explicit WXLCDCharPanel(wxWindow *parent);
	~WXLCDCharPanel() override;

	void FontChanged() override;

 private:
	void Draw() override;

	int unit {};
	int u_width {};
	int u_height {};

	LCDDevice *lcd {};
};

// LCD モニタウィンドウ
class WXLCDMonitor : public WXSubWindow
{
	using inherited = WXSubWindow;
 public:
	explicit WXLCDMonitor(wxWindow *parent);
	~WXLCDMonitor() override;

	void FontChanged() override;
	bool Layout() override;

 private:
	WXMonitorPanel *monpanel {};
	WXLCDCharPanel *chrpanel {};
	WXBitmapPanel *space {};
};
